/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class RowBoundsPlugin
extends PluginAdapter {
    private FullyQualifiedJavaType rowBounds = new FullyQualifiedJavaType("org.apache.ibatis.session.RowBounds");
    private Map<FullyQualifiedTable, List<XmlElement>> elementsToAdd = new HashMap<FullyQualifiedTable, List<XmlElement>>();

    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndAddMethod(method, interfaze);
        }
        return true;
    }

    @Override
    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndAddMethod(method, interfaze);
        }
        return true;
    }

    @Override
    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndSaveElement(element, introspectedTable.getFullyQualifiedTable());
        }
        return true;
    }

    @Override
    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndSaveElement(element, introspectedTable.getFullyQualifiedTable());
        }
        return true;
    }

    @Override
    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        List<XmlElement> elements = this.elementsToAdd.get(introspectedTable.getFullyQualifiedTable());
        if (elements != null) {
            for (XmlElement element : elements) {
                document.getRootElement().addElement(element);
            }
        }
        return true;
    }

    private void copyAndAddMethod(Method method, Interface interfaze) {
        Method newMethod = new Method(method);
        newMethod.setName(method.getName() + "WithRowbounds");
        newMethod.addParameter(new Parameter(this.rowBounds, "rowBounds"));
        interfaze.addMethod(newMethod);
        interfaze.addImportedType(this.rowBounds);
    }

    private void copyAndSaveElement(XmlElement element, FullyQualifiedTable fqt) {
        List<XmlElement> elements;
        XmlElement newElement = new XmlElement(element);
        Iterator<Attribute> iterator = newElement.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!"id".equals(attribute.getName())) continue;
            iterator.remove();
            Attribute newAttribute = new Attribute("id", attribute.getValue() + "WithRowbounds");
            newElement.addAttribute(newAttribute);
            break;
        }
        if ((elements = this.elementsToAdd.get(fqt)) == null) {
            elements = new ArrayList<XmlElement>();
            this.elementsToAdd.put(fqt, elements);
        }
        elements.add(newElement);
    }
}

