/*
 *  Copyright 2009 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.mybatis.generator.codegen.mybatis3.model;

import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.*;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import static org.mybatis.generator.internal.util.JavaBeansUtil.getGetterMethodName;
import static org.mybatis.generator.internal.util.JavaBeansUtil.getValidPropertyName;
import static org.mybatis.generator.internal.util.StringUtility.stringHasValue;
import static org.mybatis.generator.internal.util.messages.Messages.getString;


/**
 * @author Jeff Butler
 */
public class ExampleGenerator extends AbstractJavaGenerator {

    public ExampleGenerator() {
        super();
    }

    @Override
    public List<CompilationUnit> getCompilationUnits() {
        FullyQualifiedTable table = introspectedTable.getFullyQualifiedTable();
        progressCallback.startTask(getString("Progress.6", table.toString()));
        CommentGenerator commentGenerator = context.getCommentGenerator();

        FullyQualifiedJavaType type = new FullyQualifiedJavaType(introspectedTable.getExampleType());
        TopLevelClass topLevelClass = new TopLevelClass(type);
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType superType = new FullyQualifiedJavaType(context.getBaseExampleName());
        topLevelClass.setSuperClass(superType);
        topLevelClass.addImportedType(superType);
        commentGenerator.addJavaFileComment(topLevelClass);

        // add default constructor
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setConstructor(true);
        method.setName(type.getShortName());
        method.addBodyLine("super();");
        method.addBodyLine("tableName = \"" + introspectedTable.getActualTableName().getTableName() + "\";");
        method.addBodyLine("tableAlias = \"" + introspectedTable.getFullyQualifiedTable().getAlias() + "\";");
        method.addBodyLine("ignoreCase = false;");
        //method.addBodyLine("leftJoinTableSet = new HashSet<String>();");

        commentGenerator.addGeneralMethodComment(method, introspectedTable);
        topLevelClass.addMethod(method);

        // add by suman start
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {

            IntrospectedColumn introspectedImportColumn = introspectedColumn.getIntrospectedImportColumn();
            if (introspectedImportColumn == null) {
                continue;
            }
            IntrospectedTable introspectedImportTable = introspectedImportColumn.getIntrospectedTable();
            if (introspectedImportTable.equals(introspectedTable)) {
                continue;
            }
            method = getCreateOtherExampleColumnsMethod(introspectedImportTable);
            commentGenerator.addGeneralMethodComment(method, introspectedTable);
            topLevelClass.addMethod(method);
            topLevelClass.addMethod(getAndOtherExampleCriteriaMethod(introspectedImportTable));
            topLevelClass.addMethod(getOrOtherExampleCriteriaMethod(introspectedImportTable));
            topLevelClass.addMethod(getAndOtherExampleCriteriaMethodWithCriteria(introspectedImportTable));
        }


        // add by suman end

        // add field, getter, setter for orderby clause
		/*Field field = new Field();
		field.setVisibility(JavaVisibility.PROTECTED);
		field.setType(FullyQualifiedJavaType.getStringInstance());
		field.setName("orderByClause");
		commentGenerator.addFieldComment(field, introspectedTable);
		topLevelClass.addField(field);
		*/
		
/*
		method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setName("setOrderByClause");
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "orderByClause"));
		method.addBodyLine("this.orderByClause = orderByClause;");
		commentGenerator.addGeneralMethodComment(method, introspectedTable);
		topLevelClass.addMethod(method);*/

		/*method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setReturnType(FullyQualifiedJavaType.getStringInstance());
		method.setName("getOrderByClause");
		method.addBodyLine("return orderByClause;");
		commentGenerator.addGeneralMethodComment(method, introspectedTable);
		topLevelClass.addMethod(method);
*/
        // add field, getter, setter for distinct
		/*field = new Field();
		field.setVisibility(JavaVisibility.PROTECTED);
		field.setType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
		field.setName("distinct");
		commentGenerator.addFieldComment(field, introspectedTable);
		topLevelClass.addField(field);*/

	/*	method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setName("setDistinct");
		method.addParameter(new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "distinct"));
		method.addBodyLine("this.distinct = distinct;");
		commentGenerator.addGeneralMethodComment(method, introspectedTable);
		topLevelClass.addMethod(method);*/

		/*method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
		method.setName("isDistinct");
		method.addBodyLine("return distinct;");
		commentGenerator.addGeneralMethodComment(method, introspectedTable);
		topLevelClass.addMethod(method);
*/
        // add field and methods for the list of ored criteria
	/*	field = new Field();
		field.setVisibility(JavaVisibility.PROTECTED);

		FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.List<Criteria>");
		field.setType(fqjt);
		field.setName("oredCriteria");
		commentGenerator.addFieldComment(field, introspectedTable);
		topLevelClass.addField(field);*/

	/*	delete by suman
	 * method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setReturnType(fqjt);
		method.setName("getOredCriteria");
		method.addBodyLine("return oredCriteria;");
		commentGenerator.addGeneralMethodComment(method, introspectedTable);
		topLevelClass.addMethod(method);*/

		/*method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setName("or");
		method.addParameter(new Parameter(FullyQualifiedJavaType.getCriteriaInstance(), "criteria"));
		method.addBodyLine("oredCriteria.add(criteria);");
		commentGenerator.addGeneralMethodComment(method, introspectedTable);
		topLevelClass.addMethod(method);
*/
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("or");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = createCriteriaInternal();");
        method.addBodyLine("oredCriteria.add(criteria);");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, introspectedTable);
        topLevelClass.addMethod(method);

        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("createCriteria");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = createCriteriaInternal();");
        method.addBodyLine("if (oredCriteria.size() == 0) {");
        method.addBodyLine("oredCriteria.add(criteria);");
        method.addBodyLine("}");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, introspectedTable);
        topLevelClass.addMethod(method);

        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("createCriteriaInternal");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = new Criteria(this.tableName,this.ignoreCase);");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, introspectedTable);
        topLevelClass.addMethod(method);

        // add by suman start

        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("createColumns");
        method.setReturnType(FullyQualifiedJavaType.getColumnContainerInstance());
        method.addBodyLine("ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);");
        method.addBodyLine("if(columnContainer == null){");
        method.addBodyLine("columnContainer = new ColumnContainer(this.tableName);");
        method.addBodyLine("columnContainerMap.put(this.tableName,columnContainer);");
        method.addBodyLine("}");
        method.addBodyLine("return (ColumnContainer)columnContainer;");
        commentGenerator.addGeneralMethodComment(method, introspectedTable);
        topLevelClass.addMethod(method);

        // add by suman end

		/*method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setName("clear");
		method.addBodyLine("oredCriteria.clear();");
		method.addBodyLine("orderByClause = null;");
		method.addBodyLine("distinct = false;");
		commentGenerator.addGeneralMethodComment(method, introspectedTable);
		topLevelClass.addMethod(method);*/

        // now generate the inner class that holds the AND conditions
        topLevelClass.addInnerClass(getCriteriaInnerClass(topLevelClass));

        //topLevelClass.addInnerClass(getCriteriaInnerClass(topLevelClass));

        //topLevelClass.addInnerClass(getCriterionInnerClass(topLevelClass));

        topLevelClass.addInnerClass(getColumnContainerClass(topLevelClass));


        List<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (context.getPlugins().modelExampleClassGenerated(topLevelClass, introspectedTable)) {
            answer.add(topLevelClass);
        }
        return answer;
    }

    private Method getCreateOtherExampleColumnsMethod(IntrospectedTable introspectedImportTable) {
        FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getExampleType());
        StringBuffer sb = new StringBuffer();
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        sb.append("create");
        sb.append(importType.getShortName().replace("Example", ""));
        sb.append("Columns");
        method.setName(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".ColumnContainer");
        method.setReturnType(new FullyQualifiedJavaType(sb.toString()), false);
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(" ");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(" = new ");
        sb.append(importType.getShortName());
        sb.append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".ColumnContainer columnContainer = (");
        sb.append(importType.getShortName());
        sb.append(".ColumnContainer) columnContainerMap.get(");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(".getTableName());");
        method.addBodyLine(sb.toString());
        method.addBodyLine(" if(columnContainer == null){");
        sb.setLength(0);
        sb.append("columnContainer = ");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(".createColumns();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append("columnContainerMap.put(");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(".getTableName(),columnContainer);");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        method.addBodyLine("}");
        method.addBodyLine("leftJoinTableSet.add(columnContainer.getTableName());");
        method.addBodyLine("return columnContainer;");
        return method;
    }

    private Method getAndOtherExampleCriteriaMethod(IntrospectedTable introspectedImportTable) {
        FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getExampleType());
        StringBuffer sb = new StringBuffer();
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        sb.append("and");
        sb.append(importType.getShortName().replace("Example", ""));
        sb.append("Criteria");
        method.setName(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria");
        method.setReturnType(new FullyQualifiedJavaType(sb.toString()), false);
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(" ");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(" = new ");
        sb.append(importType.getShortName());
        sb.append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria criteria = ");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(".createCriteria();");
        method.addBodyLine(sb.toString());
        method.addBodyLine("Criteria myCriteria = null;");
        method.addBodyLine("if (oredCriteria.size() == 0) {");
        method.addBodyLine("myCriteria =  createCriteriaInternal();");
        method.addBodyLine("oredCriteria.add(myCriteria);");
        method.addBodyLine("}else{");
        method.addBodyLine("myCriteria =  (Criteria)oredCriteria.get(0);");
        method.addBodyLine("}");
        method.addBodyLine("leftJoinTableSet.add(criteria.getTableName());");
        method.addBodyLine("criteria.setAllCriteria(myCriteria.getAllCriteria());");
        method.addBodyLine("return criteria;");
        return method;
    }

    private Method getAndOtherExampleCriteriaMethodWithCriteria(IntrospectedTable introspectedImportTable) {
        FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getExampleType());
        StringBuffer sb = new StringBuffer();
        Method method = new Method();
        method.addParameter(new Parameter(new FullyQualifiedJavaType("Criteria"), "criteria"));
        method.setVisibility(JavaVisibility.PUBLIC);
        sb.append("and");
        sb.append(importType.getShortName().replace("Example", ""));
        sb.append("Criteria");
        method.setName(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria");
        method.setReturnType(new FullyQualifiedJavaType(sb.toString()), false);
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(" ");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(" = new ");
        sb.append(importType.getShortName());
        sb.append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria newCriteria = ");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(".createCriteria();");
        method.addBodyLine(sb.toString());
        method.addBodyLine("leftJoinTableSet.add(newCriteria.getTableName());");
        method.addBodyLine("newCriteria.setAllCriteria(criteria.getAllCriteria());");
        method.addBodyLine("return newCriteria;");
        return method;
    }

    private Method getOrOtherExampleCriteriaMethod(IntrospectedTable introspectedImportTable) {
        FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getExampleType());
        StringBuffer sb = new StringBuffer();
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        sb.append("or");
        sb.append(importType.getShortName().replace("Example", ""));
        sb.append("Criteria");
        method.setName(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria");
        method.setReturnType(new FullyQualifiedJavaType(sb.toString()), false);
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(" ");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(" = new ");
        sb.append(importType.getShortName());
        sb.append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria criteria = ");
        sb.append(getValidPropertyName(importType.getShortName()));
        sb.append(".createCriteria();");
        method.addBodyLine(sb.toString());
        method.addBodyLine("leftJoinTableSet.add(criteria.getTableName());");
        method.addBodyLine("oredCriteria.add(criteria);");
        method.addBodyLine("return criteria;");
        return method;
    }

    private InnerClass getColumnContainerClass(TopLevelClass topLevelClass) {
        Field field;
        Method method;

        InnerClass answer = new InnerClass(FullyQualifiedJavaType.getColumnContainerInstance());

        answer.setVisibility(JavaVisibility.PUBLIC);

        answer.setStatic(true);
        answer.setSuperClass(FullyQualifiedJavaType.getColumnContainerBaseInstance());
        context.getCommentGenerator().addClassComment(answer, introspectedTable);

        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("ColumnContainer");
        method.setConstructor(true);
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "tableName"));
        method.addBodyLine("super(tableName);");
        // add by suman start
        //method.addBodyLine("columnContainerStr = new StringBuffer();");
        // add by suman end
        answer.addMethod(method);


/*		// now columnList the isValid method
		method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setName("isValid");
		method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
		
		method.addBodyLine("return columnContainerStr.length() > 0;");
		answer.addMethod(method);


		//��Ӵ���getAllColumn���������
		method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setName("getAllColumn");
		method.setReturnType(FullyQualifiedJavaType.getStringBufferInstance());
		method.addBodyLine("return columnContainerStr;");
		answer.addMethod(method);*/


	
		/*field = new Field();
		field.setVisibility(JavaVisibility.PROTECTED);
		field.setType(FullyQualifiedJavaType.getStringBufferInstance());
		field.setName("columnContainerStr");
		answer.addField(field);
		method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setReturnType(field.getType());
		method.setName(getGetterMethodName(field.getName(), field.getType()));
		method.addBodyLine("return columnContainerStr;");
		answer.addMethod(method);*/
		/*
		method = new Method();
		method.setVisibility(JavaVisibility.PRIVATE);
		method.setName("addColumnStr");
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "column"));
		method.addBodyLine("if (columnContainerStr.length() > 0) {");
		method.addBodyLine("columnContainerStr.append(\",\");");
		method.addBodyLine("}");
		method.addBodyLine("columnContainerStr.append(column);");

		answer.addMethod(method);*/

        // add by suman end


        for (IntrospectedColumn introspectedColumn : introspectedTable.getNonBLOBColumns()) {
            topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());

            answer.addMethod(getHasColumnMethod(introspectedColumn));


        }

        return answer;
    }

	/*
	 * delete by suman
	 * private InnerClass getCriterionInnerClass(TopLevelClass topLevelClass) {
		Field field;
		Method method;

		InnerClass answer = new InnerClass(new FullyQualifiedJavaType("Criterion"));
		answer.setVisibility(JavaVisibility.PUBLIC);
		answer.setStatic(true);
		context.getCommentGenerator().addClassComment(answer, introspectedTable);

		field = new Field();
		field.setName("condition");
		field.setType(FullyQualifiedJavaType.getStringInstance());
		field.setVisibility(JavaVisibility.PRIVATE);
		answer.addField(field);
		answer.addMethod(getGetter(field));

		field = new Field();
		field.setName("value");
		field.setType(FullyQualifiedJavaType.getObjectInstance());
		field.setVisibility(JavaVisibility.PRIVATE);
		answer.addField(field);
		answer.addMethod(getGetter(field));

		field = new Field();
		field.setName("secondValue");
		field.setType(FullyQualifiedJavaType.getObjectInstance());
		field.setVisibility(JavaVisibility.PRIVATE);
		answer.addField(field);
		answer.addMethod(getGetter(field));

		field = new Field();
		field.setName("noValue");
		field.setType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
		field.setVisibility(JavaVisibility.PRIVATE);
		answer.addField(field);
		answer.addMethod(getGetter(field));

		field = new Field();
		field.setName("singleValue");
		field.setType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
		field.setVisibility(JavaVisibility.PRIVATE);
		answer.addField(field);
		answer.addMethod(getGetter(field));

		field = new Field();
		field.setName("betweenValue");
		field.setType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
		field.setVisibility(JavaVisibility.PRIVATE);
		answer.addField(field);
		answer.addMethod(getGetter(field));

		field = new Field();
		field.setName("listValue");
		field.setType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
		field.setVisibility(JavaVisibility.PRIVATE);
		answer.addField(field);
		answer.addMethod(getGetter(field));

		field = new Field();
		field.setName("typeHandler");
		field.setType(FullyQualifiedJavaType.getStringInstance());
		field.setVisibility(JavaVisibility.PRIVATE);
		answer.addField(field);
		answer.addMethod(getGetter(field));

		method = new Method();
		method.setVisibility(JavaVisibility.PROTECTED);
		method.setName("Criterion");
		method.setConstructor(true);
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
		method.addBodyLine("super();");
		method.addBodyLine("this.condition = condition;");
		method.addBodyLine("this.typeHandler = null;");
		method.addBodyLine("this.noValue = true;");
		answer.addMethod(method);

		method = new Method();
		method.setVisibility(JavaVisibility.PROTECTED);
		method.setName("Criterion");
		method.setConstructor(true);
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
		method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "typeHandler"));
		method.addBodyLine("super();");
		method.addBodyLine("this.condition = condition;");
		method.addBodyLine("this.value = value;");
		method.addBodyLine("this.typeHandler = typeHandler;");
		method.addBodyLine("if (value instanceof List<?>) {");
		method.addBodyLine("this.listValue = true;");
		method.addBodyLine("} else {");
		method.addBodyLine("this.singleValue = true;");
		method.addBodyLine("}");
		answer.addMethod(method);

		method = new Method();
		method.setVisibility(JavaVisibility.PROTECTED);
		method.setName("Criterion");
		method.setConstructor(true);
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
		method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
		method.addBodyLine("this(condition, value, null);");
		answer.addMethod(method);

		method = new Method();
		method.setVisibility(JavaVisibility.PROTECTED);
		method.setName("Criterion");
		method.setConstructor(true);
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
		method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
		method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "secondValue"));
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "typeHandler"));
		method.addBodyLine("super();");
		method.addBodyLine("this.condition = condition;");
		method.addBodyLine("this.value = value;");
		method.addBodyLine("this.secondValue = secondValue;");
		method.addBodyLine("this.typeHandler = typeHandler;");
		method.addBodyLine("this.betweenValue = true;");
		answer.addMethod(method);

		method = new Method();
		method.setVisibility(JavaVisibility.PROTECTED);
		method.setName("Criterion");
		method.setConstructor(true);
		method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
		method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
		method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "secondValue"));
		method.addBodyLine("this(condition, value, secondValue, null);");
		answer.addMethod(method);

		return answer;
	}*/

	/*private InnerClass getCriteriaInnerClass(TopLevelClass topLevelClass) {
		Method method;

		InnerClass answer = new InnerClass(FullyQualifiedJavaType.getCriteriaInstance());

		answer.setVisibility(JavaVisibility.PUBLIC);
		answer.setStatic(true);
		answer.setSuperClass(FullyQualifiedJavaType.getGeneratedCriteriaInstance());

		context.getCommentGenerator().addClassComment(answer, introspectedTable, true);

		method = new Method();
		method.setVisibility(JavaVisibility.PROTECTED);
		method.setName("Criteria");
		method.setConstructor(true);
		method.addBodyLine("super();");
		answer.addMethod(method);

		return answer;
	}*/

    private InnerClass getCriteriaInnerClass(TopLevelClass topLevelClass) {
        Field field;
        Method method;

        InnerClass answer = new InnerClass(FullyQualifiedJavaType.getCriteriaInstance());

        answer.setVisibility(JavaVisibility.PUBLIC);
        answer.setStatic(true);
        answer.setSuperClass(FullyQualifiedJavaType.getGeneratedCriteriaInstance());
        context.getCommentGenerator().addClassComment(answer, introspectedTable);

        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("Criteria");
        method.setConstructor(true);
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "tableName"));
        method.addBodyLine("super(tableName);");
        //method.addBodyLine("criteria = new ArrayList<Criterion>();");
        method.addBodyLine("tableName = \"" + introspectedTable.getActualTableName().getTableName() + "\";");
        answer.addMethod(method);

        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("Criteria");
        method.setConstructor(true);
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "tableName"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "ignoreCase"));
        method.addBodyLine("this(tableName);");
        method.addBodyLine("this.ignoreCase = ignoreCase;");
        answer.addMethod(method);

        List<String> criteriaLists = new ArrayList<String>();
        criteriaLists.add("criteria");

        for (IntrospectedColumn introspectedColumn : introspectedTable.getNonBLOBColumns()) {
            if (stringHasValue(introspectedColumn.getTypeHandler())) {
                String name = addtypeHandledObjectsAndMethods(introspectedColumn, method, answer);
                criteriaLists.add(name);
            }
        }

        // now generate the isValid method
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("isValid");
        method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        StringBuilder sb = new StringBuilder();
        Iterator<String> strIter = criteriaLists.iterator();
        sb.append("return ");
        sb.append(strIter.next());
        sb.append(".size() > 0");
        if (!strIter.hasNext()) {
            sb.append(';');
        }
        method.addBodyLine(sb.toString());
        while (strIter.hasNext()) {
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append("|| ");
            sb.append(strIter.next());
            sb.append(".size() > 0");
            if (!strIter.hasNext()) {
                sb.append(';');
            }
            method.addBodyLine(sb.toString());
        }
        answer.addMethod(method);

        // now generate the getAllCriteria method
        if (criteriaLists.size() > 1) {
            field = new Field();
            field.setName("allCriteria");
            field.setType(new FullyQualifiedJavaType("List<Criterion>"));
            field.setVisibility(JavaVisibility.PROTECTED);
            answer.addField(field);
        }

        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("getAllCriteria");
        method.setReturnType(new FullyQualifiedJavaType("List<Criterion>"));
        if (criteriaLists.size() < 2) {
            method.addBodyLine("return criteria;");
        } else {
            method.addBodyLine("if (allCriteria == null) {");
            method.addBodyLine("allCriteria = new ArrayList<Criterion>();");

            strIter = criteriaLists.iterator();
            while (strIter.hasNext()) {
                method.addBodyLine(String.format("allCriteria.addAll(%s);", strIter.next()));
            }

            method.addBodyLine("}");
            method.addBodyLine("return allCriteria;");
        }
        answer.addMethod(method);

        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("setAllCriteria");
        method.addParameter(new Parameter(new FullyQualifiedJavaType("List<Criterion>"), "criteria"));
        method.addBodyLine("this.criteria = criteria;");
        answer.addMethod(method);

        // now we need to generate the methods that will be used in the SqlMap
        // to generate the dynamic where clause
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewArrayListInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewSetInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewHashSetInstance());

		/*field = new Field();
		field.setVisibility(JavaVisibility.PROTECTED);
		FullyQualifiedJavaType listOfCriterion = new FullyQualifiedJavaType("java.util.List<Criterion>");
		field.setType(listOfCriterion);
		field.setName("criteria");
		answer.addField(field);

		method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setReturnType(field.getType());
		method.setName(getGetterMethodName(field.getName(), field.getType()));
		method.addBodyLine("return criteria;");
		answer.addMethod(method);*/

        // now add the methods for simplifying the individual field set methods
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addBodyLine("if (condition == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for condition cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine("criteria.add(new Criterion(condition));");
        if (criteriaLists.size() > 1) {
            method.addBodyLine("allCriteria = null;");
        }
        answer.addMethod(method);

        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine("criteria.add(new Criterion(condition, value,ignoreCase));");
        if (criteriaLists.size() > 1) {
            method.addBodyLine("allCriteria = null;");
        }
        answer.addMethod(method);

        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value1"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value2"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value1 == null || value2 == null) {");
        method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine("criteria.add(new Criterion(condition, value1, value2));");
        if (criteriaLists.size() > 1) {
            method.addBodyLine("allCriteria = null;");
        }
        answer.addMethod(method);

        FullyQualifiedJavaType listOfDates = new FullyQualifiedJavaType("java.util.List<java.util.Date>");

        if (introspectedTable.hasJDBCDateColumns()) {
            topLevelClass.addImportedType(FullyQualifiedJavaType.getDateInstance());
            topLevelClass.addImportedType(FullyQualifiedJavaType.getNewIteratorInstance());
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCDate");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (value == null) {");
            method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, new java.sql.Date(value.getTime()), property);");
            answer.addMethod(method);

            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCDate");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(listOfDates, "values"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (values == null || values.size() == 0) {");
            method.addBodyLine("throw new RuntimeException(\"Value list for \" + property + \" cannot be null or empty\");");
            method.addBodyLine("}");
            method.addBodyLine("List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();");
            method.addBodyLine("Iterator<Date> iter = values.iterator();");
            method.addBodyLine("while (iter.hasNext()) {");
            method.addBodyLine("dateList.add(new java.sql.Date(iter.next().getTime()));");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, dateList, property);");
            answer.addMethod(method);

            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCDate");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value1"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value2"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (value1 == null || value2 == null) {");
            method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);");
            answer.addMethod(method);
        }

        if (introspectedTable.hasJDBCTimeColumns()) {
            topLevelClass.addImportedType(FullyQualifiedJavaType.getDateInstance());
            topLevelClass.addImportedType(FullyQualifiedJavaType.getNewIteratorInstance());
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCTime");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (value == null) {");
            method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, new java.sql.Time(value.getTime()), property);");
            answer.addMethod(method);

            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCTime");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(listOfDates, "values"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (values == null || values.size() == 0) {");
            method.addBodyLine("throw new RuntimeException(\"Value list for \" + property + \" cannot be null or empty\");");
            method.addBodyLine("}");
            method.addBodyLine("List<java.sql.Time> timeList = new ArrayList<java.sql.Time>();");
            method.addBodyLine("Iterator<Date> iter = values.iterator();");
            method.addBodyLine("while (iter.hasNext()) {");
            method.addBodyLine("timeList.add(new java.sql.Time(iter.next().getTime()));");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, timeList, property);");
            answer.addMethod(method);

            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCTime");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value1"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value2"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (value1 == null || value2 == null) {");
            method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, new java.sql.Time(value1.getTime()), new java.sql.Time(value2.getTime()), property);");
            answer.addMethod(method);
        }

        for (IntrospectedColumn introspectedColumn : introspectedTable.getNonBLOBColumns()) {
            topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());

            // here we need to add the individual methods for setting the
            // conditions for a field
            answer.addMethod(getSetNullMethod(introspectedColumn));
            answer.addMethod(getSetNotNullMethod(introspectedColumn));
            answer.addMethod(getSetEqualMethod(introspectedColumn));
            answer.addMethod(getSetNotEqualMethod(introspectedColumn));
            answer.addMethod(getSetGreaterThanMethod(introspectedColumn));
            answer.addMethod(getSetGreaterThenOrEqualMethod(introspectedColumn));
            answer.addMethod(getSetLessThanMethod(introspectedColumn));
            answer.addMethod(getSetLessThanOrEqualMethod(introspectedColumn));

            if (introspectedColumn.isJdbcCharacterColumn()) {
                answer.addMethod(getSetLikeMethod(introspectedColumn));
                answer.addMethod(getSetNotLikeMethod(introspectedColumn));
            }

            answer.addMethod(getSetInOrNotInMethod(introspectedColumn, true));
            answer.addMethod(getSetInOrNotInMethod(introspectedColumn, false));
            answer.addMethod(getSetBetweenOrNotBetweenMethod(introspectedColumn, true));
            answer.addMethod(getSetBetweenOrNotBetweenMethod(introspectedColumn, false));
        }

        return answer;
    }

    private Method getSetNullMethod(IntrospectedColumn introspectedColumn) {
        return getNoValueMethod(introspectedColumn, "IsNull", "is null"); //$NON-NLS-2$
    }

    private Method getHasColumnMethod(IntrospectedColumn introspectedColumn) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "has");
        sb.append("Column");
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getColumnContainerInstance());
        sb.setLength(0);
        sb.append("addColumnStr(\"");
        sb.append(MyBatis3FormattingUtilities.getSelectListPhraseWithEscape(introspectedColumn));
        sb.append(' ');
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (ColumnContainer) this;");

        return method;
    }


    private Method getSetNotNullMethod(IntrospectedColumn introspectedColumn) {
        return getNoValueMethod(introspectedColumn, "IsNotNull", "is not null"); //$NON-NLS-2$
    }

    private Method getSetEqualMethod(IntrospectedColumn introspectedColumn) {
        return getSingleValueMethod(introspectedColumn, "EqualTo", "="); //$NON-NLS-2$
    }

    private Method getSetNotEqualMethod(IntrospectedColumn introspectedColumn) {
        return getSingleValueMethod(introspectedColumn, "NotEqualTo", "<>"); //$NON-NLS-2$
    }

    private Method getSetGreaterThanMethod(IntrospectedColumn introspectedColumn) {
        return getSingleValueMethod(introspectedColumn, "GreaterThan", ">"); //$NON-NLS-2$
    }

    private Method getSetGreaterThenOrEqualMethod(IntrospectedColumn introspectedColumn) {
        return getSingleValueMethod(introspectedColumn, "GreaterThanOrEqualTo", ">="); //$NON-NLS-2$
    }

    private Method getSetLessThanMethod(IntrospectedColumn introspectedColumn) {
        return getSingleValueMethod(introspectedColumn, "LessThan", "<"); //$NON-NLS-2$
    }

    private Method getSetLessThanOrEqualMethod(IntrospectedColumn introspectedColumn) {
        return getSingleValueMethod(introspectedColumn, "LessThanOrEqualTo", "<="); //$NON-NLS-2$
    }

    private Method getSetLikeMethod(IntrospectedColumn introspectedColumn) {
        return getSingleValueMethod(introspectedColumn, "Like", "like"); //$NON-NLS-2$
    }

    private Method getSetNotLikeMethod(IntrospectedColumn introspectedColumn) {
        return getSingleValueMethod(introspectedColumn, "NotLike", "not like"); //$NON-NLS-2$
    }

    private Method getSingleValueMethod(IntrospectedColumn introspectedColumn, String nameFragment, String operator) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append(nameFragment);
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);

        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterionForJDBCDate(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterionForJDBCTime(\"");
        } else if (stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }
        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        sb.append(' ');
        sb.append(operator);
        sb.append("\", ");
        sb.append("value");
        sb.append(", \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");

        return method;
    }

    /**
     * Generates methods that set between and not between conditions
     *
     * @param introspectedColumn
     * @param betweenMethod
     *
     * @return a generated method for the between or not between method
     */
    private Method getSetBetweenOrNotBetweenMethod(IntrospectedColumn introspectedColumn, boolean betweenMethod) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType type = introspectedColumn.getFullyQualifiedJavaType();

        method.addParameter(new Parameter(type, "value1"));
        method.addParameter(new Parameter(type, "value2"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        if (betweenMethod) {
            sb.append("Between");
        } else {
            sb.append("NotBetween");
        }
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);

        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterionForJDBCDate(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterionForJDBCTime(\"");
        } else if (stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }

        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        if (betweenMethod) {
            sb.append(" between");
        } else {
            sb.append(" not between");
        }
        sb.append("\", ");
        sb.append("value1, value2");
        sb.append(", \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");

        return method;
    }

    /**
     * @param introspectedColumn
     * @param inMethod           if true generates an "in" method, else generates a "not in"
     *                           method
     *
     * @return a generated method for the in or not in method
     */
    private Method getSetInOrNotInMethod(IntrospectedColumn introspectedColumn, boolean inMethod) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType type = FullyQualifiedJavaType.getNewListInstance();
        if (introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
            type.addTypeArgument(introspectedColumn.getFullyQualifiedJavaType().getPrimitiveTypeWrapper());
        } else {
            type.addTypeArgument(introspectedColumn.getFullyQualifiedJavaType());
        }

        method.addParameter(new Parameter(type, "values"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        if (inMethod) {
            sb.append("In");
        } else {
            sb.append("NotIn");
        }
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);

        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterionForJDBCDate(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterionForJDBCTime(\"");
        } else if (stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }

        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        if (inMethod) {
            sb.append(" in");
        } else {
            sb.append(" not in");
        }
        sb.append("\", values, \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");

        return method;
    }

    private Method getNoValueMethod(IntrospectedColumn introspectedColumn, String nameFragment, String operator) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append(nameFragment);
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        sb.append("addCriterion(\"");

        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));

        sb.append(' ');
        sb.append(operator);
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");

        return method;
    }

    /**
     * This method adds all the extra methods and fields required to support a
     * user defined type handler on some column.
     *
     * @param introspectedColumn
     * @param constructor
     * @param innerClass
     *
     * @return the name of the List added to the class by this method
     */
    private String addtypeHandledObjectsAndMethods(IntrospectedColumn introspectedColumn, Method constructor, InnerClass innerClass) {
        String answer;
        StringBuilder sb = new StringBuilder();

        // add new private field and public accessor in the class
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("Criteria");
        answer = sb.toString();

        Field field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(new FullyQualifiedJavaType("java.util.List<Criterion>"));
        field.setName(answer);
        innerClass.addField(field);

        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(getGetterMethodName(field.getName(), field.getType()));
        sb.insert(0, "return ");
        sb.append(';');
        method.addBodyLine(sb.toString());
        innerClass.addMethod(method);

        // add constructor initialization
        sb.setLength(0);
        sb.append(field.getName());
        sb.append(" = new ArrayList<Criterion>();");
        ;
        constructor.addBodyLine(sb.toString());

        // now add the methods for simplifying the individual field set methods
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        sb.setLength(0);
        sb.append("add");
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        sb.append("Criterion");

        method.setName(sb.toString());
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
        method.addBodyLine("}");

        method.addBodyLine(String.format("%s.add(new Criterion(condition, value, \"%s\"));", field.getName(), introspectedColumn.getTypeHandler()));
        method.addBodyLine("allCriteria = null;");
        innerClass.addMethod(method);

        sb.setLength(0);
        sb.append("add");
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        sb.append("Criterion");

        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName(sb.toString());
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value1"));
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value2"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        if (!introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
            method.addBodyLine("if (value1 == null || value2 == null) {");
            method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
        }

        method.addBodyLine(String.format("%s.add(new Criterion(condition, value1, value2, \"%s\"));", field.getName(), introspectedColumn.getTypeHandler()));

        method.addBodyLine("allCriteria = null;");
        innerClass.addMethod(method);

        return answer;
    }
}
