/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.codegen.AbstractGenerator;
import org.mybatis.generator.codegen.AbstractJavaClientGenerator;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.codegen.AbstractXmlGenerator;
import org.mybatis.generator.codegen.mybatis3.controller.ControllerBaseGenerator;
import org.mybatis.generator.codegen.mybatis3.controller.ControllerWebGenerator;
import org.mybatis.generator.codegen.mybatis3.javamapper.AnnotatedClientGenerator;
import org.mybatis.generator.codegen.mybatis3.javamapper.JavaMapperGenerator;
import org.mybatis.generator.codegen.mybatis3.javamapper.MixedClientGenerator;
import org.mybatis.generator.codegen.mybatis3.model.BaseRecordGenerator;
import org.mybatis.generator.codegen.mybatis3.model.BaseRecordVoBaseGenerator;
import org.mybatis.generator.codegen.mybatis3.model.BaseRecordVoGenerator;
import org.mybatis.generator.codegen.mybatis3.model.ExampleGenerator;
import org.mybatis.generator.codegen.mybatis3.model.PrimaryKeyGenerator;
import org.mybatis.generator.codegen.mybatis3.model.RecordWithBLOBsGenerator;
import org.mybatis.generator.codegen.mybatis3.service.ServiceImplGenerator;
import org.mybatis.generator.codegen.mybatis3.service.ServiceInterfaceGenerator;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.XMLMapperGenerator;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.StringUtility;

public class IntrospectedTableMyBatis3Impl
extends IntrospectedTable {
    protected List<AbstractJavaGenerator> javaModelGenerators = new ArrayList<AbstractJavaGenerator>();
    protected List<AbstractJavaGenerator> clientGenerators = new ArrayList<AbstractJavaGenerator>();
    protected AbstractXmlGenerator xmlMapperGenerator;
    protected List<AbstractJavaGenerator> serviceInterfaceGenerators = new ArrayList<AbstractJavaGenerator>();
    protected List<AbstractJavaGenerator> serviceImplGenerators = new ArrayList<AbstractJavaGenerator>();
    protected List<AbstractJavaGenerator> controllerBaseGenerators = new ArrayList<AbstractJavaGenerator>();
    protected List<AbstractJavaGenerator> controllerWebGenerators = new ArrayList<AbstractJavaGenerator>();

    public IntrospectedTableMyBatis3Impl() {
        super(IntrospectedTable.TargetRuntime.MYBATIS3);
    }

    @Override
    public void calculateGenerators(List<String> warnings, ProgressCallback progressCallback) {
        this.calculateJavaModelGenerators(warnings, progressCallback);
        AbstractJavaClientGenerator javaClientGenerator = this.calculateClientGenerators(warnings, progressCallback);
        this.calculateServiceInterfaceGenerators(warnings, progressCallback);
        this.calculateServiceImplGenerators(warnings, progressCallback);
        this.calculateControllerBaseGenerators(warnings, progressCallback);
        this.calculateControllerWebGenerators(warnings, progressCallback);
        this.calculateXmlMapperGenerator(javaClientGenerator, warnings, progressCallback);
    }

    protected void calculateXmlMapperGenerator(AbstractJavaClientGenerator javaClientGenerator, List<String> warnings, ProgressCallback progressCallback) {
        if (javaClientGenerator == null) {
            if (this.context.getSqlMapGeneratorConfiguration() != null) {
                this.xmlMapperGenerator = new XMLMapperGenerator();
            }
        } else {
            this.xmlMapperGenerator = javaClientGenerator.getMatchedXMLGenerator();
        }
        this.initializeAbstractGenerator(this.xmlMapperGenerator, warnings, progressCallback);
    }

    protected AbstractJavaClientGenerator calculateClientGenerators(List<String> warnings, ProgressCallback progressCallback) {
        if (!this.rules.generateJavaClient()) {
            return null;
        }
        AbstractJavaClientGenerator javaGenerator = this.createJavaClientGenerator();
        if (javaGenerator == null) {
            return null;
        }
        this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
        this.clientGenerators.add(javaGenerator);
        return javaGenerator;
    }

    protected AbstractJavaClientGenerator calculateServiceInterfaceGenerators(List<String> warnings, ProgressCallback progressCallback) {
        AbstractJavaClientGenerator javaGenerator = this.createServiceInterfaceGenerator();
        if (javaGenerator == null) {
            return null;
        }
        this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
        this.serviceInterfaceGenerators.add(javaGenerator);
        return javaGenerator;
    }

    protected AbstractJavaGenerator calculateServiceImplGenerators(List<String> warnings, ProgressCallback progressCallback) {
        AbstractJavaGenerator javaGenerator = this.createServiceImplGenerator();
        if (javaGenerator == null) {
            return null;
        }
        this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
        this.serviceImplGenerators.add(javaGenerator);
        return javaGenerator;
    }

    protected AbstractJavaGenerator calculateControllerBaseGenerators(List<String> warnings, ProgressCallback progressCallback) {
        AbstractJavaGenerator javaGenerator = this.createControllerBaseGenerator();
        if (javaGenerator == null) {
            return null;
        }
        this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
        this.controllerBaseGenerators.add(javaGenerator);
        return javaGenerator;
    }

    protected AbstractJavaGenerator calculateControllerWebGenerators(List<String> warnings, ProgressCallback progressCallback) {
        AbstractJavaGenerator javaGenerator = this.createControllerWebGenerator();
        if (javaGenerator == null) {
            return null;
        }
        this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
        this.controllerWebGenerators.add(javaGenerator);
        return javaGenerator;
    }

    protected AbstractJavaClientGenerator createJavaClientGenerator() {
        if (this.context.getJavaClientGeneratorConfiguration() == null) {
            return null;
        }
        String type = this.context.getJavaClientGeneratorConfiguration().getConfigurationType();
        AbstractJavaClientGenerator javaGenerator = "XMLMAPPER".equalsIgnoreCase(type) ? new JavaMapperGenerator() : ("MIXEDMAPPER".equalsIgnoreCase(type) ? new MixedClientGenerator() : ("ANNOTATEDMAPPER".equalsIgnoreCase(type) ? new AnnotatedClientGenerator() : ("MAPPER".equalsIgnoreCase(type) ? new JavaMapperGenerator() : (AbstractJavaClientGenerator)ObjectFactory.createInternalObject(type))));
        return javaGenerator;
    }

    protected AbstractJavaClientGenerator createServiceInterfaceGenerator() {
        ServiceInterfaceGenerator javaGenerator = new ServiceInterfaceGenerator();
        return javaGenerator;
    }

    protected AbstractJavaGenerator createServiceImplGenerator() {
        ServiceImplGenerator javaGenerator = new ServiceImplGenerator();
        return javaGenerator;
    }

    protected AbstractJavaGenerator createControllerBaseGenerator() {
        ControllerBaseGenerator javaGenerator = new ControllerBaseGenerator();
        return javaGenerator;
    }

    protected AbstractJavaGenerator createControllerWebGenerator() {
        ControllerWebGenerator javaGenerator = new ControllerWebGenerator();
        return javaGenerator;
    }

    protected void calculateJavaModelGenerators(List<String> warnings, ProgressCallback progressCallback) {
        AbstractJavaGenerator javaGenerator;
        if (this.getRules().generateExampleClass()) {
            javaGenerator = new ExampleGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generatePrimaryKeyClass()) {
            javaGenerator = new PrimaryKeyGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generateBaseRecordClass()) {
            javaGenerator = new BaseRecordGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
            javaGenerator = new BaseRecordVoBaseGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
            javaGenerator = new BaseRecordVoGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generateRecordWithBLOBsClass()) {
            javaGenerator = new RecordWithBLOBsGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
    }

    protected void initializeAbstractGenerator(AbstractGenerator abstractGenerator, List<String> warnings, ProgressCallback progressCallback) {
        if (abstractGenerator == null) {
            return;
        }
        abstractGenerator.setContext(this.context);
        abstractGenerator.setIntrospectedTable(this);
        abstractGenerator.setProgressCallback(progressCallback);
        abstractGenerator.setWarnings(warnings);
    }

    @Override
    public List<GeneratedJavaFile> getGeneratedJavaFiles() {
        GeneratedJavaFile gjf;
        List<CompilationUnit> compilationUnits;
        ArrayList<GeneratedJavaFile> answer = new ArrayList<GeneratedJavaFile>();
        for (AbstractJavaGenerator javaGenerator : this.javaModelGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
                answer.add(gjf);
            }
        }
        for (AbstractJavaGenerator javaGenerator : this.clientGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.context.getJavaClientGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
                answer.add(gjf);
            }
        }
        for (AbstractJavaGenerator javaGenerator : this.serviceInterfaceGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.context.getJavaClientGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
                answer.add(gjf);
            }
        }
        for (AbstractJavaGenerator javaGenerator : this.serviceImplGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.context.getJavaClientGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
                answer.add(gjf);
            }
        }
        for (AbstractJavaGenerator javaGenerator : this.controllerBaseGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.context.getJavaClientGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
                answer.add(gjf);
            }
        }
        for (AbstractJavaGenerator javaGenerator : this.controllerWebGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.context.getJavaClientGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
                answer.add(gjf);
            }
        }
        return answer;
    }

    @Override
    public List<GeneratedXmlFile> getGeneratedXmlFiles() {
        ArrayList<GeneratedXmlFile> answer = new ArrayList<GeneratedXmlFile>();
        if (this.xmlMapperGenerator != null) {
            Document document = this.xmlMapperGenerator.getDocument();
            GeneratedXmlFile gxf = new GeneratedXmlFile(document, this.getMyBatis3XmlMapperFileName(), this.getMyBatis3XmlMapperPackage(), this.context.getSqlMapGeneratorConfiguration().getTargetProject(), StringUtility.isTrue(this.context.getProperty("xmlMergeable")), this.context.getXmlFormatter());
            if (this.context.getPlugins().sqlMapGenerated(gxf, this)) {
                answer.add(gxf);
            }
        }
        return answer;
    }

    @Override
    public int getGenerationSteps() {
        return this.javaModelGenerators.size() + this.clientGenerators.size() + this.serviceInterfaceGenerators.size() + (this.xmlMapperGenerator == null ? 0 : 1);
    }

    @Override
    public boolean isJava5Targeted() {
        return true;
    }

    @Override
    public boolean requiresXMLGenerator() {
        AbstractJavaClientGenerator javaClientGenerator = this.createJavaClientGenerator();
        if (javaClientGenerator == null) {
            return false;
        }
        return javaClientGenerator.requiresXMLGenerator();
    }
}

