/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.InfoResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.ElasticsearchIndicesClient;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import co.elastic.clients.elasticsearch.indices.PutMappingResponse;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import com.viontech.keliu.configuration.elasticsearch.ESRequestFactory;
import com.viontech.keliu.configuration.elasticsearch.util.ESUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.RequestOptions;

public class ESClient {
    private ElasticsearchClient client;
    private RequestOptions options;

    public ESClient(ElasticsearchClient client, RequestOptions options) {
        this.client = client;
        this.options = options;
    }

    public final InfoResponse info() throws IOException {
        return this.client.info();
    }

    public final ElasticsearchClient getClient() {
        return this.client;
    }

    public final <T> List<T> select(T t) throws Exception {
        Field[] fields;
        Class<?> clazz = t.getClass();
        SearchRequest.Builder searchRequest = ESRequestFactory.getSearchRequest(clazz);
        SourceConfig.Builder searchSourceBuilder = new SourceConfig.Builder();
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            Class<Object> type = field.getType();
            field.setAccessible(true);
            Object value = field.get(t);
            if (Objects.isNull(value) || type.isAssignableFrom(Date.class) || type.isAssignableFrom(List.class)) continue;
            queries.add(QueryBuilders.term().field(name).value(FieldValue.of((Object)value)).build()._toQuery());
        }
        SearchResponse response = this.client.search(searchRequest.query(boolQueryBuilder.must(queries).build()._toQuery()).build(), clazz);
        HitsMetadata hits = response.hits();
        List hits1 = hits.hits();
        ArrayList<Object> results = new ArrayList<Object>();
        if (hits1.isEmpty()) {
            return results;
        }
        for (Hit hit : hits1) {
            Object t1 = hit.source();
            Field idField = clazz.getDeclaredField("id");
            if (null != idField) {
                idField.setAccessible(true);
                idField.set(t1, hit.id());
            }
            results.add(t1);
        }
        return results;
    }

    public final <T> List<T> select(T t, Date date, Integer size) throws Exception {
        Field[] fields;
        Class<?> clazz = t.getClass();
        SearchRequest.Builder searchRequest = ESRequestFactory.getSearchRequest(clazz, date);
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            Class<Object> type = field.getType();
            field.setAccessible(true);
            Object value = field.get(t);
            if (Objects.isNull(value) || type.isAssignableFrom(Date.class) || type.isAssignableFrom(List.class)) continue;
            queries.add(QueryBuilders.term().field(name).value(FieldValue.of((Object)value)).build()._toQuery());
        }
        SearchResponse response = this.client.search(searchRequest.query(boolQueryBuilder.must(queries).build()._toQuery()).build(), clazz);
        HitsMetadata hits = response.hits();
        List hits1 = hits.hits();
        ArrayList<Object> results = new ArrayList<Object>();
        if (hits1.isEmpty()) {
            return results;
        }
        for (Hit hit : hits1) {
            Object t1 = hit.source();
            String id = hit.id();
            Field idField = clazz.getDeclaredField("id");
            if (null != idField) {
                idField.setAccessible(true);
                idField.set(t1, id);
            }
            results.add(t1);
        }
        return results;
    }

    private <T> String getIndexName(T t) throws Exception {
        return ESUtil.getIndexName(t);
    }

    public final IndexResponse index(IndexRequest indexRequest) throws IOException {
        return this.client.index(indexRequest);
    }

    public final BulkResponse bulk(BulkRequest bulkRequest) throws IOException {
        return this.client.bulk(bulkRequest);
    }

    public final DeleteResponse delete(DeleteRequest deleteRequest) throws IOException {
        return this.client.delete(deleteRequest);
    }

    public final ElasticsearchIndicesClient indices() {
        return this.client.indices();
    }

    public final boolean exists(String poolId) throws IOException {
        BooleanResponse response = this.client.indices().exists(new ExistsRequest.Builder().index(poolId, new String[0]).build());
        return response.value();
    }

    public final CreateIndexResponse create(CreateIndexRequest createIndexRequest) throws IOException {
        return this.client.indices().create(createIndexRequest);
    }

    public final PutMappingResponse putMapping(PutMappingRequest putMappingRequest) throws IOException {
        return this.client.indices().putMapping(putMappingRequest);
    }

    public final UpdateByQueryResponse updateByQuery(UpdateByQueryRequest updateByQueryRequest) throws IOException {
        return this.client.updateByQuery(updateByQueryRequest);
    }

    public final DeleteByQueryResponse deleteByQuery(DeleteByQueryRequest deleteByQueryRequest) throws IOException {
        return this.client.deleteByQuery(deleteByQueryRequest);
    }
}

