/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch;

import cn.hutool.core.util.ClassUtil;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.ilm.Actions;
import co.elastic.clients.elasticsearch.ilm.GetLifecycleRequest;
import co.elastic.clients.elasticsearch.ilm.GetLifecycleResponse;
import co.elastic.clients.elasticsearch.ilm.IlmPolicy;
import co.elastic.clients.elasticsearch.ilm.Phase;
import co.elastic.clients.elasticsearch.ilm.Phases;
import co.elastic.clients.elasticsearch.ilm.PutLifecycleRequest;
import co.elastic.clients.elasticsearch.ilm.PutLifecycleResponse;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.PutIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.PutIndexTemplateResponse;
import co.elastic.clients.util.ObjectBuilder;
import com.viontech.keliu.configuration.elasticsearch.ESClient;
import com.viontech.keliu.configuration.elasticsearch.ESConfig;
import com.viontech.keliu.configuration.elasticsearch.annotation.ESPrefix;
import com.viontech.keliu.configuration.elasticsearch.annotation.Field;
import com.viontech.keliu.configuration.elasticsearch.annotation.FieldType;
import com.viontech.keliu.configuration.elasticsearch.annotation.Mapping;
import com.viontech.keliu.configuration.elasticsearch.annotation.Setting;
import com.viontech.keliu.configuration.elasticsearch.annotation.Template;
import com.viontech.keliu.configuration.elasticsearch.util.ESUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"spring.elasticsearch.rest.uris"})
public class EsInit
implements CommandLineRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EsInit.class);
    public static final String LIFECYCLE_NAME = "delete-heatmap-after-days";
    @Value(value="${delete.after.days:14}")
    private Integer deleteAfterDays;
    @Autowired
    private ESClient esClient;

    private Boolean refreshTemplateILM() throws Exception {
        try {
            Actions hotAction = new Actions.Builder().setPriority(p -> p.priority(Integer.valueOf(100))).build();
            Actions deleteAction = new Actions.Builder().delete(s -> s.deleteSearchableSnapshot(Boolean.valueOf(true))).build();
            IlmPolicy ilmPolicy = new IlmPolicy.Builder().phases(new Phases.Builder().hot(new Phase.Builder().actions(hotAction).minAge(t -> t.time("0ms")).build()).delete(new Phase.Builder().actions(deleteAction).minAge(t -> t.time(this.deleteAfterDays + "d")).build()).build()).build();
            PutLifecycleRequest request = new PutLifecycleRequest.Builder().name(LIFECYCLE_NAME).policy(ilmPolicy).build();
            PutLifecycleResponse response = this.esClient.getClient().ilm().putLifecycle(request);
            GetLifecycleResponse getResponse = this.esClient.getClient().ilm().getLifecycle(new GetLifecycleRequest.Builder().name(LIFECYCLE_NAME).build());
            if (getResponse.get(LIFECYCLE_NAME) != null) {
                log.info("delete-heatmap-after-days\u751f\u547d\u5468\u671f\u521b\u5efa\u5b8c\u6210");
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u751f\u547d\u5468\u671f\u521b\u5efa\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public void run(String ... args) throws Exception {
        if (!this.refreshTemplateILM().booleanValue()) {
            log.error("\u751f\u547d\u5468\u671f\u521b\u5efa\u5931\u8d25\uff0c\u65e0\u6cd5\u521b\u5efa\u70ed\u529b\u6a21\u677f");
            return;
        }
        Set templates = ClassUtil.scanPackageByAnnotation((String)"com.viontech", Template.class);
        for (Class clazz : templates) {
            Object templateName;
            Template annotation = clazz.getAnnotation(Template.class);
            ESPrefix prefixAnnotation = clazz.getAnnotation(ESPrefix.class);
            ArrayList<Object> patterns = new ArrayList<Object>(annotation.patterns().length);
            if (null != prefixAnnotation) {
                String[] prefix = ESUtil.getPrefix(prefixAnnotation);
                templateName = (String)prefix + "-" + annotation.templateName();
                for (String pattern : annotation.patterns()) {
                    patterns.add((String)prefix + "-" + pattern);
                }
            } else {
                templateName = annotation.templateName();
                for (String pattern : annotation.patterns()) {
                    patterns.add(pattern);
                }
            }
            HashMap<String, Property> properties = new HashMap<String, Property>();
            for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
                FieldType type = null;
                Field field1 = field.getAnnotation(Field.class);
                if (null != field1) {
                    type = field1.type();
                }
                if (type == FieldType.Keyword) {
                    Boolean indexRet = field.getType() == Integer.class ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    properties.put(field.getName(), (Property)new Property.Builder().keyword(k -> k.index(Boolean.valueOf(true))).build());
                    continue;
                }
                if (type == FieldType.Short) {
                    properties.put(field.getName(), (Property)new Property.Builder().short_(s -> s.nullValue((Number)0)).build());
                    continue;
                }
                if (type == FieldType.Double) {
                    properties.put(field.getName(), (Property)new Property.Builder().double_(s -> s.nullValue(Double.valueOf(0.0))).build());
                    continue;
                }
                if (type == FieldType.Date) {
                    properties.put(field.getName(), (Property)new Property.Builder().date(d -> d.format("date_optional_time||epoch_millis")).build());
                    continue;
                }
                if (type == FieldType.Date_Nanos) {
                    properties.put(field.getName(), (Property)new Property.Builder().dateNanos(d -> d.format("epoch_millis")).build());
                    continue;
                }
                if (type == FieldType.Float) {
                    properties.put(field.getName(), (Property)new Property.Builder().float_(d -> d.nullValue(Float.valueOf(0.0f))).build());
                    continue;
                }
                if (type == FieldType.Integer) {
                    properties.put(field.getName(), (Property)new Property.Builder().integer(d -> d.nullValue(Integer.valueOf(0))).build());
                    continue;
                }
                if (type == FieldType.Long) {
                    properties.put(field.getName(), (Property)new Property.Builder().long_(d -> d.nullValue(Long.valueOf(0L))).build());
                    continue;
                }
                Mapping mapping = field.getAnnotation(Mapping.class);
                if (null == mapping || !mapping.mappingPath().contains("Point.properties")) continue;
                properties.put(field.getName(), (Property)new Property.Builder().point(d -> (ObjectBuilder)d.docValues(Boolean.valueOf(true))).build());
            }
            TypeMapping.Builder builder = new TypeMapping.Builder().properties(properties);
            Setting setting = clazz.getAnnotation(Setting.class);
            IndexSettings.Builder indexSettingsBuilder = new IndexSettings.Builder().maxResultWindow(ESConfig.MAX_SIZE).numberOfShards(String.valueOf(setting.shards())).numberOfReplicas(String.valueOf(setting.replicas())).refreshInterval(r -> r.time(setting.refreshInterval()));
            if (setting.enableDeleted()) {
                indexSettingsBuilder.lifecycle(l -> l.name(LIFECYCLE_NAME));
            }
            PutIndexTemplateRequest request = new PutIndexTemplateRequest.Builder().name((String)templateName).template(t -> t.mappings(builder.build()).settings(indexSettingsBuilder.build())).indexPatterns(patterns).build();
            PutIndexTemplateResponse acknowledgedResponse = this.esClient.indices().putIndexTemplate(request);
            if (!acknowledgedResponse.acknowledged()) continue;
            log.info("{}\u6a21\u677f\u521b\u5efa\u5b8c\u6210", templateName);
        }
        new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(15000L);
                        this.esClient.info();
                    }
                }
                catch (Exception e) {
                    log.error("EsQueryHandler error", (Throwable)e);
                    continue;
                }
                break;
            }
        }).start();
    }
}

