/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.viontech.keliu.configuration.elasticsearch.annotation.Document;
import com.viontech.keliu.configuration.elasticsearch.annotation.ESPrefix;
import com.viontech.keliu.configuration.elasticsearch.annotation.Template;
import java.lang.reflect.Field;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ESUtil {
    public static String getBaseIndexName(Class clazz) {
        String templateName;
        Document annotation = clazz.getAnnotation(Document.class);
        if (null == annotation) {
            throw new IllegalArgumentException(clazz.getName() + "\u6ca1\u6709Document\u6ce8\u89e3");
        }
        ESPrefix prefixAnnotation = clazz.getAnnotation(ESPrefix.class);
        if (null != prefixAnnotation) {
            String prefix = ESUtil.getPrefix(prefixAnnotation);
            templateName = prefix + "-" + annotation.indexName();
        } else {
            templateName = annotation.indexName();
        }
        return templateName;
    }

    public static <T> String getIndexName(T t) throws Exception {
        Class<?> clazz = t.getClass();
        String index = ESUtil.getBaseIndexName(clazz);
        Template template = clazz.getAnnotation(Template.class);
        if (null != template) {
            String dateFormat = template.dataFormat();
            String field = template.dateField();
            if (StringUtils.isNotBlank((CharSequence)field)) {
                Field dateField = clazz.getDeclaredField(field);
                if (null != dateField && Date.class == dateField.getType()) {
                    dateField.setAccessible(true);
                    Date date = (Date)dateField.get(t);
                    String format = DateUtil.format((Date)date, (String)dateFormat);
                    index = index + "-" + format;
                } else {
                    throw new RuntimeException("@IndexSplit dateField\u5b57\u6bb5\u975e\u65e5\u671f\u7c7b\u578b");
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)index)) {
            throw new RuntimeException("\u7d22\u5f15\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return index;
    }

    public static <T> String getIndexNameWithDate(T t, Date date) throws Exception {
        Class<?> clazz = t.getClass();
        String index = ESUtil.getBaseIndexName(clazz);
        Template template = clazz.getAnnotation(Template.class);
        if (null != template) {
            String dateFormat = template.dataFormat();
            String field = template.dateField();
            if (StringUtils.isNotBlank((CharSequence)field)) {
                Field dateField = clazz.getDeclaredField(field);
                if (null != dateField && Date.class == dateField.getType()) {
                    dateField.setAccessible(true);
                    String format = DateUtil.format((Date)date, (String)dateFormat);
                    index = index + "-" + format;
                } else {
                    throw new RuntimeException("@IndexSplit dateField\u5b57\u6bb5\u975e\u65e5\u671f\u7c7b\u578b");
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)index)) {
            throw new RuntimeException("\u7d22\u5f15\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return index;
    }

    public static String getPrefix(ESPrefix prefix) {
        String prefix1 = prefix.prefix();
        if (prefix1.startsWith("${") && prefix1.endsWith("}")) {
            String substring = prefix1.substring(2);
            String substring1 = substring.substring(0, substring.length() - 1);
            String property = SpringUtil.getProperty((String)substring1);
            return property;
        }
        return prefix1;
    }
}

