package com.viontech.keliu.configuration.elasticsearch.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * ES模板
 * Author: inggg
 * Date: 2022/02/08 09:34
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE })
public @interface Template {
    /**
     * 模板名字
     * @return
     */
    String templateName();

    /**
     * 匹配patterns
     * @return
     */
    String[] patterns();

    /**
     * 排序
     */
    int order() default 0;

    /**
     * 日期格式，默认按月分索引
     * @return
     */
    String dataFormat() default "yyyy-MM";

    /**
     * 日期字段
     * @return
     */
    String dateField();
}
