package com.viontech.keliu.configuration.elasticsearch;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import com.viontech.keliu.configuration.elasticsearch.annotation.Template;
import com.viontech.keliu.configuration.elasticsearch.util.ESUtil;
import org.apache.commons.lang3.StringUtils;

import javax.xml.transform.Source;
import java.lang.reflect.Field;
import java.util.*;

/**
 * Author: inggg
 * Date: 2019/8/22 14:58
 */
public class ESRequestFactory {

    public static SearchRequest.Builder getSearchRequest(Class clazz) {
        String index = ESUtil.getBaseIndexName(clazz);
        if (StringUtils.isEmpty(index)) {
            throw new RuntimeException("索引不能为空");
        }
        return new SearchRequest.Builder().index(index);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, SourceConfig sourceConfig) {
        return getSearchRequest(clazz).source(sourceConfig);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, Date date) {
        String index = ESUtil.getBaseIndexName(clazz);
        Template template = (Template) clazz.getAnnotation(Template.class);
        if (null != template) {
            String dateFormat = template.dataFormat();
            String field = template.dateField();
            try {
                Field declaredField = clazz.getDeclaredField(field);
                if (null != declaredField && Date.class == declaredField.getType()) {
                    if (StringUtils.isNotBlank(field)) {
                        String format = DateUtil.format(date, dateFormat);
                        index = index + "-" + format;
                    }
                }
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isEmpty(index)) {
            throw new RuntimeException("索引不能为空");
        }
        return getIgnoreUnavailableRequest(index);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, Date date, SourceConfig sourceConfig) {
        return getSearchRequest(clazz, date).source(sourceConfig);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            throw new IllegalArgumentException("开始时间不能小于结束时间");
        }
        String index = ESUtil.getBaseIndexName(clazz);
        Template template = (Template) clazz.getAnnotation(Template.class);
        if (null != template) {
            String dateFormat = template.dataFormat();
            String field = template.dateField();
            try {
                Field declaredField = clazz.getDeclaredField(field);
                if (null != declaredField && Date.class == declaredField.getType()) {
                    if (StringUtils.isNotBlank(field)) {
                        startDate = DateUtil.beginOfMonth(startDate);
                        endDate = DateUtil.endOfMonth(endDate);
                        List<String> indexList = new ArrayList<>();
                        do {
                            String format = DateUtil.format(startDate, dateFormat);
                            String indexName = index + "-" + format;
                            indexList.add(indexName);
                            startDate = DateUtil.offsetMonth(startDate, 1);
                        } while (startDate.before(endDate));
                        if (ArrayUtil.isNotEmpty(indexList)) {
                            String[] indices = indexList.toArray(new String[indexList.size()]);
                            return getIgnoreUnavailableRequest(indices);
                        }
                    }
                }
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isEmpty(index)) {
            throw new RuntimeException("索引不能为空");
        }
        return new SearchRequest.Builder().index(index);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, Date startDate, Date endDate, SourceConfig sourceConfig) {
        return getSearchRequest(clazz, startDate, endDate).source(sourceConfig);
    }

    /**
     * 获取IgnoreUnavailableRequest
     * @param indices
     * @return
     */
    private static SearchRequest.Builder getIgnoreUnavailableRequest(String... indices) {
        SearchRequest.Builder request = new SearchRequest.Builder().index(Arrays.asList(indices));
//        IndicesOptions defaultIndicesOptions = request.indicesOptions();
//        EnumSet<IndicesOptions.Option> options = defaultIndicesOptions.getOptions();
//        options.add(IndicesOptions.Option.IGNORE_UNAVAILABLE);
//        EnumSet<IndicesOptions.WildcardStates> expandWildcards = defaultIndicesOptions.getExpandWildcards();
//        IndicesOptions newIndicesOptions = new IndicesOptions(options, expandWildcards);
//        request.indicesOptions(newIndicesOptions);
        request.ignoreUnavailable(true);
        return request;
    }
}
