/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.chart.excel;

import cn.hutool.json.JSONUtil;
import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.model.PieData;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.NumberUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public class ChartExcel {
    private Chart chart;
    private static final int colsizeN = 630;
    private static final int colsizeM = 1000;

    public ChartExcel(Chart chart) {
        this.chart = chart;
    }

    public InputStream creatExcelInputStream() {
        Map<String, Object> excelData = this.getExcelData(false);
        return this.Data2Excel(excelData);
    }

    public InputStream creatExcelInputStreamWithSeries() {
        Map<String, Object> excelData = this.getExcelData(true);
        return this.Data2Excel(excelData);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getExcelData(boolean withSeries) {
        HashMap<String, Object> excelMap = new HashMap<String, Object>();
        String title = this.chart.getTitle();
        excelMap.put("title", title);
        LinkedList<Object> heads = new LinkedList<Object>();
        LinkedHashMap<Object, Object> rows = new LinkedHashMap<Object, Object>();
        Axis axis = this.chart.getAxis();
        List<Object> axisList = new ArrayList();
        if (axis != null) {
            axisList = axis.getData();
        }
        List<Series> series = this.chart.getSeries();
        boolean flag = true;
        for (int i = 0; i < series.size(); ++i) {
            List data;
            Series serie = series.get(i);
            String serieName = serie.getName();
            String type = serie.getType();
            if (SeriesType.pie.name().equals(type)) {
                if (flag) {
                    heads.add("\\");
                    flag = false;
                }
                if (!heads.contains(serieName)) {
                    heads.add(serieName);
                }
                data = serie.getData();
                for (int j = 0; j < data.size(); ++j) {
                    void var17_25;
                    Object name = ((PieData)data.get(j)).getName();
                    List list = (List)rows.get(name);
                    if (list == null) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(name);
                    }
                    Object value = ((PieData)data.get(j)).getValue();
                    var17_25.add(value);
                    rows.put(name, var17_25);
                }
                continue;
            }
            if (SeriesType.table.name().equals(type)) {
                data = serie.getData();
                String name = serie.getName();
                if (withSeries) {
                    ArrayList<String> rowList = (ArrayList<String>)rows.get(name);
                    if (rowList == null) {
                        rowList = new ArrayList<String>();
                        rowList.add(name);
                    }
                    rowList.addAll(data);
                    rows.put(name, rowList);
                    axisList.add(0, "\\");
                } else {
                    rows.put(name, data);
                }
                if (heads.size() > 0) continue;
                for (String string : axisList) {
                    if (string.contains("[") && string.contains("]")) {
                        String[] split = string.replace("[", "").replace("]", "").replace("'", "").split(",");
                        if (split.length > 2) {
                            for (int i1 = 1; i1 < split.length; ++i1) {
                                heads.add("[" + split[0] + "-" + split[i1] + "]");
                            }
                            continue;
                        }
                        heads.add(string);
                        continue;
                    }
                    heads.add(string);
                }
                continue;
            }
            if (flag) {
                heads.add("\\");
                flag = false;
            }
            if (!heads.contains(serieName)) {
                heads.add(serieName);
            }
            data = serie.getData();
            HashSet<String> arrSet = new HashSet<String>();
            for (int j = 0; j < data.size(); ++j) {
                List<String> rowList;
                String string = (String)axisList.get(j);
                if (!arrSet.isEmpty() && arrSet.contains(string)) {
                    rowList = (List)rows.get(string + " ");
                    if (rowList == null) {
                        rowList = new ArrayList();
                        rowList.add(string);
                    }
                    rowList.add((String)data.get(j));
                    rows.put(string + " ", rowList);
                    continue;
                }
                rowList = (ArrayList<String>)rows.get(string);
                if (rowList == null) {
                    rowList = new ArrayList<String>();
                    rowList.add(string);
                }
                rowList.add((String)data.get(j));
                rows.put(string, rowList);
                arrSet.add(string);
            }
        }
        excelMap.put("heads", heads);
        excelMap.put("rows", rows);
        return excelMap;
    }

    public InputStream Data2Excel(Map<String, Object> excelMap) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont font = wb.createFont();
            font.setBold(true);
            font.setFontHeight((short)400);
            titleStyle.setFont(font);
            HSSFCell titleCell = sheet.createRow(0).createCell(0);
            String title = (String)excelMap.get("title");
            titleCell.setCellValue((RichTextString)new HSSFRichTextString(title));
            titleCell.setCellStyle(titleStyle);
            HSSFRow headRow = sheet.createRow(1);
            int colSzie = 0;
            HSSFCellStyle headStyle = wb.createCellStyle();
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont headFont = wb.createFont();
            headFont.setBold(true);
            headFont.setFontHeight((short)240);
            headStyle.setFont(headFont);
            List heads = (List)excelMap.get("heads");
            ArrayList columnTypes = new ArrayList(heads.size());
            heads = heads.stream().map(h -> {
                String str = (String)h;
                if (JSONUtil.isJsonObj((String)str)) {
                    Map map = (Map)JSONUtil.toBean((String)str, Map.class);
                    columnTypes.add(map.getOrDefault("type", "null").toString());
                    return map.getOrDefault("name", str).toString();
                }
                columnTypes.add("null");
                return str;
            }).collect(Collectors.toList());
            Map rows = (Map)excelMap.get("rows");
            for (int i = 0; i < heads.size(); ++i) {
                String head = (String)heads.get(i);
                HSSFCell cell = headRow.createCell(i);
                cell.setCellValue((RichTextString)new HSSFRichTextString(head));
                cell.setCellStyle(headStyle);
                ++colSzie;
                sheet.autoSizeColumn((int)((short)i));
                sheet.setColumnWidth(i, head.length() * 630 + 1000);
            }
            HSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            HSSFCellStyle percentageStyle = wb.createCellStyle();
            percentageStyle.setAlignment(HorizontalAlignment.RIGHT);
            percentageStyle.setDataFormat(wb.createDataFormat().getFormat("0.00%"));
            int i = 0;
            for (Object datas : rows.values()) {
                HSSFRow row = sheet.createRow(i + 2);
                List rowData = (List)datas;
                for (int j = 0; j < rowData.size(); ++j) {
                    HSSFCell cell = row.createCell(j);
                    Object cellValue = rowData.get(j);
                    if (cellValue == null) {
                        cell.setCellValue("--");
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    boolean isNum = false;
                    boolean isInteger = false;
                    boolean isPercent = false;
                    boolean isTime = false;
                    if (!"".equals(cellValue)) {
                        switch ((String)columnTypes.get(j)) {
                            case "Integer": {
                                isNum = true;
                                isInteger = true;
                                break;
                            }
                            case "Double": {
                                isNum = true;
                                break;
                            }
                            case "percent": {
                                isNum = true;
                                isPercent = true;
                                break;
                            }
                            case "time": {
                                isTime = true;
                                break;
                            }
                            default: {
                                isNum = cellValue.toString().matches("^(-?\\d+)(\\.\\d+)?$");
                                isInteger = cellValue.toString().matches("^[-\\+]?[\\d]*$");
                                isPercent = cellValue.toString().contains("%");
                            }
                        }
                    }
                    if (isNum && !isPercent) {
                        if (cellValue.toString().matches("^(-?\\d+)(\\.\\d+)?$")) {
                            cell.setCellValue(Double.parseDouble(cellValue.toString()));
                            if (isInteger) {
                                cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,#0"));
                            } else {
                                cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0.00"));
                            }
                        } else {
                            cell.setCellValue(cellValue.toString());
                        }
                        cell.setCellStyle(cellStyle);
                    } else if (isPercent) {
                        if (cellValue.toString().endsWith("%")) {
                            cellValue = cellValue.toString().replace("%", "");
                        }
                        if (cellValue.toString().matches("^(-?\\d+)(\\.\\d+)?$")) {
                            cell.setCellValue(NumberUtil.divide((Number)Double.parseDouble(cellValue.toString()), (Number)100, (int)4).doubleValue());
                            cell.setCellStyle((CellStyle)percentageStyle);
                        } else {
                            cell.setCellValue(cellValue.toString());
                        }
                    } else if (isTime) {
                        int second = Integer.parseInt(cellValue.toString());
                        cell.setCellValue(second / 60 + ":" + String.format("%02d", second % 60));
                        cell.setCellStyle(cellStyle);
                    } else {
                        cell.setCellValue(String.valueOf(cellValue));
                        cell.setCellStyle(cellStyle);
                    }
                    cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)""));
                }
                ++i;
            }
            if (colSzie > 1) {
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, colSzie - 1));
            } else {
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 2));
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                wb.write((OutputStream)os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] b = os.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(b);
            return in;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

