package com.viontech.keliu.chart.series;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.util.trove.list.TIntList;
import com.viontech.keliu.util.trove.list.array.TIntArrayList;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * 报表中真正的数据
 * */
public abstract class Series {
	/**
	 * 求和计算方式
	 */
	public final static int CALC_TYPE_SUM = 0;
	
	/**
	 * 均值计算方式
	 */
	public final static int CALC_TYPE_AVG = 1;		
	
	/**
	 * 数据系列名称
	 */
	private String name;
	
	/**分组名称*/
	private String stack;
	
	/**
	 * 数据所属chart对象
	 */
	protected Chart chart;
	
	/**
	 * 原始数据
	 */
	protected List data_raw = new ArrayList();
	
	/**
	 * 计算过的数据
	 */
	protected List data = null;
	
	/**
	 * 数据的个数 列表
	 */
	protected TIntList counts;
	
	/**
	 * 计算方式列表
	 */
	protected TIntList calcTypes;
	
	public Series(String name,String stack,Chart chart) {
		this.name = name;
		this.stack = stack;
		this.chart = chart;
	}
	public Series(String name,Chart chart) {
		this(name,null,chart);
	}

	public Series(Chart chart) {
		this(null,null,chart); 
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public abstract String getType();
	
	public String getStack() {
		return stack;
	}
	public void setStack(String stack) {
		this.stack = stack;
	}
	/**
	 * 设置报表数据的值 旧的值将会覆盖
	 * @param value
	 */
	public void putValue(Object value){
		this.putValueByCoordinate("data",value);
	}
	/**
	 * 累积数据 没有坐标 的情况 这种情况很少
	 * @param value
	 */
	public void adjustOrPutValue(Object value){
		this.adjustOrPutValueByCoordinate("data",value);
	}
	
	
	@JsonIgnore
	public Object getValue(){
		return this.getValueByCoordinate("data");
	}
	
	
	public Object getValueByCoordinate(Object coordinate){
		if(coordinate == null){
			throw new RuntimeException("坐标属性不能为空");
		}
		return getValueByIndex(getIndexByCoordinate(coordinate));
	}
	
	public Object getValueByIndex(int index){
		if(index >= data_raw.size()){
			return null;
		}
		if(index < 0){
			return null;
		}
		return data_raw.get(index);
	}
	
	public boolean putValueByCoordinate(Object coordinate,Object value){
		if(coordinate == null){
			throw new RuntimeException("坐标属性不能为空");
		}
		int index = getIndexByCoordinate(coordinate);
		if(index > -1){
			return putValueByIndex(index, value);
		}
		return false;
	}
	

	public boolean putValueByIndex(int index,Object value){
		if(index < 0){
			return false;
		}
		if(index >= data_raw.size()){
			for(int i = data_raw.size();i<=index;i++){
				data_raw.add(null);
			}
		}
		data_raw.set(index, value);
		return true;
	}

	
	public boolean adjustOrPutValueByCoordinate(Object coordinate,Object value){
		return adjustOrPutValueByIndex(getIndexByCoordinate(coordinate), value);
	}
	
	
	protected final boolean adjustOrPutValueByIndex(int index,Object value) {
		if (index < 0) {
			return false;
		}
		return adjustOrPutValueByIndex2(index, value);
	}

	protected abstract boolean adjustOrPutValueByIndex2(int index,Object value);

	/**根据轴坐标名称获取轴坐标*/
	@JsonIgnore
	protected abstract int getIndexByCoordinate(Object coordinate);

	
	protected boolean isAvg(int index){
		return getCalcTypeByIndex(index)!=null && getCalcTypeByIndex(index)==CALC_TYPE_AVG;
	}
	
	public  boolean valueExChange(int index1,int index2){
		if(index1 < 0 || index2 < 0){
			return false;
		}
		if(index1 >= getLength() || index2 >= getLength()){
			return false;
		}
		if(data_raw!=null){
			Object value1 = data_raw.get(index1);
			Object value2 =  data_raw.get(index2);
			data_raw.set(index1, value2);
			data_raw.set(index2, value1);
		}
		
		if(data != null){
			Object value1 = data.get(index1);
			Object value2 = data.get(index2);
			data.set(index1, value2);
			data.set(index2, value1);
		}
		if(counts != null){
			int value1 = counts.get(index1);
			int value2 = counts.get(index2);
			counts.set(index1, value2);
			counts.set(index2, value1);
		}
		return true;
	}
	public boolean subvalue(int fromIndex,int toIndex){
		if(data == null) {
			calcResultValues();
		}
		if(data_raw != null)
			if (toIndex > data_raw.size()) {
				toIndex = data_raw.size();
			}
			data_raw = data_raw.subList(fromIndex, toIndex);
		if(data !=  null)
			if (toIndex > data.size()) {
				toIndex = data.size();
			}
			data = data.subList(fromIndex, toIndex);
		if(counts !=null){
			if (toIndex > counts.size()) {
				toIndex = counts.size();
			}
			counts = counts.subList(fromIndex, toIndex);
		}
		return true;
	}

	public boolean removeValue(int index){
		if(data !=  null){
			if (index >= data.size()) {
				return  true;
			}
			data.remove(index);
		}
		return true;
	}


	public List getData(){
		if(data == null){
			calcResultValues();
		}
		return data;
	}
	@JsonIgnore
	public List getRawData(){
		return data_raw;
	}
	
	public int dataSize(){
		if(data_raw == null){
			return 0;
		}
		return data_raw.size();
	}
	

	public void calcResultValues(){
		data = new ArrayList(data_raw);
		boolean needFill = false;
		for(int i = data.size()-1; i >= 0; i--){
			if(data.get(i)!=null){
				needFill = true;
			}
			if(needFill && data.get(i) == null){
				data.set(i,0);
			}
		}

		for (int i = 0; i < data_raw.size(); i++) {
			Object value = data_raw.get(i);
			Integer count = getCountByIndex(i);
			if(value != null && isAvg(i) && count != null){
				data.set(i, calcAvg(value,count));
			}
			data.set(i, chart.calcValue(getName(),i, data));
		}

	}
	
	protected Number numberConverter(Number number,Class targetClass){
		if(targetClass.equals(Double.class))
			return new Double(number.toString());
		if(targetClass.equals(Integer.class))
			return new Double(number.toString()).intValue();
		if(targetClass.equals(Float.class))
			return new Double(number.toString()).floatValue();
		if(targetClass.equals(Long.class))
			return new Double(number.toString()).longValue();
		return number;
	}

	
	protected Object calcAvg(Object value, Integer count) {
		if(!(value instanceof Number) || count == 0) {
			return value;
		}
		double result = new BigDecimal(value.toString()).divide(new BigDecimal(count),2).doubleValue();
		return numberConverter(result,value.getClass());
	}
	/**
	 * 设置数据数量 
	 * 为什么加这个方法：假如每个月有四个周一-周五  统计每个周一 -周五的 10点的数据  
	 * 然后算下每天的均值  由于 每个月有多个周一 -周五
	 * 所以数据量需要手动设置成5  而不是自动计算的 20
	 * 
	 * @param index 索引
	 * @param count 数据数量
	 */
	protected void setCountByIndex(int index,int count){
		if(counts == null){
			counts = new TIntArrayList();
			for (int i = 0; i < (chart.getAxis() == null ? 0 : chart.getAxis().getLength()); i++) {
				counts.add(0);
			}
		}
		for(int i=counts.size();i<index+1;i++){
			counts.add(0);
		}
		counts.set(index, count);
	}
	
	/**
	 * 设置数据数量 
	 * 为什么加这个方法：假如每个月有四个周一-周五  统计每个周一 -周五的 10点的数据  
	 * 然后算下每天的均值  由于 每个月有多个周一 -周五
	 * 所以数据量需要手动设置成5  而不是自动计算的 20
	 * 
	 * @param coordinate
	 * @param count 数据数量
	 */
	public void setCountByCoordinate(Object coordinate,Integer count){
		setCountByIndex(getIndexByCoordinate(coordinate), count); 
	}
	
	/**
	 * 通过索引获取数据数量
	 * @param index 索引
	 * @return 计算方式
	 */
	public Integer getCountByIndex(int index){
		if(counts == null || index>=counts.size() || index < 0) return null;
		return counts.get(index);
	}
	
	/**
	 * 通过坐标获取数据数量
	 * @param coordinate 坐标
	 * @return 计算方式
	 */
	public Integer getCountByCoordinate(Object coordinate){
		return getCountByIndex(getIndexByCoordinate(coordinate));
	}
	
	/**
	 * 通过坐标设置计算方式
	 * @param coordinate 坐标
	 * @param calcType 计算方式
	 */
	public void setCalcTypeByCoordinate(Object coordinate,int calcType){
		setCalcTypeByIndex(getIndexByCoordinate(coordinate), calcType); 
	}
	
	/**
	 * 设置所有坐标数据的计算方式
	 * @param calcType 计算方式
	 */
	public void setAllCalcType(Integer calcType){
		for (int i = 0; i < dataSize(); i++) {
			setCalcTypeByIndex(i, calcType);
		} 
	}
	
	
	/**
	 *  通过索引设置计算法方式
	 * @param index 索引
	 * @param calcType 计算方式
	 */
	protected void setCalcTypeByIndex(int index,int calcType){
		if(calcTypes == null){
			calcTypes = new TIntArrayList();
			for(int i=0;i<dataSize();i++){//
				calcTypes.add(CALC_TYPE_SUM);
			}
		}
		for(int i=calcTypes.size();i<index+1;i++){
			calcTypes.add(CALC_TYPE_SUM);
		}
		calcTypes.set(index, calcType);
	}
	
	
	/**
	 * 通过坐标获取计算方式
	 * @param coordinate 坐标
	 * @return 计算方式
	 */
	public Integer getCalcTypeByCoordinate(Object coordinate){
		return getCalcTypeByIndex(getIndexByCoordinate(coordinate));
	}
	/**
	 * 通过索引获取计算方式
	 * @param index 索引
	 * @return 计算方式
	 */
	protected Integer getCalcTypeByIndex(int index){
		if(calcTypes == null)
		    return CALC_TYPE_SUM;
		if(index>=calcTypes.size()){
			return CALC_TYPE_SUM;
		}
		return calcTypes.get(index);
	}
	
	
	@JsonIgnore
	protected int getLength(){
		return data_raw.size();
	}
	public void sort(Comparator comparator,Axis axis) {
		calcResultValues();
		 for(int i=0;i<data.size()-1;i++){//冒泡趟数
	            for(int j=0;j<data.size()-i-1;j++){
	               int result = comparator.compare(data.get(j), data.get(j+1));
	               if(result<0){
	            	   valueExChange(j, j+1);
	            	   axis.valueExChange(j, j+1);
	               }
	            }
	        }
	}

}
