package com.viontech.keliu.chart.axis;

import com.viontech.keliu.chart.Chart;

import java.util.List;



/**
 * 
 * @author suman
 *
 * @param <T>
 */
public interface Axis<T> {
	/**
	 * 通过坐标值获取对应的存储序列
	 * @param t
	 * @return
	 */
	public int getIndexByCoordinate(T t);
	/**
	 * 获取轴上的展示数据
	 * @return
	 */
	public List<String> getData();

	/**
	 * 获取轴上的原始数据
	 * @return
	 */
	public List<String> getData_raw();

	/**
	 * 获取轴上需要引出的数据
	 * @return
	 */
	public List<String> getHideData();

	/**
	 * 往轴上添加数据
	 * @param t
	 */
	public void addData(T t);
	
	public void addData(T... t);

	/**
	 * 添加忽略轴上的数据
	 * @param t
	 */
	public void addHideData(T t);
	/**
	 * 获取轴的数据长度
	 * @return
	 */
	public int getLength();

	/**
	 * 锁定x轴的数据，不更新最大值、最小值
	 */
	public void lockMinMax();
	/**
	 * 设置轴的最小值
	 * @param t
	 */
	public void setMin(T t) ;
	/**
	 * 设置轴的最大值
	 * @param t
	 */
	public void setMax(T t) ;
	/**
	 * 获取轴的最小值
	 * @return
	 */
	public T getMin();
	/**
	 * 获取轴上的最大值
	 * @return
	 */
	public T getMax();
	/**
	 * 锁定轴
	 */
	public void lock();
	/**
	 * 轴是否已经被锁定
	 * @return
	 */
	public boolean isLock();
	/**
	 *获取轴刻度 
	 * @return
	 */
	public Integer getScale();
	/**
	 * 设置轴刻度
	 * @param scale
	 */
	public void setScale(Integer scale) ;
	
	public Chart getChart();
	
	public void setChart(Chart chart);
	
	/**截取轴数据*/
	public List subData(int beginIndex, int endIndex);

	/**移除指定的轴数据*/
	public List removeData(int index);
	
	/**根据轴坐标交换位置*/
	public boolean valueExChange(int index1,int index2);
	
}
