package com.viontech.keliu.base;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.viontech.keliu.redis.annotation.RedisCache;
import com.viontech.keliu.redis.contants.RedisConstants.MethodType;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.*;

public abstract class BaseServiceImpl <T extends BaseModel> implements BaseService<T> {
	/**
	 * slf4j 日志对象 用来记录log
	 */
	protected Logger logger = LoggerFactory.getLogger(getClass());
	private Map<String,String> columnNamePropertyMap = null;
	

	public T selectByPrimaryKey(Object id) {
		return getMapper().selectByPrimaryKey(id);
	}
	

	@RedisCache(methodType=MethodType.ADD)
	public T insert(T record) {
		try {
			Field unidField = record.getClass().getDeclaredField("unid");
			if (null != unidField) {
				unidField.setAccessible(true);
				Object unidValue = unidField.get(record);
				if (null == unidValue) {
					String uuid = UUID.randomUUID().toString();
					unidField.set(record, uuid);
				}
			}
		} catch (NoSuchFieldException e) {
			//ignore
		} catch (Exception e) {
			e.printStackTrace();
		}
		getMapper().insert(record);
		return record;
	}


	@Override
	@RedisCache(methodType=MethodType.ADD)
	public T insertSelective(T record) {
		try {
			Field unidField = record.getClass().getDeclaredField("unid");
			if (null != unidField) {
				unidField.setAccessible(true);
				Object unidValue = unidField.get(record);
				if (null == unidValue) {
					String uuid = UUID.randomUUID().toString();
					unidField.set(record, uuid);
				}
			}
		} catch (NoSuchFieldException e) {
			//ignore
		} catch (Exception e) {
			e.printStackTrace();
		}
		getMapper().insertSelective(record);
		return record;
	}
	
	

	@Override
	@RedisCache(methodType=MethodType.DELETE)
	public int deleteByPrimaryKey(Object b) {
		return getMapper().deleteByPrimaryKey(b);
	}

	@Override
	@RedisCache(methodType=MethodType.UPDATE)
	public int updateByPrimaryKey(T record) {
		return getMapper().updateByPrimaryKey(record);
	}

	@Override
	@RedisCache(methodType=MethodType.UPDATE)
	public int updateByPrimaryKeySelective(T record) {
		return getMapper().updateByPrimaryKeySelective(record);
	}
	
	@Override
	public PageInfo<T> pagedQuery(BaseExample example, int pageNum, int pageSize) {
		if(pageSize>0){
			PageHelper.startPage(pageNum, pageSize);
			Page<T> result = (Page<T>) getMapper().selectByExample(example);
			PageInfo<T> pageInfo = new PageInfo<T>(result);
			return pageInfo;
		}else{
			List<T> result = (List<T>) getMapper().selectByExample(example);
			Page<T> p = new Page<T>();
			p.addAll(result);
			PageInfo<T> pageInfo = new PageInfo<T>(p);
			return pageInfo;
		}
		
	}

	@Override
	public int countByExample(BaseExample example) {
		return getMapper().countByExample(example);
	}

	@Override
	@RedisCache(methodType=MethodType.DELETE)
	public int deleteByExample(BaseExample example) {
		return getMapper().deleteByExample(example);
	}

	@Override
	public List<T> selectByExample(BaseExample example) {
		return getMapper().selectByExample(example);
	}

	@Override
	@RedisCache(methodType=MethodType.UPDATE)
	public int updateByExampleSelective(T record, BaseExample example) {
		return getMapper().updateByExampleSelective(record, example);
	}

	@Override
	@RedisCache(methodType=MethodType.UPDATE)
	public int updateByExample(T record, BaseExample example) {
		return getMapper().updateByExample(record, example);
	}

	@Override
	public List<Object> getIdsByByExample(BaseExample example) {
		List<T> list= selectByExample(example);
		List<Object> result = new ArrayList<Object>();
		for(T t : list){
			Object pk = getPKByModel(t);
			if(pk!=null){
				result.add(pk);
			}
		}
		return result;
	}

	@Override
	public Object getPKByModel(BaseModel baseModel) {
		throw new java.lang.UnsupportedOperationException();
	}
	
	public String getColumnNameByProperty(String property){
		if(columnNamePropertyMap == null){
			columnNamePropertyMap = getColumnNamePropertyMap();
		}
		return columnNamePropertyMap.get(property);
	}
	
	public Map getColumnNamePropertyMap(){
		Map<String, String> result = new HashMap<String, String>();
		try {
			SqlSession sqlSession = getSqlSessionByMapper(getMapper());
			ResultMap resultMap = sqlSession.getConfiguration().getResultMap(getMapperClassByMapper(getMapper()).getName()+".BaseResultMapRoot");
			List<ResultMapping> propertyResultMappings = resultMap.getPropertyResultMappings();
			for (ResultMapping resultMapping : propertyResultMappings) {
				result.put(resultMapping.getProperty(), resultMapping.getColumn());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
				
	}
	private SqlSession getSqlSessionByMapper(BaseMapper mapper) throws Exception {
		Object mapperProxy = ((Proxy) mapper).getInvocationHandler(mapper);
        Field sqlSession = mapperProxy.getClass().getDeclaredField("sqlSession");
        sqlSession.setAccessible(true);
        return  (SqlSession) sqlSession.get(mapperProxy);

	}
	private Class getMapperClassByMapper(BaseMapper mapper) throws Exception {
		Object mapperProxy = ((Proxy) mapper).getInvocationHandler(mapper);
        Field mapperInterface = mapperProxy.getClass().getDeclaredField("mapperInterface");
        mapperInterface.setAccessible(true);
        return  (Class) mapperInterface.get(mapperProxy);

	}	
}

