/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.redis;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class KryoRedisSerializer<T>
implements RedisSerializer<T> {
    Logger logger = LoggerFactory.getLogger(KryoRedisSerializer.class);
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final ThreadLocal<Kryo> kryos = ThreadLocal.withInitial(Kryo::new);
    private static final ThreadLocal<Kryo> oldkryos = ThreadLocal.withInitial(Kryo::new);
    RedisSerializer<String> stringSerializer = new StringRedisSerializer();
    Pattern pattern = Pattern.compile("[0-9]*");

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return EMPTY_BYTE_ARRAY;
        }
        Kryo kryo = kryos.get();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(false);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (Output output = new Output((OutputStream)baos);){
                kryo.writeClassAndObject(output, t);
                output.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return EMPTY_BYTE_ARRAY;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null) return null;
        if (bytes.length <= 0) {
            return null;
        }
        Kryo kryo = kryos.get();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(false);
        try (Input input = new Input(bytes);){
            Object object = kryo.readClassAndObject(input);
            return (T)object;
        }
        catch (Exception e) {
            kryo = oldkryos.get();
            kryo.setReferences(false);
            kryo.register(Object.class);
            try (Input input2 = new Input(bytes);){
                Object object2 = kryo.readClassAndObject(input2);
                return (T)object2;
            }
            catch (Exception e2) {
                String result = (String)this.stringSerializer.deserialize(bytes);
                Matcher isNum = this.pattern.matcher(result);
                if (isNum.matches()) return (T)result;
                this.logger.error("kryo\u5e8f\u5217\u5316\u5931\u8d25:", (Throwable)e);
                return (T)result;
            }
        }
    }
}

