/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class RedisUtil {
    protected static RedisTemplate redisTemplate;
    private static Integer times;

    @Autowired(required=false)
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        RedisUtil.redisTemplate = redisTemplate;
    }

    public static RedisTemplate getRedisTemplate() {
        return redisTemplate;
    }

    public static boolean isInit() {
        return redisTemplate != null;
    }

    public static double getCreateTimeScore(long date) {
        return (double)date / 100000.0;
    }

    public static Set<String> getAllKeys() {
        return redisTemplate.keys((Object)"*");
    }

    public static Set<String> getKeys(String keyMatcher) {
        return redisTemplate.keys((Object)keyMatcher);
    }

    public static Map<String, Object> getAllString() {
        Set<String> stringSet = RedisUtil.getAllKeys();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String k : stringSet) {
            if (RedisUtil.getType(k) != DataType.STRING) continue;
            map.put(k, RedisUtil.get(k));
        }
        return map;
    }

    public static Map<String, Set<Object>> getAllSet() {
        Set<String> stringSet = RedisUtil.getAllKeys();
        HashMap<String, Set<Object>> map = new HashMap<String, Set<Object>>();
        for (String k : stringSet) {
            if (RedisUtil.getType(k) != DataType.SET) continue;
            map.put(k, RedisUtil.getSet(k));
        }
        return map;
    }

    public static Map<String, Set<Object>> getAllZSetRange() {
        Set<String> stringSet = RedisUtil.getAllKeys();
        HashMap<String, Set<Object>> map = new HashMap<String, Set<Object>>();
        for (String k : stringSet) {
            if (RedisUtil.getType(k) != DataType.ZSET) continue;
            map.put(k, RedisUtil.getZSetRange(k));
        }
        return map;
    }

    public static Map<String, Set<Object>> getAllZSetReverseRange() {
        Set<String> stringSet = RedisUtil.getAllKeys();
        HashMap<String, Set<Object>> map = new HashMap<String, Set<Object>>();
        for (String k : stringSet) {
            if (RedisUtil.getType(k) != DataType.ZSET) continue;
            map.put(k, RedisUtil.getZSetReverseRange(k));
        }
        return map;
    }

    public static Map<String, List<Object>> getAllList() {
        Set<String> stringSet = RedisUtil.getAllKeys();
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (String k : stringSet) {
            if (RedisUtil.getType(k) != DataType.LIST) continue;
            map.put(k, RedisUtil.getList(k));
        }
        return map;
    }

    public static Map<String, Map<String, Object>> getAllMap() {
        Set<String> stringSet = RedisUtil.getAllKeys();
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        for (String k : stringSet) {
            if (RedisUtil.getType(k) != DataType.HASH) continue;
            map.put(k, RedisUtil.getMap(k));
        }
        return map;
    }

    public static void addList(String key, List<Object> objectList) {
        for (Object obj : objectList) {
            RedisUtil.addList(key, obj);
        }
    }

    public static long addList(String key, Object obj) {
        return redisTemplate.boundListOps((Object)key).leftPush(obj);
    }

    public static long addList(String key, Object ... obj) {
        return redisTemplate.boundListOps((Object)key).leftPushAll(obj);
    }

    public static List<Object> getList(String key, long s, long e) {
        return redisTemplate.boundListOps((Object)key).range(s, e);
    }

    public static List<Object> getList(String key) {
        return redisTemplate.boundListOps((Object)key).range(0L, RedisUtil.getListSize(key));
    }

    public static long getListSize(String key) {
        return redisTemplate.boundListOps((Object)key).size();
    }

    public static Object leftPopWithTimeOut(String key) {
        return redisTemplate.boundListOps((Object)key).leftPop(0L, TimeUnit.SECONDS);
    }

    public static Object leftPop(String key) {
        return redisTemplate.boundListOps((Object)key).leftPop();
    }

    public static Object rightPopWithTimeOut(String key) {
        return redisTemplate.boundListOps((Object)key).rightPop(0L, TimeUnit.SECONDS);
    }

    public static Object rightPop(String key) {
        return redisTemplate.boundListOps((Object)key).rightPop();
    }

    public static long removeListValue(String key, Object object) {
        return redisTemplate.boundListOps((Object)key).remove(0L, object);
    }

    public static long removeListValue(String key, Object ... objects) {
        long r = 0L;
        for (Object object : objects) {
            r += RedisUtil.removeListValue(key, object);
        }
        return r;
    }

    public static void remove(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                RedisUtil.remove(key[0]);
            } else {
                redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public static void removeBlear(String ... blears) {
        for (String blear : blears) {
            RedisUtil.removeBlear(blear);
        }
    }

    public static Boolean renameIfAbsent(String oldKey, String newKey) {
        return redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public static void removeBlear(String blear) {
        redisTemplate.delete((Collection)redisTemplate.keys((Object)blear));
    }

    public static void removeByRegular(String ... blears) {
        for (String blear : blears) {
            RedisUtil.removeBlear(blear);
        }
    }

    public static void removeByRegular(String blear) {
        Set<String> stringSet = RedisUtil.getAllKeys();
        for (String s : stringSet) {
            if (!Pattern.compile(blear).matcher(s).matches()) continue;
            redisTemplate.delete((Object)s);
        }
    }

    public static void removeMapFieldByRegular(String key, String ... blears) {
        for (String blear : blears) {
            RedisUtil.removeMapFieldByRegular(key, blear);
        }
    }

    public static void removeMapFieldByRegular(String key, String blear) {
        Map<String, Object> map = RedisUtil.getMap(key);
        Set<String> stringSet = map.keySet();
        for (String s : stringSet) {
            if (!Pattern.compile(blear).matcher(s).matches()) continue;
            redisTemplate.boundHashOps((Object)key).delete(new Object[]{s});
        }
    }

    public static Long removeZSetValue(String key, Object ... value) {
        return redisTemplate.boundZSetOps((Object)key).remove(value);
    }

    public static void removeZSet(String key) {
        RedisUtil.removeZSetRange(key, 0L, RedisUtil.getZSetSize(key));
    }

    public static void removeZSetRange(String key, Long start, Long end) {
        redisTemplate.boundZSetOps((Object)key).removeRange(start.longValue(), end.longValue());
    }

    public static void setZSetUnionAndStore(String key, String key1, String key2) {
        redisTemplate.boundZSetOps((Object)key).unionAndStore((Object)key1, (Object)key2);
    }

    public static Set<Object> getZSetRange(String key) {
        return RedisUtil.getZSetRange(key, 0L, RedisUtil.getZSetSize(key));
    }

    public static Set<Object> getZSetRange(String key, long s, long e) {
        return redisTemplate.boundZSetOps((Object)key).range(s, e);
    }

    public static Set<Object> getZSetReverseRange(String key) {
        return RedisUtil.getZSetReverseRange(key, 0L, RedisUtil.getZSetSize(key));
    }

    public static Set<Object> getZSetReverseRange(String key, long start, long end) {
        return redisTemplate.boundZSetOps((Object)key).reverseRange(start, end);
    }

    public static Set<Object> getZSetRangeByScore(String key, double start, double end) {
        return redisTemplate.boundZSetOps((Object)key).rangeByScore(start, end);
    }

    public static Set<Object> getZSetReverseRangeByScore(String key, double start, double end) {
        return redisTemplate.boundZSetOps((Object)key).reverseRangeByScore(start, end);
    }

    public static Set<ZSetOperations.TypedTuple<Object>> getZSetRangeWithScores(String key, long start, long end) {
        return redisTemplate.boundZSetOps((Object)key).rangeWithScores(start, end);
    }

    public static Set<ZSetOperations.TypedTuple<Object>> getZSetReverseRangeWithScores(String key, long start, long end) {
        return redisTemplate.boundZSetOps((Object)key).reverseRangeWithScores(start, end);
    }

    public static Set<ZSetOperations.TypedTuple<Object>> getZSetRangeWithScores(String key) {
        return RedisUtil.getZSetRangeWithScores(key, 0L, RedisUtil.getZSetSize(key));
    }

    public static Set<ZSetOperations.TypedTuple<Object>> getZSetReverseRangeWithScores(String key) {
        return RedisUtil.getZSetReverseRangeWithScores(key, 0L, RedisUtil.getZSetSize(key));
    }

    public static long getZSetCountSize(String key, double sMin, double sMax) {
        return redisTemplate.boundZSetOps((Object)key).count(sMin, sMax);
    }

    public static long getZSetSize(String key) {
        return redisTemplate.boundZSetOps((Object)key).size();
    }

    public static double getZSetScore(String key, Object value) {
        return redisTemplate.boundZSetOps((Object)key).score(value);
    }

    public static double incrementZSetScore(String key, Object value, double delta) {
        return redisTemplate.boundZSetOps((Object)key).incrementScore(value, delta);
    }

    public static Boolean addZSet(String key, double score, Object value) {
        return redisTemplate.boundZSetOps((Object)key).add(value, score);
    }

    public static Long addZSet(String key, TreeSet<Object> value) {
        return redisTemplate.boundZSetOps((Object)key).add(value);
    }

    public static Boolean addZSet(String key, double[] score, Object[] value) {
        if (score.length != value.length) {
            return false;
        }
        for (int i = 0; i < score.length; ++i) {
            if (RedisUtil.addZSet(key, score[i], value[i]).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void remove(String key) {
        if (RedisUtil.exists(key)) {
            redisTemplate.delete((Object)key);
        }
    }

    public static void removeZSetRangeByScore(String key, double s, double e) {
        redisTemplate.boundZSetOps((Object)key).removeRangeByScore(s, e);
    }

    public static Boolean setSetExpireTime(String key, Long time) {
        return redisTemplate.boundSetOps((Object)key).expire(time.longValue(), TimeUnit.SECONDS);
    }

    public static Boolean setZSetExpireTime(String key, Long time) {
        return redisTemplate.boundZSetOps((Object)key).expire(time.longValue(), TimeUnit.SECONDS);
    }

    public static boolean exists(String key) {
        return redisTemplate.hasKey((Object)key);
    }

    public static Object get(int key) {
        return RedisUtil.get(String.valueOf(key));
    }

    public static Object get(long key) {
        return RedisUtil.get(String.valueOf(key));
    }

    public static Object get(String key) {
        return redisTemplate.boundValueOps((Object)key).get();
    }

    public static List<Object> get(String ... keys) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String key : keys) {
            list.add(RedisUtil.get(key));
        }
        return list;
    }

    public static List<Object> getByRegular(String regKey) {
        Set<String> stringSet = RedisUtil.getAllKeys();
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (String s : stringSet) {
            if (!Pattern.compile(regKey).matcher(s).matches() || RedisUtil.getType(s) != DataType.STRING) continue;
            objectList.add(RedisUtil.get(s));
        }
        return objectList;
    }

    public static void set(long key, Object value) {
        RedisUtil.set(String.valueOf(key), value);
    }

    public static void set(int key, Object value) {
        RedisUtil.set(String.valueOf(key), value);
    }

    public static void set(String key, Object value) {
        redisTemplate.boundValueOps((Object)key).set(value);
    }

    public static void set(String key, Object value, Long expireTime) {
        redisTemplate.boundValueOps((Object)key).set(value, expireTime.longValue(), TimeUnit.SECONDS);
    }

    public static boolean setExpireTime(String key, Long expireTime) {
        return redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
    }

    public static long getExpireTime(String key) {
        return redisTemplate.getExpire((Object)key);
    }

    public static DataType getType(String key) {
        return redisTemplate.type((Object)key);
    }

    public static void removeMapField(String key, Object ... field) {
        redisTemplate.boundHashOps((Object)key).delete(field);
    }

    public static Long getMapSize(String key) {
        return redisTemplate.boundHashOps((Object)key).size();
    }

    public static Map<String, Object> getMap(String key) {
        return redisTemplate.boundHashOps((Object)key).entries();
    }

    public static <T> T getMapField(String key, String field) {
        return (T)redisTemplate.boundHashOps((Object)key).get((Object)field);
    }

    public static Boolean hasMapKey(String key, String field) {
        return redisTemplate.boundHashOps((Object)key).hasKey((Object)field);
    }

    public static List<Object> getMapFieldValue(String key) {
        return redisTemplate.boundHashOps((Object)key).values();
    }

    public static Set<Object> getMapFieldKey(String key) {
        return redisTemplate.boundHashOps((Object)key).keys();
    }

    public static void addMap(String key, Map<String, Object> map) {
        redisTemplate.boundHashOps((Object)key).putAll(map);
    }

    public static void addMap(String key, String field, Object value) {
        redisTemplate.boundHashOps((Object)key).put((Object)field, value);
    }

    public static void addMap(String key, String field, Object value, long time) {
        redisTemplate.boundHashOps((Object)key).put((Object)field, value);
        redisTemplate.boundHashOps((Object)key).expire(time, TimeUnit.SECONDS);
    }

    public static void watch(String key) {
        redisTemplate.watch((Object)key);
    }

    public static void addSet(String key, Object ... obj) {
        redisTemplate.boundSetOps((Object)key).add(obj);
    }

    public static long removeSetValue(String key, Object obj) {
        return redisTemplate.boundSetOps((Object)key).remove(new Object[]{obj});
    }

    public static long removeSetValue(String key, Object ... obj) {
        if (obj != null && obj.length > 0) {
            return redisTemplate.boundSetOps((Object)key).remove(obj);
        }
        return 0L;
    }

    public static long getSetSize(String key) {
        return redisTemplate.boundSetOps((Object)key).size();
    }

    public static Boolean hasSetValue(String key, Object obj) {
        Boolean boo = null;
        int t = 0;
        while (true) {
            try {
                boo = redisTemplate.boundSetOps((Object)key).isMember(obj);
            }
            catch (Exception e) {
                if (++t <= times) continue;
            }
            break;
        }
        return boo;
    }

    public static Set<Object> getSet(String key) {
        return redisTemplate.boundSetOps((Object)key).members();
    }

    public static Set<Object> getSetUnion(String key, String otherKey) {
        return redisTemplate.boundSetOps((Object)key).union((Object)otherKey);
    }

    public static Set<Object> getSetUnion(String key, Set<Object> set) {
        return redisTemplate.boundSetOps((Object)key).union(set);
    }

    public static Set<Object> getSetIntersect(String key, String otherKey) {
        return redisTemplate.boundSetOps((Object)key).intersect((Object)otherKey);
    }

    public static Set<Object> getSetIntersect(String key, Set<Object> set) {
        return redisTemplate.boundSetOps((Object)key).intersect(set);
    }

    public static void publish(String channel, Object message) {
        Assert.hasText((String)channel, (String)"a non-empty channel is required");
        final byte[] rawChannel = redisTemplate.getStringSerializer().serialize((Object)channel);
        final byte[] rawMessage = message instanceof byte[] ? (byte[])message : redisTemplate.getValueSerializer().serialize(message);
        redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) {
                connection.publish(rawChannel, rawMessage);
                return null;
            }
        }, true);
    }

    public static Long incrementHashValue(String key, String field, long delta) {
        return redisTemplate.boundHashOps((Object)key).increment((Object)field, delta);
    }

    static {
        times = 5;
    }
}

