/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.http;

import com.alibaba.fastjson.JSON;
import com.viontech.keliu.http.EBodyFormat;
import com.viontech.keliu.http.HttpMethodName;
import com.viontech.keliu.http.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class VionRequest {
    private HashMap<String, String> headers;
    private HashMap<String, String> params;
    private HashMap<String, Object> body;
    private URI uri;
    private String bodyStr;
    private HttpMethodName httpMethod;
    private EBodyFormat bodyFormat;
    private String contentEncoding;
    private Integer connectTimeout = 5000;
    private Integer readTimeout = 20000;

    public VionRequest() {
        this.headers = new HashMap();
        this.params = new HashMap();
        this.body = new HashMap();
        this.httpMethod = HttpMethodName.POST;
        this.bodyFormat = EBodyFormat.FORM_KV;
        this.contentEncoding = "UTF8";
    }

    public VionRequest(HashMap<String, String> header, HashMap<String, String> bodyParams) {
        this.headers = header;
        this.params = bodyParams;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public EBodyFormat getBodyFormat() {
        return this.bodyFormat;
    }

    public void setBodyFormat(EBodyFormat bodyFormat) {
        this.bodyFormat = bodyFormat;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
        if (key.equals("Content-Encoding")) {
            this.contentEncoding = value;
        }
    }

    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    public void addBody(String key, Object value) {
        this.body.put(key, value);
    }

    public void addBody(HashMap other) {
        if (other != null) {
            this.body.putAll(other);
        }
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public void setParams(HashMap<String, String> params) {
        this.params = params;
    }

    public String getBodyStr() {
        if (this.bodyStr == null) {
            ArrayList<String> arr = new ArrayList<String>();
            if (this.bodyFormat.equals((Object)EBodyFormat.FORM_KV)) {
                for (Map.Entry<String, Object> entry : this.body.entrySet()) {
                    if (entry.getValue() == null || "".equals(entry.getValue())) {
                        arr.add(Util.uriEncode(entry.getKey(), true));
                        continue;
                    }
                    arr.add(String.format("%s=%s", Util.uriEncode(entry.getKey(), true), Util.uriEncode(entry.getValue().toString(), true)));
                }
                this.bodyStr = Util.mkString(arr.iterator(), '&');
            } else {
                this.bodyStr = this.bodyFormat.equals((Object)EBodyFormat.RAW_JSON) ? JSON.toJSONString(this.body) : (this.bodyFormat.equals((Object)EBodyFormat.RAW_JSON_ARRAY) ? (String)this.body.get("body") : "");
            }
        }
        return this.bodyStr;
    }

    public String getParamStr() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            buffer.append(String.format("%s=%s&", entry.getKey(), entry.getValue()));
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public HashMap<String, Object> getBody() {
        return this.body;
    }

    public void setBody(HashMap<String, Object> body) {
        this.body = body;
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(HashMap<String, String> headers) {
        this.headers = headers;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUri(String url) {
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }
}

