/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.websocket;

import com.alibaba.fastjson.JSON;
import com.viontech.keliu.constant.SystemConstants;
import com.viontech.keliu.model.AlgResult;
import com.viontech.keliu.utils.Util;
import com.viontech.keliu.websocket.AlgApiClient;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WsClient {
    private static final Logger logger = LoggerFactory.getLogger(WsClient.class);

    @OnOpen
    public void onOpen(Session session) {
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        logger.warn("session:{}\u5173\u95ed,closeReason:{}", (Object)session.getId(), (Object)closeReason.toString());
    }

    @OnError
    public void onError(Session session, Throwable ex) {
        logger.warn("session:{}\u51fa\u73b0\u5f02\u5e38", (Object)session.getId(), (Object)ex);
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        logger.warn("\u6536\u5230session:{}\u6d88\u606f:", (Object)session.getId());
        SystemConstants.THREAD_POOL.submit(() -> {
            AlgResult algResult = null;
            try {
                algResult = (AlgResult)JSON.parseObject((String)message, AlgResult.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (algResult == null || Util.isEmpty(algResult.getRid())) {
                return;
            }
            Consumer<AlgResult> consumer = AlgApiClient.rqid_consumer.remove(algResult.getRid());
            if (consumer == null) {
                return;
            }
            consumer.accept(algResult);
        });
    }
}

