/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.jdbc.core.mapping.AggregateReference;
import org.springframework.lang.Nullable;

class AggregateReferenceConverters {
    AggregateReferenceConverters() {
    }

    public static Collection<GenericConverter> getConvertersToRegister(ConversionService conversionService) {
        return Arrays.asList(new AggregateReferenceToSimpleTypeConverter(conversionService), new SimpleTypeToAggregateReferenceConverter(conversionService));
    }

    @WritingConverter
    private static class AggregateReferenceToSimpleTypeConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES = Collections.singleton(new GenericConverter.ConvertiblePair(AggregateReference.class, Object.class));
        private final ConversionService delegate;

        AggregateReferenceToSimpleTypeConverter(ConversionService delegate) {
            this.delegate = delegate;
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        public Object convert(@Nullable Object source, TypeDescriptor sourceDescriptor, TypeDescriptor targetDescriptor) {
            if (source == null) {
                return null;
            }
            Class objectType = targetDescriptor.getObjectType();
            if (objectType.isAssignableFrom(AggregateReference.class)) {
                return source;
            }
            Object id = ((AggregateReference)source).getId();
            if (id == null) {
                throw new IllegalStateException(String.format("Aggregate references id must not be null when converting to %s from %s to %s", source, sourceDescriptor, targetDescriptor));
            }
            return this.delegate.convert(id, TypeDescriptor.valueOf(id.getClass()), targetDescriptor);
        }
    }

    @ReadingConverter
    private static class SimpleTypeToAggregateReferenceConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES = Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, AggregateReference.class));
        private final ConversionService delegate;

        SimpleTypeToAggregateReferenceConverter(ConversionService delegate) {
            this.delegate = delegate;
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        public Object convert(@Nullable Object source, TypeDescriptor sourceDescriptor, TypeDescriptor targetDescriptor) {
            if (source == null) {
                return null;
            }
            ResolvableType componentType = targetDescriptor.getResolvableType().getGenerics()[1];
            TypeDescriptor targetType = TypeDescriptor.valueOf((Class)componentType.resolve());
            Object convertedId = this.delegate.convert(source, TypeDescriptor.valueOf(source.getClass()), targetType);
            return AggregateReference.to(convertedId);
        }
    }
}

