/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.FieldCollapse;
import co.elastic.clients.elasticsearch.core.search.Suggester;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.ScriptedField;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class NativeQueryBuilder
extends BaseQueryBuilder<NativeQuery, NativeQueryBuilder> {
    @Nullable
    private Query query;
    @Nullable
    private Query filter;
    private final Map<String, Aggregation> aggregations = new LinkedHashMap<String, Aggregation>();
    @Nullable
    private Suggester suggester;
    @Nullable
    private FieldCollapse fieldCollapse;
    private final List<ScriptedField> scriptedFields = new ArrayList<ScriptedField>();
    private List<RescorerQuery> rescorerQueries = new ArrayList<RescorerQuery>();

    @Nullable
    public Query getQuery() {
        return this.query;
    }

    @Nullable
    public Query getFilter() {
        return this.filter;
    }

    public Map<String, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public Suggester getSuggester() {
        return this.suggester;
    }

    @Nullable
    public FieldCollapse getFieldCollapse() {
        return this.fieldCollapse;
    }

    public List<ScriptedField> getScriptedFields() {
        return this.scriptedFields;
    }

    public List<RescorerQuery> getRescorerQueries() {
        return this.rescorerQueries;
    }

    public NativeQueryBuilder withQuery(Query query) {
        Assert.notNull((Object)query, (String)"query must not be null");
        this.query = query;
        return this;
    }

    public NativeQueryBuilder withFilter(@Nullable Query filter) {
        this.filter = filter;
        return this;
    }

    public NativeQueryBuilder withQuery(Function<Query.Builder, ObjectBuilder<Query>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.withQuery((Query)fn.apply(new Query.Builder()).build());
    }

    public NativeQueryBuilder withAggregation(String name, Aggregation aggregation) {
        Assert.notNull((Object)name, (String)"name must not be null");
        Assert.notNull((Object)aggregation, (String)"aggregation must not be null");
        this.aggregations.put(name, aggregation);
        return this;
    }

    public NativeQueryBuilder withSuggester(@Nullable Suggester suggester) {
        this.suggester = suggester;
        return this;
    }

    public NativeQueryBuilder withFieldCollapse(@Nullable FieldCollapse fieldCollapse) {
        this.fieldCollapse = fieldCollapse;
        return this;
    }

    public NativeQueryBuilder withScriptedField(ScriptedField scriptedField) {
        Assert.notNull((Object)scriptedField, (String)"scriptedField must not be null");
        this.scriptedFields.add(scriptedField);
        return this;
    }

    public NativeQueryBuilder withResorerQuery(RescorerQuery resorerQuery) {
        Assert.notNull((Object)resorerQuery, (String)"resorerQuery must not be null");
        this.rescorerQueries.add(resorerQuery);
        return this;
    }

    @Override
    public NativeQuery build() {
        return new NativeQuery(this);
    }
}

