/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient;

import org.springframework.boot.restclient.RootUriTemplateHandler;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplateHandler;

public class RootUriBuilderFactory
extends RootUriTemplateHandler
implements UriBuilderFactory {
    public RootUriBuilderFactory(String rootUri, UriTemplateHandler delegate) {
        super(rootUri, delegate);
    }

    public UriBuilder uriString(String uriTemplate) {
        return UriComponentsBuilder.fromUriString((String)this.apply(uriTemplate));
    }

    public UriBuilder builder() {
        return UriComponentsBuilder.newInstance();
    }

    static void applyTo(RestTemplate restTemplate, String rootUri) {
        Assert.notNull((Object)restTemplate, (String)"'restTemplate' must not be null");
        RootUriBuilderFactory handler = new RootUriBuilderFactory(rootUri, restTemplate.getUriTemplateHandler());
        restTemplate.setUriTemplateHandler((UriTemplateHandler)handler);
    }
}

