/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.springframework.boot.maven.DependencyFilter;

class JarTypeFilter
extends DependencyFilter {
    private static final Set<String> EXCLUDED_JAR_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("annotation-processor", "dependencies-starter")));

    JarTypeFilter() {
        super(Collections.emptyList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean filter(Artifact artifact) {
        try (JarFile jarFile = new JarFile(artifact.getFile());){
            String jarType = jarFile.getManifest().getMainAttributes().getValue("Spring-Boot-Jar-Type");
            boolean bl = jarType != null && EXCLUDED_JAR_TYPES.contains(jarType);
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

