/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.time.Duration;
import java.util.LinkedList;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AcquireAsyncJobsDueLifecycleListener;
import org.flowable.job.service.impl.asyncexecutor.AcquireAsyncJobsDueRunnable;
import org.flowable.job.service.impl.asyncexecutor.AcquireJobsRunnableConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AcquireTimerJobsRunnable;
import org.flowable.job.service.impl.asyncexecutor.AcquireTimerLifecycleListener;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncJobExecutorConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.flowable.job.service.impl.asyncexecutor.ExecuteAsyncRunnableFactory;
import org.flowable.job.service.impl.asyncexecutor.ResetExpiredJobsRunnable;
import org.flowable.job.service.impl.cmd.UnacquireOwnedJobsCmd;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncExecutor
implements AsyncExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAsyncExecutor.class);
    protected AsyncJobExecutorConfiguration configuration;
    protected AcquireTimerJobsRunnable timerJobRunnable;
    protected AcquireTimerLifecycleListener timerLifecycleListener;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected AcquireAsyncJobsDueRunnable asyncJobsDueRunnable;
    protected AcquireAsyncJobsDueLifecycleListener asyncJobsDueLifecycleListener;
    protected ResetExpiredJobsRunnable resetExpiredJobsRunnable;
    protected ExecuteAsyncRunnableFactory executeAsyncRunnableFactory;
    protected AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler;
    protected boolean isAutoActivate;
    protected boolean isActive;
    protected boolean isMessageQueueMode;
    protected LinkedList<JobInfo> temporaryJobQueue = new LinkedList();
    protected JobServiceConfiguration jobServiceConfiguration;

    public AbstractAsyncExecutor() {
        this(new AsyncJobExecutorConfiguration());
    }

    public AbstractAsyncExecutor(AsyncJobExecutorConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean executeAsyncJob(JobInfo job) {
        if (this.isMessageQueueMode) {
            return true;
        }
        Runnable runnable = null;
        if (this.isActive) {
            runnable = this.createRunnableForJob(job);
            return this.executeAsyncJob(job, runnable);
        }
        this.temporaryJobQueue.add(job);
        return true;
    }

    protected abstract boolean executeAsyncJob(JobInfo var1, Runnable var2);

    protected void unlockOwnedJobs() {
        this.jobServiceConfiguration.getCommandExecutor().execute((Command)new UnacquireOwnedJobsCmd(this.configuration.getLockOwner(), this.configuration.getTenantId(), this.jobServiceConfiguration));
    }

    protected Runnable createRunnableForJob(JobInfo job) {
        if (this.executeAsyncRunnableFactory == null) {
            return new ExecuteAsyncRunnable(job, this.jobServiceConfiguration, this.jobEntityManager, this.asyncRunnableExecutionExceptionHandler);
        }
        return this.executeAsyncRunnableFactory.createExecuteAsyncRunnable(job, this.jobServiceConfiguration);
    }

    @Override
    public void start() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        LOGGER.info("Starting up the async job executor [{}].", (Object)this.getClass().getName());
        this.initializeJobEntityManager();
        this.initializeRunnables();
        this.startAdditionalComponents();
        this.executeTemporaryJobs();
    }

    protected void initializeJobEntityManager() {
        if (this.jobEntityManager == null) {
            this.jobEntityManager = this.jobServiceConfiguration.getJobEntityManager();
        }
    }

    protected void initializeRunnables() {
        JobEntityManager jobEntityManagerToUse;
        if (this.configuration.isTimerRunnableNeeded() && this.timerJobRunnable == null) {
            this.timerJobRunnable = new AcquireTimerJobsRunnable(this, this.jobServiceConfiguration.getJobManager(), this.timerLifecycleListener, new AcquireTimerRunnableConfiguration(), this.configuration.getMoveTimerExecutorPoolSize());
        }
        JobEntityManager jobEntityManager = jobEntityManagerToUse = this.jobEntityManager != null ? this.jobEntityManager : this.jobServiceConfiguration.getJobEntityManager();
        if (this.resetExpiredJobsRunnable == null) {
            String resetExpiredRunnableName = this.configuration.getResetExpiredRunnableName();
            String resetRunnableName = resetExpiredRunnableName != null ? resetExpiredRunnableName : "flowable-" + this.getJobServiceConfiguration().getEngineName() + "-reset-expired-jobs";
            this.resetExpiredJobsRunnable = this.createResetExpiredJobsRunnable(resetRunnableName);
        }
        if (!this.isMessageQueueMode && this.asyncJobsDueRunnable == null) {
            String acquireRunnableThreadName = this.configuration.getAcquireRunnableThreadName();
            String acquireJobsRunnableName = acquireRunnableThreadName != null ? acquireRunnableThreadName : "flowable-" + this.getJobServiceConfiguration().getEngineName() + "-acquire-async-jobs";
            this.asyncJobsDueRunnable = new AcquireAsyncJobsDueRunnable(acquireJobsRunnableName, this, jobEntityManagerToUse, this.asyncJobsDueLifecycleListener, new AcquireAsyncJobsDueRunnableConfiguration());
        }
    }

    protected abstract ResetExpiredJobsRunnable createResetExpiredJobsRunnable(String var1);

    protected abstract void startAdditionalComponents();

    protected void executeTemporaryJobs() {
        while (!this.temporaryJobQueue.isEmpty()) {
            JobInfo job = this.temporaryJobQueue.pop();
            this.executeAsyncJob(job);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        LOGGER.info("Shutting down the async job executor [{}].", (Object)this.getClass().getName());
        this.stopRunnables();
        this.shutdownAdditionalComponents();
        this.isActive = false;
    }

    protected void stopRunnables() {
        if (this.timerJobRunnable != null) {
            this.timerJobRunnable.stop();
        }
        if (this.asyncJobsDueRunnable != null) {
            this.asyncJobsDueRunnable.stop();
        }
        if (this.resetExpiredJobsRunnable != null) {
            this.resetExpiredJobsRunnable.stop();
        }
        this.timerJobRunnable = null;
        this.asyncJobsDueRunnable = null;
        this.resetExpiredJobsRunnable = null;
    }

    protected abstract void shutdownAdditionalComponents();

    @Override
    public JobServiceConfiguration getJobServiceConfiguration() {
        return this.jobServiceConfiguration;
    }

    @Override
    public void setJobServiceConfiguration(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    @Override
    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMessageQueueMode() {
        return this.isMessageQueueMode;
    }

    public void setMessageQueueMode(boolean isMessageQueueMode) {
        this.isMessageQueueMode = isMessageQueueMode;
    }

    @Override
    public String getLockOwner() {
        return this.configuration.getLockOwner();
    }

    public void setLockOwner(String lockOwner) {
        this.configuration.setLockOwner(lockOwner);
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return (int)this.configuration.getTimerLockTime().toMillis();
    }

    @Override
    public void setTimerLockTimeInMillis(int timerLockTimeInMillis) {
        this.configuration.setTimerLockTime(Duration.ofMillis(timerLockTimeInMillis));
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return (int)this.configuration.getAsyncJobLockTime().toMillis();
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int asyncJobLockTimeInMillis) {
        this.configuration.setAsyncJobLockTime(Duration.ofMillis(asyncJobLockTimeInMillis));
    }

    public int getMoveTimerExecutorPoolSize() {
        return this.configuration.getMoveTimerExecutorPoolSize();
    }

    public void setMoveTimerExecutorPoolSize(int moveTimerExecutorPoolSize) {
        this.configuration.setMoveTimerExecutorPoolSize(moveTimerExecutorPoolSize);
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.configuration.getMaxTimerJobsPerAcquisition();
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxTimerJobsPerAcquisition) {
        this.configuration.setMaxTimerJobsPerAcquisition(maxTimerJobsPerAcquisition);
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.configuration.getMaxAsyncJobsDuePerAcquisition();
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxAsyncJobsDuePerAcquisition) {
        this.configuration.setMaxAsyncJobsDuePerAcquisition(maxAsyncJobsDuePerAcquisition);
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return (int)this.configuration.getDefaultTimerJobAcquireWaitTime().toMillis();
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int defaultTimerJobAcquireWaitTimeInMillis) {
        this.configuration.setDefaultTimerJobAcquireWaitTime(Duration.ofMillis(defaultTimerJobAcquireWaitTimeInMillis));
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return (int)this.configuration.getDefaultAsyncJobAcquireWaitTime().toMillis();
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int defaultAsyncJobAcquireWaitTimeInMillis) {
        this.configuration.setDefaultAsyncJobAcquireWaitTime(Duration.ofMillis(defaultAsyncJobAcquireWaitTimeInMillis));
    }

    public void setTimerJobRunnable(AcquireTimerJobsRunnable timerJobRunnable) {
        this.timerJobRunnable = timerJobRunnable;
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return (int)this.configuration.getDefaultQueueSizeFullWaitTime().toMillis();
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTime) {
        this.configuration.setDefaultQueueSizeFullWaitTime(Duration.ofMillis(defaultQueueSizeFullWaitTime));
    }

    public void setAsyncJobsDueRunnable(AcquireAsyncJobsDueRunnable asyncJobsDueRunnable) {
        this.asyncJobsDueRunnable = asyncJobsDueRunnable;
    }

    public AcquireAsyncJobsDueLifecycleListener getAsyncJobsDueLifecycleListener() {
        return this.asyncJobsDueLifecycleListener;
    }

    public void setAsyncJobsDueLifecycleListener(AcquireAsyncJobsDueLifecycleListener asyncJobsDueLifecycleListener) {
        this.asyncJobsDueLifecycleListener = asyncJobsDueLifecycleListener;
    }

    public boolean isTimerRunnableNeeded() {
        return this.configuration.isTimerRunnableNeeded();
    }

    public void setTimerRunnableNeeded(boolean timerRunnableNeeded) {
        this.configuration.setTimerRunnableNeeded(timerRunnableNeeded);
    }

    public AcquireTimerLifecycleListener getTimerLifecycleListener() {
        return this.timerLifecycleListener;
    }

    public void setTimerLifecycleListener(AcquireTimerLifecycleListener timerLifecycleListener) {
        this.timerLifecycleListener = timerLifecycleListener;
    }

    public boolean isGlobalAcquireLockEnabled() {
        return this.configuration.isGlobalAcquireLockEnabled();
    }

    public void setGlobalAcquireLockEnabled(boolean globalAcquireLockEnabled) {
        this.configuration.setGlobalAcquireLockEnabled(globalAcquireLockEnabled);
    }

    public String getGlobalAcquireLockPrefix() {
        return this.configuration.getGlobalAcquireLockPrefix();
    }

    public void setGlobalAcquireLockPrefix(String globalAcquireLockPrefix) {
        this.configuration.setGlobalAcquireLockPrefix(globalAcquireLockPrefix);
    }

    public Duration getAsyncJobsGlobalLockWaitTime() {
        return this.configuration.getAsyncJobsGlobalLockWaitTime();
    }

    public void setAsyncJobsGlobalLockWaitTime(Duration asyncJobsGlobalLockWaitTime) {
        this.configuration.setAsyncJobsGlobalLockWaitTime(asyncJobsGlobalLockWaitTime);
    }

    public Duration getAsyncJobsGlobalLockPollRate() {
        return this.configuration.getAsyncJobsGlobalLockPollRate();
    }

    public void setAsyncJobsGlobalLockPollRate(Duration asyncJobsGlobalLockPollRate) {
        this.configuration.setAsyncJobsGlobalLockPollRate(asyncJobsGlobalLockPollRate);
    }

    public Duration getTimerLockWaitTime() {
        return this.configuration.getTimerLockWaitTime();
    }

    public void setTimerLockWaitTime(Duration timerLockWaitTime) {
        this.configuration.setTimerLockWaitTime(timerLockWaitTime);
    }

    public Duration getTimerLockPollRate() {
        return this.configuration.getTimerLockPollRate();
    }

    public void setTimerLockPollRate(Duration timerLockPollRate) {
        this.configuration.setTimerLockPollRate(timerLockPollRate);
    }

    public void setAcquireRunnableThreadName(String acquireRunnableThreadName) {
        this.configuration.setAcquireRunnableThreadName(acquireRunnableThreadName);
    }

    public void setJobEntityManager(JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.jobEntityManager = jobEntityManager;
    }

    public void setResetExpiredRunnableName(String resetExpiredRunnableName) {
        this.configuration.setResetExpiredRunnableName(resetExpiredRunnableName);
    }

    public void setResetExpiredJobsRunnable(ResetExpiredJobsRunnable resetExpiredJobsRunnable) {
        this.resetExpiredJobsRunnable = resetExpiredJobsRunnable;
    }

    @Override
    @Deprecated
    public int getRetryWaitTimeInMillis() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Deprecated
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
    }

    @Override
    public int getResetExpiredJobsInterval() {
        return (int)this.configuration.getResetExpiredJobsInterval().toMillis();
    }

    @Override
    public void setResetExpiredJobsInterval(int resetExpiredJobsInterval) {
        this.configuration.setResetExpiredJobsInterval(Duration.ofMillis(resetExpiredJobsInterval));
    }

    @Override
    public int getResetExpiredJobsPageSize() {
        return this.configuration.getResetExpiredJobsPageSize();
    }

    @Override
    public void setResetExpiredJobsPageSize(int resetExpiredJobsPageSize) {
        this.configuration.setResetExpiredJobsPageSize(resetExpiredJobsPageSize);
    }

    public ExecuteAsyncRunnableFactory getExecuteAsyncRunnableFactory() {
        return this.executeAsyncRunnableFactory;
    }

    public void setExecuteAsyncRunnableFactory(ExecuteAsyncRunnableFactory executeAsyncRunnableFactory) {
        this.executeAsyncRunnableFactory = executeAsyncRunnableFactory;
    }

    public AsyncRunnableExecutionExceptionHandler getAsyncRunnableExecutionExceptionHandler() {
        return this.asyncRunnableExecutionExceptionHandler;
    }

    public void setAsyncRunnableExecutionExceptionHandler(AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        this.asyncRunnableExecutionExceptionHandler = asyncRunnableExecutionExceptionHandler;
    }

    public AcquireTimerJobsRunnable getTimerJobRunnable() {
        return this.timerJobRunnable;
    }

    public AcquireAsyncJobsDueRunnable getAsyncJobsDueRunnable() {
        return this.asyncJobsDueRunnable;
    }

    public ResetExpiredJobsRunnable getResetExpiredJobsRunnable() {
        return this.resetExpiredJobsRunnable;
    }

    public String getTenantId() {
        return this.configuration.getTenantId();
    }

    public void setTenantId(String tenantId) {
        this.configuration.setTenantId(tenantId);
    }

    public AsyncJobExecutorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AsyncJobExecutorConfiguration configuration) {
        this.configuration = configuration;
    }

    public class AcquireAsyncJobsDueRunnableConfiguration
    implements AcquireJobsRunnableConfiguration {
        @Override
        public boolean isGlobalAcquireLockEnabled() {
            return AbstractAsyncExecutor.this.configuration.isGlobalAcquireLockEnabled();
        }

        @Override
        public String getGlobalAcquireLockPrefix() {
            return AbstractAsyncExecutor.this.configuration.getGlobalAcquireLockPrefix();
        }

        @Override
        public Duration getLockWaitTime() {
            return AbstractAsyncExecutor.this.configuration.getAsyncJobsGlobalLockWaitTime();
        }

        @Override
        public Duration getLockPollRate() {
            return AbstractAsyncExecutor.this.configuration.getAsyncJobsGlobalLockPollRate();
        }

        @Override
        public Duration getLockForceAcquireAfter() {
            return AbstractAsyncExecutor.this.configuration.getAsyncJobsGlobalLockForceAcquireAfter();
        }
    }

    public class AcquireTimerRunnableConfiguration
    implements AcquireJobsRunnableConfiguration {
        @Override
        public boolean isGlobalAcquireLockEnabled() {
            return AbstractAsyncExecutor.this.configuration.isGlobalAcquireLockEnabled();
        }

        @Override
        public String getGlobalAcquireLockPrefix() {
            return AbstractAsyncExecutor.this.configuration.getGlobalAcquireLockPrefix();
        }

        @Override
        public Duration getLockWaitTime() {
            return AbstractAsyncExecutor.this.configuration.getTimerLockWaitTime();
        }

        @Override
        public Duration getLockPollRate() {
            return AbstractAsyncExecutor.this.configuration.getTimerLockPollRate();
        }

        @Override
        public Duration getLockForceAcquireAfter() {
            return AbstractAsyncExecutor.this.configuration.getTimerLockForceAcquireAfter();
        }
    }
}

