/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.support;

import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;

public class JSONFormatStyle {
    public static final JSONFormatStyle COMPACT = new JSONFormatStyle("", "", false);
    public static final JSONFormatStyle PRETTY = new JSONFormatStyle("\n", "  ", true);
    private final String newline;
    private final String indent;
    private final boolean spaceAfterSeparators;

    public static JSONFormatStyle getStyle(int indentFactor) {
        if (0 == indentFactor) {
            return COMPACT;
        }
        if (2 == indentFactor) {
            return PRETTY;
        }
        return new JSONFormatStyle("\n", StrUtil.repeat((char)' ', (int)indentFactor), indentFactor > 0);
    }

    public JSONFormatStyle(String newline, String indent, boolean spaceAfterSeparators) {
        this.newline = (String)Assert.notNull((Object)newline);
        this.indent = (String)Assert.notNull((Object)indent);
        this.spaceAfterSeparators = spaceAfterSeparators;
    }

    public String getNewline() {
        return this.newline;
    }

    public String getIndent() {
        return this.indent;
    }

    public boolean isSpaceAfterSeparators() {
        return this.spaceAfterSeparators;
    }
}

