/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.ReaderWrapper;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.JSONException;

public class JSONTokener
extends ReaderWrapper {
    private static final String TOKENS = ",:]}/\\\"[{;=#";
    public static final int EOF = 0;
    private long character = 1L;
    private boolean eof = false;
    private long index = 0L;
    private long line = 1L;
    private char previous = '\u0000';
    private boolean usePrevious = false;
    private boolean ignoreZeroWithChar;

    public JSONTokener(InputStream inputStream, boolean ignoreZeroWithChar) throws JSONException {
        this(IoUtil.toUtf8Reader((InputStream)inputStream), ignoreZeroWithChar);
    }

    public JSONTokener(CharSequence s, boolean ignoreZeroWithChar) {
        this(new StringReader(Assert.notBlank((CharSequence)s).toString()), ignoreZeroWithChar);
    }

    public JSONTokener(Reader reader, boolean ignoreZeroWithChar) {
        super(IoUtil.toMarkSupport((Reader)((Reader)Assert.notNull((Object)reader))));
        this.ignoreZeroWithChar = ignoreZeroWithChar;
    }

    public void back() throws JSONException {
        if (this.usePrevious || this.index <= 0L) {
            throw new JSONException("Stepping back two steps is not supported");
        }
        --this.index;
        --this.character;
        this.usePrevious = true;
        this.eof = false;
    }

    public boolean end() {
        return this.eof && !this.usePrevious;
    }

    public void checkEnd() {
        if ('\u0000' != this.nextClean()) {
            throw this.syntaxError("Invalid JSON, Unread data after end.");
        }
    }

    public boolean more() throws JSONException {
        this.next();
        if (this.end()) {
            return false;
        }
        this.back();
        return true;
    }

    public char next() throws JSONException {
        char c;
        do {
            c = this._next();
        } while (this.ignoreZeroWithChar && CharUtil.isZeroWidthChar((char)c));
        return c;
    }

    protected char getPrevious() {
        return this.previous;
    }

    public char nextUnicode() {
        return (char)NumberUtil.parseInt((char[])this.next(4), (int)16);
    }

    public char[] next(int n) throws JSONException {
        char[] chars = new char[n];
        for (int pos = 0; pos < n; ++pos) {
            chars[pos] = this.next();
            if (!this.end()) continue;
            throw this.syntaxError("Substring bounds error");
        }
        return chars;
    }

    public char nextTokenChar() throws JSONException {
        char c = this.nextClean();
        if (JSONTokener.isNotTokenChar(c)) {
            throw this.syntaxError("Invalid token char: " + c);
        }
        return c;
    }

    public char nextClean() throws JSONException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    public String nextKey(char c) throws JSONException {
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("A JSONObject text must end with '}'");
            }
            case '[': 
            case '{': {
                if ('{' == this.previous) {
                    throw this.syntaxError("A JSONObject can not directly nest another JSONObject or JSONArray.");
                }
            }
            case '\"': 
            case '\'': {
                return this.nextWrapString(c);
            }
        }
        return this.nextUnwrapString(c);
    }

    public char nextColon() throws JSONException {
        char c = this.nextClean();
        if (c != ':') {
            throw this.syntaxError("Expected a ':' after a key");
        }
        return c;
    }

    public String nextString() throws JSONException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextWrapString(c);
            }
        }
        return this.nextUnwrapString(c);
    }

    public String nextUnwrapString(char c) throws JSONException {
        String valueString;
        StringBuilder sb = new StringBuilder();
        while (JSONTokener.isNotTokenChar(c)) {
            sb.append(c);
            c = this.next();
        }
        if (c != '\u0000') {
            this.back();
        }
        if ((valueString = StrUtil.trim((CharSequence)sb)).isEmpty()) {
            throw this.syntaxError("Missing value, maybe a token");
        }
        return valueString;
    }

    public String nextWrapString(char quote) throws JSONException {
        StringBuilder sb = new StringBuilder();
        block5: while (true) {
            char c = this.next();
            switch (c) {
                case '\u0000': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\n': 
                case '\r': {
                    sb.append(c);
                    continue block5;
                }
                case '\\': {
                    c = this.next();
                    sb.append(this.getUnescapeChar(c));
                    continue block5;
                }
            }
            if (c == quote) {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    public JSONException syntaxError(String message) {
        return new JSONException(message + (Object)((Object)this));
    }

    public String toString() {
        return " at " + this.index + " [character " + this.character + " line " + this.line + "]";
    }

    private char _next() throws JSONException {
        int c;
        if (this.usePrevious) {
            this.usePrevious = false;
            c = this.previous;
        } else {
            try {
                c = this.read();
            }
            catch (IOException exception) {
                throw new JSONException(exception);
            }
            if (c <= 0) {
                this.eof = true;
                c = 0;
            }
        }
        ++this.index;
        if (this.previous == '\r') {
            ++this.line;
            this.character = c == 10 ? 0L : 1L;
        } else if (c == 10) {
            ++this.line;
            this.character = 0L;
        } else {
            ++this.character;
        }
        this.previous = (char)c;
        return this.previous;
    }

    private char getUnescapeChar(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case 'u': {
                return this.nextUnicode();
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': {
                return c;
            }
        }
        throw this.syntaxError("Illegal escape.");
    }

    private static boolean isNotTokenChar(char c) {
        return c >= ' ' && TOKENS.indexOf(c) < 0;
    }
}

