/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.jwt.signers;

import java.nio.charset.Charset;
import java.security.Key;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.digest.mac.HMac;
import org.dromara.hutool.json.jwt.signers.JWTSigner;

public class HMacJWTSigner
implements JWTSigner {
    private Charset charset = CharsetUtil.UTF_8;
    private final HMac hMac;

    public HMacJWTSigner(String algorithm, byte[] key) {
        this.hMac = new HMac(algorithm, key);
    }

    public HMacJWTSigner(String algorithm, Key key) {
        this.hMac = new HMac(algorithm, key);
    }

    public HMacJWTSigner setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String sign(String headerBase64, String payloadBase64) {
        return this.hMac.digestBase64(StrUtil.format((CharSequence)"{}.{}", (Object[])new Object[]{headerBase64, payloadBase64}), this.charset, true);
    }

    @Override
    public boolean verify(String headerBase64, String payloadBase64, String signBase64) {
        String sign = this.sign(headerBase64, payloadBase64);
        return this.hMac.verify(ByteUtil.toBytes((CharSequence)sign, (Charset)this.charset), ByteUtil.toBytes((CharSequence)signBase64, (Charset)this.charset));
    }

    @Override
    public String getAlgorithm() {
        return this.hMac.getAlgorithm();
    }
}

