/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.dromara.hutool.core.io.stream.ReaderInputStream;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.wrapper.Wrapper;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;
import org.dromara.hutool.json.engine.moshi.DateMoshiAdapter;
import org.dromara.hutool.json.engine.moshi.TemporalMoshiAdapter;
import org.dromara.hutool.json.engine.moshi.TimeZoneMoshiAdapter;

public class MoshiEngine
extends AbstractJSONEngine
implements Wrapper<Moshi> {
    private Moshi moshi;

    public MoshiEngine() {
        Assert.notNull(Moshi.class);
    }

    public Moshi getRaw() {
        this.initEngine();
        return this.moshi;
    }

    @Override
    public void serialize(Object bean, OutputStream out) {
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((OutputStream)out));
        try {
            this.getAdapter(bean.getClass()).toJson(sink, bean);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public String toJsonString(Object bean) {
        JsonAdapter<Object> adapter = this.getAdapter(bean.getClass());
        return adapter.toJson(bean);
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        BufferedSource source = Okio.buffer((Source)Okio.source((InputStream)new ReaderInputStream(reader, CharsetUtil.UTF_8)));
        JsonAdapter adapter = this.moshi.adapter((Type)type);
        try {
            return (T)adapter.fromJson(source);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    protected void reset() {
        this.moshi = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.moshi) {
            return;
        }
        JSONEngineConfig config = (JSONEngineConfig)ObjUtil.defaultIfNull((Object)this.config, JSONEngineConfig::of);
        Moshi.Builder builder = new Moshi.Builder();
        String dateFormat = config.getDateFormat();
        this.registerDate(builder, dateFormat);
        this.moshi = builder.build();
    }

    private JsonAdapter<Object> getAdapter(Type type) {
        this.initEngine();
        JsonAdapter adapter = this.moshi.adapter(type);
        if (((Boolean)ObjUtil.defaultIfNull((Object)this.config, JSONEngineConfig::isPrettyPrint, (Object)false)).booleanValue()) {
            adapter = adapter.indent("  ");
        }
        if (!((Boolean)ObjUtil.defaultIfNull((Object)this.config, JSONEngineConfig::isIgnoreNullValue, (Object)true)).booleanValue()) {
            adapter = adapter.serializeNulls();
        }
        return adapter;
    }

    private void registerDate(Moshi.Builder builder, String dateFormat) {
        builder.add(DateMoshiAdapter.createFactory(dateFormat));
        builder.add(LocalDateTime.class, (JsonAdapter)new TemporalMoshiAdapter(LocalDateTime.class, dateFormat));
        builder.add(LocalDate.class, (JsonAdapter)new TemporalMoshiAdapter(LocalDate.class, dateFormat));
        builder.add(LocalTime.class, (JsonAdapter)new TemporalMoshiAdapter(LocalTime.class, dateFormat));
        builder.add(TimeZoneMoshiAdapter.FACTORY);
    }
}

