/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import org.dromara.hutool.core.io.stream.UTF8OutputStreamWriter;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;

public class HutoolJSONEngine
extends AbstractJSONEngine {
    private JSONFactory jsonFactory;

    @Override
    public void serialize(Object bean, OutputStream out) {
        this.initEngine();
        JSON json = this.jsonFactory.parse(bean);
        json.write(this.jsonFactory.ofWriter((Appendable)new UTF8OutputStreamWriter(out), (Boolean)ObjUtil.defaultIfNull((Object)this.config, JSONEngineConfig::isPrettyPrint, (Object)false)));
    }

    @Override
    public String toJsonString(Object bean) {
        this.initEngine();
        JSON json = this.jsonFactory.parse(bean);
        boolean isPrettyPrint = (Boolean)ObjUtil.defaultIfNull((Object)this.config, JSONEngineConfig::isPrettyPrint, (Object)false);
        return isPrettyPrint ? json.toStringPretty() : json.toString();
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        JSON json = this.jsonFactory.parse(reader);
        return json.toBean((Type)type);
    }

    @Override
    public <T> T fromJsonString(String jsonStr, Object type) {
        this.initEngine();
        JSON json = this.jsonFactory.parse(jsonStr);
        return json.toBean((Type)type);
    }

    @Override
    protected void reset() {
        this.jsonFactory = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.jsonFactory) {
            return;
        }
        JSONConfig hutoolSJONConfig = JSONConfig.of();
        if (null != this.config) {
            hutoolSJONConfig.setDateFormat(this.config.getDateFormat());
            hutoolSJONConfig.setIgnoreNullValue(this.config.isIgnoreNullValue());
        }
        this.jsonFactory = JSONFactory.of(hutoolSJONConfig, null);
    }
}

