/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.openssl;

import java.io.InputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.SpecUtil;
import org.dromara.hutool.crypto.openssl.SaltMagic;

public class OpenSSLPBEInputStream
extends CipherInputStream {
    public OpenSSLPBEInputStream(InputStream in, String algorithm, int iterationCount, char[] password) {
        super(in, OpenSSLPBEInputStream.createDecryptCipher(algorithm, SaltMagic.getSalt(in), iterationCount, password));
    }

    private static Cipher createDecryptCipher(String algorithm, byte[] salt, int iterationCount, char[] password) {
        Cipher cipher = SecureUtil.createCipher(algorithm);
        try {
            cipher.init(2, (Key)KeyUtil.generatePBEKey(algorithm, password), SpecUtil.createPBEParameterSpec(salt, iterationCount));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return cipher;
    }
}

