/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern.matcher;

import java.util.Collections;
import java.util.List;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.cron.pattern.matcher.PartMatcher;

public class BoolArrayMatcher
implements PartMatcher {
    protected final int minValue;
    protected final boolean[] bValues;

    public BoolArrayMatcher(List<Integer> intValueList) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(intValueList), (String)"Values must be not empty!", (Object[])new Object[0]);
        this.bValues = new boolean[Collections.max(intValueList) + 1];
        int min = Integer.MAX_VALUE;
        for (Integer value : intValueList) {
            min = Math.min(min, value);
            this.bValues[value.intValue()] = true;
        }
        this.minValue = min;
    }

    @Override
    public boolean test(Integer value) {
        boolean[] bValues = this.bValues;
        if (null == value || value >= bValues.length) {
            return false;
        }
        return bValues[value];
    }

    @Override
    public int nextAfter(int value) {
        int minValue = this.minValue;
        if (value > minValue) {
            boolean[] bValues = this.bValues;
            while (value < bValues.length) {
                if (bValues[value]) {
                    return value;
                }
                ++value;
            }
        }
        return minValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public String toString() {
        return StrUtil.format((CharSequence)"Matcher:{}", (Object[])new Object[]{this.bValues});
    }
}

