/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ScalarProviderUtils;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.runtime.DbLiteral;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;

public class SqlBuilder
extends AbstractSqlBuilder<SqlBuilder> {
    private final AstContext ctx;
    private final boolean temporary;
    private final AbstractSqlBuilder.ScopeManager scopeManager;
    private final Ref<AbstractSqlBuilder.Scope> rollbackTo;
    private final SqlBuilder parent;
    private final boolean nonNullVariableOnly;
    private final SqlFormatter formatter;
    private final List<Object> variables = new ArrayList<Object>();
    private final List<Integer> variablePositions;
    private int childBuilderCount;
    private boolean terminated;
    private boolean aborted;

    public SqlBuilder(AstContext ctx) {
        this(ctx, false);
    }

    private SqlBuilder(AstContext ctx, boolean temporary) {
        this.ctx = ctx;
        this.temporary = temporary;
        this.scopeManager = new AbstractSqlBuilder.ScopeManager();
        this.parent = null;
        this.rollbackTo = null;
        this.nonNullVariableOnly = false;
        this.formatter = ctx.getSqlClient().getSqlFormatter();
        this.variablePositions = ctx.getSqlClient().getSqlFormatter().isPretty() ? new ArrayList<Integer>() : null;
    }

    private SqlBuilder(SqlBuilder parent, boolean isAbortingSupported, boolean nonNullVariableOnly) {
        if (nonNullVariableOnly && !isAbortingSupported) {
            throw new IllegalArgumentException("`isAbortingSupported` must be true when `nonNullVariableOnly` is true");
        }
        this.ctx = parent.ctx;
        this.temporary = false;
        this.scopeManager = parent.scopeManager;
        this.parent = parent;
        this.rollbackTo = isAbortingSupported ? Ref.of((Object)this.scopeManager.cloneScope()) : null;
        this.nonNullVariableOnly = nonNullVariableOnly;
        this.formatter = this.ctx.getSqlClient().getSqlFormatter();
        this.variablePositions = this.ctx.getSqlClient().getSqlFormatter().isPretty() ? new ArrayList<Integer>() : null;
        SqlBuilder p = parent;
        while (p != null) {
            ++p.childBuilderCount;
            p = p.parent;
        }
    }

    @Override
    public JSqlClientImplementor sqlClient() {
        return this.ctx.getSqlClient();
    }

    @Override
    protected final SqlFormatter formatter() {
        return this.formatter;
    }

    @Override
    protected final AbstractSqlBuilder.ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public AstContext getAstContext() {
        return this.ctx;
    }

    public SqlBuilder from() {
        this.preAppend();
        this.space('?');
        this.preAppend();
        this.builder.append("from ");
        return this;
    }

    public SqlBuilder join(JoinType joinType) {
        this.preAppend();
        this.space('?');
        this.preAppend();
        this.builder.append(joinType.name().toLowerCase()).append(" join ");
        return this;
    }

    public SqlBuilder on() {
        this.space('?');
        this.preAppend();
        if (this.formatter.isPretty()) {
            this.builder.append(this.formatter.getIndent());
        }
        this.builder.append("on ");
        return this;
    }

    @Override
    public SqlBuilder rawVariable(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("\"value\" cannot be null");
        }
        this.preAppend();
        this.builder.append(this.sqlClient().getDialect().jdbcParameter(value instanceof DbLiteral ? ((DbLiteral)value).getType() : value.getClass()));
        this.addVariable(value);
        if (this.variablePositions != null) {
            this.variablePositions.add(this.builder.length());
        }
        return this;
    }

    public <T> SqlBuilder variable(Class<T> type, T value) {
        if (value != null) {
            return this.variable(value);
        }
        return this.nullVariable(type);
    }

    public SqlBuilder variable(Object value) {
        this.validate();
        if (value instanceof TupleImplementor) {
            if (value instanceof Tuple2) {
                Tuple2 tuple = (Tuple2)value;
                ((SqlBuilder)((SqlBuilder)this.enter(AbstractSqlBuilder.ScopeType.TUPLE)).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).leave();
            } else if (value instanceof Tuple3) {
                Tuple3 tuple = (Tuple3)value;
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)this.enter(AbstractSqlBuilder.ScopeType.TUPLE)).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).leave();
            } else if (value instanceof Tuple4) {
                Tuple4 tuple = (Tuple4)value;
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)this.enter(AbstractSqlBuilder.ScopeType.TUPLE)).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).leave();
            } else if (value instanceof Tuple5) {
                Tuple5 tuple = (Tuple5)value;
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)this.enter(AbstractSqlBuilder.ScopeType.TUPLE)).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).leave();
            } else if (value instanceof Tuple6) {
                Tuple6 tuple = (Tuple6)value;
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)this.enter(AbstractSqlBuilder.ScopeType.TUPLE)).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).leave();
            } else if (value instanceof Tuple7) {
                Tuple7 tuple = (Tuple7)value;
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)this.enter(AbstractSqlBuilder.ScopeType.TUPLE)).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).leave();
            } else if (value instanceof Tuple8) {
                Tuple8 tuple = (Tuple8)value;
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)this.enter(AbstractSqlBuilder.ScopeType.TUPLE)).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_8(), "tuple.get_8 cannot be null")).leave();
            } else if (value instanceof Tuple9) {
                Tuple9 tuple = (Tuple9)value;
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)this.enter(AbstractSqlBuilder.ScopeType.TUPLE)).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_8(), "tuple.get_8 cannot be null")).separator()).nonTupleVariable(Objects.requireNonNull(tuple.get_9(), "tuple.get_9 cannot be null")).leave();
            }
        } else {
            this.nonTupleVariable(value);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SqlBuilder nonTupleVariable(Object value) {
        if (value instanceof DbLiteral) {
            this.preAppend();
            ((DbLiteral)value).render(this.builder, this.getAstContext().getSqlClient());
            this.addVariable(value);
            if (this.variablePositions == null) return this;
            this.variablePositions.add(this.builder.length());
            return this;
        }
        ScalarProvider scalarProvider = this.ctx.getSqlClient().getScalarProvider(value.getClass());
        if (scalarProvider != null) {
            try {
                value = ScalarProviderUtils.toSql(value, scalarProvider, this.getAstContext().getSqlClient().getDialect());
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot convert the jvm type \"" + value + "\" to the sql type \"" + ScalarProviderUtils.getSqlType(scalarProvider, this.sqlClient().getDialect()) + "\"", ex);
            }
        }
        if (value instanceof ImmutableSpi) {
            ImmutableSpi spi = (ImmutableSpi)value;
            ImmutableType type = spi.__type();
            if (type.isEntity()) {
                this.nonTupleVariable(spi.__get(type.getIdProp().getId()));
                return this;
            } else {
                if (!type.isEmbeddable()) throw new IllegalArgumentException("Immutable variable must be entity or embeddable");
                this.embeddedVariable(spi);
            }
            return this;
        } else {
            AbstractSqlBuilder.Converter arrayConverter = (AbstractSqlBuilder.Converter)ARRAY_CONVERTER_MAP.get(value.getClass());
            if (arrayConverter != null) {
                value = arrayConverter.convert(value);
            }
            this.preAppend();
            this.builder.append(this.sqlClient().getDialect().jdbcParameter(value instanceof DbLiteral ? ((DbLiteral)value).getType() : value.getClass()));
            this.addVariable(value);
            if (this.variablePositions == null) return this;
            this.variablePositions.add(this.builder.length());
        }
        return this;
    }

    private void embeddedVariable(ImmutableSpi spi) {
        this.enter(AbstractSqlBuilder.ScopeType.TUPLE);
        this.embeddedVariableImpl(spi, null);
        this.leave();
    }

    private void embeddedVariableImpl(ImmutableSpi spi, EmbeddedPath parentPath) {
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            if (prop.isFormula()) continue;
            EmbeddedPath path = new EmbeddedPath(parentPath, prop);
            if (!spi.__isLoaded(prop.getId())) {
                throw new IllegalArgumentException("Embedded object must loaded, the property path \"" + path + "\" is unloaded");
            }
            Object value = spi.__get(prop.getId());
            if (value == null) {
                this.separator();
                this.nullVariable(prop);
                continue;
            }
            if (value instanceof ImmutableSpi) {
                this.embeddedVariableImpl((ImmutableSpi)value, path);
                continue;
            }
            this.separator();
            this.nonTupleVariable(value);
        }
    }

    public SqlBuilder nullVariable(ImmutableProp prop) {
        ImmutableType targetType = prop.getTargetType();
        if (targetType == null) {
            return this.nullVariable(prop.getElementClass());
        }
        if (targetType.isEmbeddable()) {
            return this.nullEmbeddedVariable(targetType);
        }
        return this.nullVariable(targetType.getIdProp().getElementClass());
    }

    public SqlBuilder nullVariable(Class<?> type) {
        ImmutableType immutableType = ImmutableType.tryGet(type);
        if (immutableType != null) {
            this.nullImmutableVariable(immutableType);
        } else {
            this.nullSingeVariable(type);
        }
        return this;
    }

    private SqlBuilder nullImmutableVariable(ImmutableType type) {
        if (type.isEntity()) {
            ImmutableProp idProp = type.getIdProp();
            if (idProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                this.nullEmbeddedVariable(idProp.getTargetType());
            } else {
                this.nullSingeVariable(idProp.getElementClass());
            }
        } else if (type.isEmbeddable()) {
            this.nullEmbeddedVariable(type);
        } else {
            throw new IllegalArgumentException("Immutable variable must be entity or embeddable");
        }
        return this;
    }

    private SqlBuilder nullEmbeddedVariable(ImmutableType type) {
        this.validate();
        this.enter(AbstractSqlBuilder.ScopeType.TUPLE);
        this.nullEmbeddedVariableImpl(type);
        this.leave();
        return this;
    }

    private void nullEmbeddedVariableImpl(ImmutableType type) {
        for (ImmutableProp prop : type.getProps().values()) {
            if (prop.isFormula()) continue;
            ImmutableType targetType = prop.getTargetType();
            if (targetType != null) {
                this.nullEmbeddedVariableImpl(targetType);
                continue;
            }
            this.separator();
            this.nullSingeVariable(prop.getElementClass());
        }
    }

    private void nullSingeVariable(Class<?> type) {
        this.validate();
        ScalarProvider scalarProvider = this.ctx.getSqlClient().getScalarProvider(type);
        DbLiteral.DbNull finalValue = scalarProvider != null ? new DbLiteral.DbNull(ScalarProviderUtils.getSqlType(scalarProvider, this.ctx.getSqlClient().getDialect())) : new DbLiteral.DbNull(type);
        this.preAppend();
        this.builder.append(this.sqlClient().getDialect().jdbcParameter(finalValue.getType()));
        this.addVariable(finalValue);
        if (this.variablePositions != null) {
            this.variablePositions.add(this.builder.length());
        }
    }

    public SqlBuilder createChildBuilder() {
        return new SqlBuilder(this, false, false);
    }

    public SqlBuilder createChildBuilder(boolean isAbortingSupported, boolean nonNullVariableOnly) {
        return new SqlBuilder(this, isAbortingSupported, nonNullVariableOnly);
    }

    public SqlBuilder createTempBuilder() {
        return new SqlBuilder(this.ctx, true);
    }

    public SqlBuilder abort() {
        if (this.rollbackTo == null) {
            throw new IllegalStateException("The current sql builder is not allowed to be aborted");
        }
        this.aborted = true;
        return this;
    }

    public SqlBuilder appendTempBuilder(SqlBuilder tempBuilder) {
        if (!tempBuilder.temporary) {
            throw new IllegalArgumentException("tempBuilder is not temporary sql builder");
        }
        if (tempBuilder == this) {
            throw new IllegalArgumentException("tempBuilder cannot be current sql builder");
        }
        Tuple3<String, List<Object>, List<Integer>> tuple = tempBuilder.build();
        int len = this.builder.length();
        this.sql(tuple.get_1());
        this.variables.addAll((Collection<Object>)tuple.get_2());
        if (this.variablePositions != null) {
            for (Integer position : tuple.get_3()) {
                this.variablePositions.add(len + position);
            }
        }
        return this;
    }

    public Tuple3<String, List<Object>, List<Integer>> build() {
        return this.build(null);
    }

    public Tuple3<String, List<Object>, List<Integer>> build(Function<Tuple3<String, List<Object>, List<Integer>>, Tuple3<String, List<Object>, List<Integer>>> transformer) {
        SqlBuilder p;
        if (this.parent == null && this.scopeManager.current != null) {
            throw new IllegalStateException("Internal bug: Did not leave all scopes");
        }
        this.validate();
        if (this.aborted) {
            this.scopeManager.current = (AbstractSqlBuilder.Scope)this.rollbackTo.getValue();
            SqlBuilder p2 = this.parent;
            while (p2 != null) {
                --p2.childBuilderCount;
                p2 = p2.parent;
            }
            this.terminated = true;
            return new Tuple3<String, List<Object>, List<Integer>>("", Collections.emptyList(), Collections.emptyList());
        }
        Tuple3<String, List<Object>, List<Integer>> result = new Tuple3<String, List<Object>, List<Integer>>(this.builder.toString(), this.variables, this.variablePositions);
        if (transformer != null) {
            result = transformer.apply(result);
        }
        if ((p = this.parent) != null) {
            this.preAppend();
            if (p.variablePositions != null) {
                int base = p.builder.length();
                for (Integer position : result.get_3()) {
                    p.variablePositions.add(base + position);
                }
            }
            p.builder.append(result.get_1());
            p.variables.addAll((Collection<Object>)result.get_2());
            while (p != null) {
                --p.childBuilderCount;
                p = p.parent;
            }
        }
        this.terminated = true;
        return result;
    }

    private void validate() {
        if (this.childBuilderCount != 0) {
            throw new IllegalStateException("Internal bug: Cannot change sqlbuilder because there are some child builders");
        }
        if (this.terminated) {
            throw new IllegalStateException("Internal bug: Current build has been terminated");
        }
    }

    private void addVariable(Object value) {
        if (this.nonNullVariableOnly && value instanceof DbLiteral.DbNull) {
            throw new NullVariableException();
        }
        this.variables.add(value);
    }

    private static class EmbeddedPath {
        final EmbeddedPath parent;
        final ImmutableProp prop;

        EmbeddedPath(EmbeddedPath parent, ImmutableProp prop) {
            this.parent = parent;
            this.prop = prop;
        }

        public String toString() {
            if (this.parent == null) {
                return this.prop.getName();
            }
            return this.parent.toString() + '.' + this.prop.getName();
        }
    }

    public static class NullVariableException
    extends RuntimeException {
    }
}

