/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.function.BiFunction;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.ExecutorForLog;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlFunction;
import org.babyfish.jimmer.sql.runtime.StatementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface Executor {
    public <R> R execute(@NotNull Args<R> var1);

    public BatchContext executeBatch(@NotNull Connection var1, @NotNull String var2, @Nullable ImmutableProp var3, @NotNull ExecutionPurpose var4, @NotNull JSqlClientImplementor var5);

    default public void openCursor(long cursorId, String sql, List<Object> variables, List<Integer> variablePositions, ExecutionPurpose purpose, @Nullable ExecutorContext ctx, JSqlClientImplementor sqlClient) {
    }

    public static Executor log() {
        return ExecutorForLog.wrap(DefaultExecutor.INSTANCE, null);
    }

    public static Executor log(Executor executor) {
        return ExecutorForLog.wrap(executor, null);
    }

    public static Executor log(Logger logger) {
        return ExecutorForLog.wrap(DefaultExecutor.INSTANCE, logger);
    }

    public static Executor log(Executor executor, Logger logger) {
        return ExecutorForLog.wrap(executor, logger);
    }

    public static void validateMutationConnection(Connection con) {
        try {
            if (con.getAutoCommit()) {
                throw new ExecutionException("When configuration about mutation-transaction-required(Either global configuration or mutation operation level configuration) is enabled, the mutation operation must be executed based on JDBC connection without auto commit, Do you forget to open transaction?");
            }
        }
        catch (SQLException e) {
            throw new ExecutionException("Failed to retrieve the auto-commit mode of the connection");
        }
    }

    public static interface BatchContext
    extends ExceptionTranslator.Args,
    AutoCloseable {
        @Override
        public JSqlClientImplementor sqlClient();

        @Override
        public String sql();

        @Override
        public ExecutionPurpose purpose();

        @Override
        public ExecutorContext ctx();

        public void add(List<Object> var1);

        public int[] execute(BiFunction<SQLException, ExceptionTranslator.Args, Exception> var1);

        public Object[] generatedIds();

        public void addExecutedListener(Runnable var1);

        @Override
        public void close();
    }

    public static class Args<R>
    implements ExceptionTranslator.Args {
        public final JSqlClientImplementor sqlClient;
        public final Connection con;
        public final String sql;
        public final List<Object> variables;
        @Nullable
        public final List<Integer> variablePositions;
        public final ExecutionPurpose purpose;
        private final ExceptionTranslator<?> exceptionTranslator;
        @Nullable
        public final ExecutorContext ctx;
        public final StatementFactory statementFactory;
        public final SqlFunction<PreparedStatement, R> block;
        @Nullable
        public final Long closingCursorId;

        public Args(JSqlClientImplementor sqlClient, Connection con, String sql, List<Object> variables, @Nullable List<Integer> variablePositions, ExecutionPurpose purpose, ExceptionTranslator<?> exceptionTranslator, @Nullable StatementFactory statementFactory, SqlFunction<PreparedStatement, R> block) {
            this.sqlClient = sqlClient;
            this.con = con;
            this.sql = sql;
            this.variables = variables;
            this.variablePositions = variablePositions;
            this.purpose = purpose;
            this.exceptionTranslator = exceptionTranslator != null ? exceptionTranslator : sqlClient.getExceptionTranslator();
            this.ctx = ExecutorContext.create(sqlClient);
            this.statementFactory = statementFactory;
            this.block = block;
            this.closingCursorId = null;
        }

        public Args(JSqlClientImplementor sqlClient, Connection con, String sql, List<Object> variables, @Nullable List<Integer> variablePositions, ExecutionPurpose purpose, @Nullable StatementFactory statementFactory, SqlFunction<PreparedStatement, R> block, long closingCursorId) {
            this.sqlClient = sqlClient;
            this.con = con;
            this.sql = sql;
            this.variables = variables;
            this.variablePositions = variablePositions;
            this.purpose = purpose;
            this.exceptionTranslator = null;
            this.ctx = ExecutorContext.create(sqlClient);
            this.statementFactory = statementFactory;
            this.block = block;
            this.closingCursorId = closingCursorId;
        }

        @Override
        public JSqlClientImplementor sqlClient() {
            return this.sqlClient;
        }

        @Override
        public String sql() {
            return this.sql;
        }

        @Override
        public ExecutionPurpose purpose() {
            return this.purpose;
        }

        public ExceptionTranslator<?> getExceptionTranslator() {
            return this.exceptionTranslator;
        }

        @Override
        public ExecutorContext ctx() {
            return this.ctx;
        }
    }
}

