/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.Ids;

public class FetchingCache {
    private static final Object NULL = new Object();
    private final Map<FieldKey, Map<Object, Object>> map = new HashMap<FieldKey, Map<Object, Object>>();

    public Object createKey(Field field, ImmutableSpi owner) {
        ImmutableProp prop = field.getProp();
        if (prop.isColumnDefinition()) {
            Object fk = Ids.idOf((ImmutableSpi)owner.__get(prop.getId()));
            DraftContext ctx = owner instanceof DraftSpi ? ((DraftSpi)owner).__draftContext() : null;
            return new ForeignKey(fk, ctx);
        }
        return Ids.idOf(owner);
    }

    public Object get(Field field, Object key) {
        Map<Object, Object> subMap = this.map.get(new FieldKey(field));
        if (subMap == null) {
            return null;
        }
        Object value = subMap.get(key);
        return value != NULL ? value : null;
    }

    public void put(Field field, Object key, Object value) {
        Map subMap = this.map.computeIfAbsent(new FieldKey(field), it -> new HashMap());
        subMap.put(key, value != null ? value : NULL);
    }

    public static Object unwrap(Object value) {
        return value == NULL ? null : value;
    }

    private static class ForeignKey {
        private final Object raw;
        private final DraftContext ctx;

        private ForeignKey(Object raw, DraftContext ctx) {
            this.raw = raw;
            this.ctx = ctx;
        }

        public int hashCode() {
            return Objects.hash(this.raw, this.ctx);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForeignKey that = (ForeignKey)o;
            return Objects.equals(this.raw, that.raw) && this.ctx == that.ctx;
        }

        public String toString() {
            return "ForeignKey{raw=" + this.raw + "ctx=" + this.ctx + '}';
        }
    }

    private static class FieldKey {
        private final Field field;

        FieldKey(Field field) {
            this.field = field.resolveRecursion();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            return this.field.equals(fieldKey.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public String toString() {
            return "FieldKey{field=" + this.field + '}';
        }
    }
}

