/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.babyfish.jimmer.sql.ast.SqlTimeUnit;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.query.ForUpdate;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.query.LockMode;
import org.babyfish.jimmer.sql.ast.query.LockWait;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.jetbrains.annotations.Nullable;

public class SqlServerDialect
extends DefaultDialect {
    @Override
    public boolean isTupleSupported() {
        return false;
    }

    @Override
    public boolean isDeletedAliasRequired() {
        return true;
    }

    @Override
    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar";
        }
        if (elementType == UUID.class) {
            return "char(36)";
        }
        if (elementType == Boolean.TYPE) {
            return "boolean";
        }
        if (elementType == Byte.TYPE) {
            return "tinyint";
        }
        if (elementType == Short.TYPE) {
            return "smallint";
        }
        if (elementType == Integer.TYPE) {
            return "int";
        }
        if (elementType == Long.TYPE) {
            return "bigint";
        }
        if (elementType == Float.TYPE) {
            return "float";
        }
        if (elementType == Double.TYPE) {
            return "real";
        }
        if (elementType == BigDecimal.class) {
            return "decimal";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "time";
        }
        if (elementType == OffsetTime.class) {
            return "datetime";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "datetime";
        }
        if (elementType == LocalDateTime.class) {
            return "datetime";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class) {
            return "datetime";
        }
        return null;
    }

    @Override
    public void paginate(PaginationContext ctx) {
        ctx.origin().sql(" offset ").variable(ctx.getOffset()).sql(" rows fetch next ").variable(ctx.getLimit()).sql(" rows only");
    }

    @Override
    public void renderLPad(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expression, Ast length, Ast padString) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("right(replicate(")).ast(padString, currentPrecedence)).sql(", ")).ast(length, currentPrecedence)).sql(") + ")).ast(expression, currentPrecedence)).sql(", ")).ast(length, currentPrecedence)).sql(")");
    }

    @Override
    public void renderRPad(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expression, Ast length, Ast padString) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("left(")).ast(expression, currentPrecedence)).sql(" + replicate(")).ast(padString, currentPrecedence)).sql(", ")).ast(length, currentPrecedence)).sql("), ")).ast(length, currentPrecedence)).sql(")");
    }

    @Override
    public void renderPosition(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast subStrAst, Ast expressionAst, @Nullable Ast startAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("charindex(")).ast(subStrAst, currentPrecedence)).sql(", ")).ast(expressionAst, currentPrecedence);
        if (startAst != null) {
            ((AbstractSqlBuilder)builder.sql(", ")).ast(startAst, currentPrecedence);
        }
        builder.sql(")");
    }

    @Override
    public void renderTimeDiff(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast otherAst, SqlTimeUnit timeUnit) {
        String op;
        switch (timeUnit) {
            case NANOSECONDS: {
                op = " * 1000000";
                break;
            }
            case MICROSECONDS: {
                op = " * 1000";
                break;
            }
            case MILLISECONDS: {
                op = "";
                break;
            }
            case SECONDS: {
                op = " / 1000";
                break;
            }
            case MINUTES: {
                op = " / 60000";
                break;
            }
            case HOURS: {
                op = " / 3600000";
                break;
            }
            case DAYS: {
                op = " / 86400000";
                break;
            }
            case WEEKS: {
                op = " / 86400000 / 7.0";
                break;
            }
            case MONTHS: {
                op = " / 86400000 / 30.44";
                break;
            }
            case QUARTERS: {
                op = " / 86400000 / 91.31";
                break;
            }
            case YEARS: {
                op = " / 86400000 / 365.24";
                break;
            }
            case DECADES: {
                op = " / 86400000 / 3652.4";
                break;
            }
            case CENTURIES: {
                op = " / 86400000 / 36524.0";
                break;
            }
            default: {
                throw new IllegalStateException("Time diff by unit \"" + (Object)((Object)timeUnit) + "\" is not supported by \"" + this.getClass().getName() + "\"");
            }
        }
        builder.sql("datediff(millisecond, ");
        builder.ast(expressionAst, 0);
        builder.sql(", ");
        builder.ast(otherAst, 0);
        ((AbstractSqlBuilder)builder.sql(")")).sql(op);
    }

    @Override
    public void renderForUpdate(AbstractSqlBuilder<?> builder, ForUpdate forUpdate) {
        if (forUpdate.getLockMode() != LockMode.UPDATE) {
            throw new IllegalArgumentException("SqlServer only supports LockMode.UPDATE");
        }
        LockWait wait = forUpdate.getLockWait();
        if (wait == LockWait.DEFAULT) {
            builder.sql(" with(updlock, rowlock)");
        } else if (wait == LockWait.SKIP_LOCKED) {
            builder.sql(" with(updlock, rowlock, readpast)");
        } else {
            throw new IllegalArgumentException("SqlServer does not support " + wait);
        }
    }
}

