/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.di;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.di.AbstractJSqlClientDelegate;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public abstract class JLazyInitializationSqlClient
extends AbstractJSqlClientDelegate {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private JSqlClientImplementor sqlClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final JSqlClientImplementor sqlClient() {
        JSqlClientImplementor sqlClient;
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            sqlClient = this.sqlClient;
        }
        finally {
            lock.unlock();
        }
        if (sqlClient == null) {
            lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                sqlClient = this.sqlClient;
                if (sqlClient == null) {
                    JSqlClient.Builder builder = this.createBuilder();
                    sqlClient = (JSqlClientImplementor)builder.build();
                    this.afterCreate(sqlClient);
                    this.sqlClient = sqlClient;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return sqlClient;
    }

    protected abstract JSqlClient.Builder createBuilder();

    protected void afterCreate(JSqlClientImplementor sqlClient) {
    }

    @Override
    public <T extends SqlContext> T unwrap() {
        return (T)this.sqlClient();
    }

    public static JSqlClient.Builder newBuilder() {
        return JSqlClient.newBuilder();
    }
}

