/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.util;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.impl.util.ImNode;
import org.jetbrains.annotations.NotNull;

public final class IdentityMap<K, V>
extends ImNode<K, V>
implements Iterable<V> {
    private static final int CAPACITY = 8;
    private ImNode<K, V>[] tab;
    private int modCount;

    public IdentityMap() {
        super(0, null, null, null, null, null);
        this.before = this;
        this.after = this;
    }

    public V put(K key, V value) {
        ImNode<K, V> startNode;
        if (this.tab == null) {
            this.tab = new ImNode[8];
        }
        int h = System.identityHashCode(key);
        h ^= h >>> 16;
        int index = 7 & h;
        ImNode<K, V> node = startNode = this.tab[index];
        while (node != null) {
            if (node.key == key) {
                Object oldValue = node.value;
                node.value = value;
                ++this.modCount;
                return oldValue;
            }
            node = node.next;
        }
        ImNode last = this.before;
        ImNode<K, V> node2 = new ImNode<K, V>(h, key, value, startNode, last, this);
        last.after = node2;
        this.before = node2;
        this.tab[index] = node2;
        ++this.modCount;
        return null;
    }

    public V get(K key) {
        ImNode<K, V> startNode;
        ImNode<K, V>[] tab = this.tab;
        if (tab == null) {
            return null;
        }
        int h = System.identityHashCode(key);
        h ^= h >>> 16;
        int index = 7 & h;
        ImNode<K, V> node = startNode = tab[index];
        while (node != null) {
            if (node.key == key) {
                return node.value;
            }
            node = node.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.after == this;
    }

    public void replaceAll(Function<V, V> replacer) {
        if (replacer == null || this.tab == null) {
            return;
        }
        ImNode<K, V>[] imNodeArray = this.tab;
        int n = imNodeArray.length;
        for (int i = 0; i < n; ++i) {
            ImNode<K, V> node;
            ImNode<K, V> n2 = node = imNodeArray[i];
            while (n2 != null) {
                n2.value = replacer.apply(n2.value);
                ++this.modCount;
                n2 = n2.next;
            }
        }
    }

    public void removeAll(BiPredicate<K, V> predicate) {
        if (predicate == null || this.after == this) {
            return;
        }
        ImNode<K, V>[] tab = this.tab;
        ImNode node = this.after;
        while (node != this) {
            if (predicate.test(node.key, node.value)) {
                node.before.after = node.after;
                node.after.before = node.before;
                int index = node.hash & 7;
                ImNode<K, V> p = null;
                ImNode<K, V> n = tab[index];
                while (n != null) {
                    if (node == n) {
                        if (p != null) {
                            p.next = n.next;
                            break;
                        }
                        tab[index] = n.next;
                        break;
                    }
                    p = n;
                    n = n.next;
                }
                ++this.modCount;
            }
            node = node.after;
        }
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        if (this.after == this) {
            return Collections.emptyIterator();
        }
        return new Itr();
    }

    public String toString() {
        if (this.after == this) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        boolean addComma = false;
        ImNode n = this.after;
        while (n != this) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(n.key).append(": ").append(n.value);
            n = n.after;
        }
        builder.append('}');
        return builder.toString();
    }

    private class Itr
    implements Iterator<V> {
        private final int modCount;
        private ImNode<K, V> current;

        public Itr() {
            this.modCount = IdentityMap.this.modCount;
            this.current = IdentityMap.this.after;
        }

        @Override
        public boolean hasNext() {
            if (IdentityMap.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != IdentityMap.this;
        }

        @Override
        public V next() {
            if (IdentityMap.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.current == IdentityMap.this) {
                throw new NoSuchElementException();
            }
            Object v = this.current.value;
            this.current = this.current.after;
            return v;
        }
    }
}

