/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.ClassCache;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.table.KWeakJoinImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinLambda;
import org.babyfish.jimmer.sql.ast.table.BaseTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.WeakJoin;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UntypedJoinDisabledTableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UsingWeakJoinMetadataParser;
import org.babyfish.jimmer.sql.ast.table.spi.WeakJoinMetadata;
import org.babyfish.jimmer.sql.ast.table.spi.WeakJoinMetadataParser;

abstract class WeakJoinHandleImpl
implements WeakJoinHandle {
    private static final ClassCache<WeakJoinHandle> CACHE;
    private static final Class<?> K_BASE_TABLE_TYPE;
    public static final Class<?> K_BASE_TABLE_TYPE_SYMBOL;
    final WeakJoin<TableLike<?>, TableLike<?>> weakJoin;

    WeakJoinHandleImpl(WeakJoin<TableLike<?>, TableLike<?>> weakJoin) {
        this.weakJoin = weakJoin;
    }

    static WeakJoinHandle get(Class<? extends WeakJoin<?, ?>> weakJoinType) {
        return (WeakJoinHandle)CACHE.get(weakJoinType);
    }

    @Override
    public Class<? extends WeakJoin<?, ?>> getWeakJoinType() {
        return this.weakJoin.getClass();
    }

    private static WeakJoinHandle create(Class<?> weakJoinType) {
        Map typeArguments;
        UsingWeakJoinMetadataParser using = weakJoinType.getAnnotation(UsingWeakJoinMetadataParser.class);
        if (using != null) {
            WeakJoinMetadataParser parser;
            try {
                parser = using.value().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException("Cannot create instance of \"" + using.value() + "\"", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot create instance of \"" + using.value() + "\"", ex);
            }
            WeakJoinMetadata metadata = parser.parse(weakJoinType);
            if (metadata != null) {
                if (metadata.isSourceBaseTable() && metadata.isTargetBaseTable()) {
                    return new BaseTableHandleImpl(null, WeakJoinHandleImpl.createWeakJoin(weakJoinType));
                }
                return new EntityTableHandleImpl(ImmutableType.get(metadata.getSourceEntityType()), ImmutableType.get(metadata.getTargetEntityType()), false, false, WeakJoinHandleImpl.createWeakJoin(weakJoinType));
            }
        }
        if ((typeArguments = TypeUtils.getTypeArguments(weakJoinType, WeakJoin.class)) == null || typeArguments.isEmpty()) {
            throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", generic arguments are missing");
        }
        Type sourceTableType = (Type)typeArguments.get(WeakJoin.class.getTypeParameters()[0]);
        Type targetTableType = (Type)typeArguments.get(WeakJoin.class.getTypeParameters()[1]);
        if (WeakJoinHandleImpl.isBaseTable(sourceTableType) && WeakJoinHandleImpl.isBaseTable(targetTableType)) {
            return new BaseTableHandleImpl(null, WeakJoinHandleImpl.createWeakJoin(weakJoinType));
        }
        Type sourceType = (Type)TypeUtils.getTypeArguments((Type)sourceTableType, TableLike.class).values().iterator().next();
        Type targetType = (Type)TypeUtils.getTypeArguments((Type)targetTableType, TableLike.class).values().iterator().next();
        if (sourceType instanceof TypeVariable) {
            sourceType = (Type)typeArguments.get((TypeVariable)sourceType);
        }
        if (targetType instanceof TypeVariable) {
            targetType = (Type)typeArguments.get((TypeVariable)targetType);
        }
        if (!(sourceType instanceof Class) || !((Class)sourceType).isAnnotationPresent(Entity.class)) {
            throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", the source type is not entity");
        }
        if (!(targetType instanceof Class) || !((Class)targetType).isAnnotationPresent(Entity.class)) {
            throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", the target type is not entity");
        }
        boolean hasSourceWrapper = TableProxies.tableWrapperClass((Class)sourceType) != null;
        boolean hasTargetWrapper = TableProxies.tableWrapperClass((Class)targetType) != null;
        return new EntityTableHandleImpl(ImmutableType.get((Class)((Class)sourceType)), ImmutableType.get((Class)((Class)targetType)), hasSourceWrapper, hasTargetWrapper, WeakJoinHandleImpl.createWeakJoin(weakJoinType));
    }

    static WeakJoin<TableLike<?>, TableLike<?>> createWeakJoin(Class<?> weakJoinType) {
        WeakJoin weakJoin;
        Constructor<?> constructor;
        try {
            constructor = weakJoinType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("No default constructor can be found in \"" + weakJoinType.getName() + "\"");
        }
        constructor.setAccessible(true);
        try {
            weakJoin = (WeakJoin)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException("Cannot create instance of \"" + weakJoinType.getName() + "\"", ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("Cannot create instance of \"" + weakJoinType.getName() + "\"", ex.getTargetException());
        }
        return weakJoin;
    }

    private static boolean isBaseTable(Type type) {
        Class tableType;
        if (type instanceof Class) {
            if (BaseTable.class.isAssignableFrom((Class)type)) {
                return true;
            }
            if (K_BASE_TABLE_TYPE != null && K_BASE_TABLE_TYPE.isAssignableFrom((Class)type)) {
                return true;
            }
        }
        if (type instanceof Class) {
            tableType = (Class)type;
        } else {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            tableType = (Class)parameterizedType.getRawType();
        }
        return BaseTable.class.isAssignableFrom(tableType);
    }

    static {
        Class<?> kotlinBaseTableSymbolType;
        Class<?> kotlinBaseTableType;
        CACHE = new ClassCache(WeakJoinHandleImpl::create, false);
        try {
            kotlinBaseTableType = Class.forName("org.babyfish.jimmer.sql.kt.ast.table.KBaseTable");
        }
        catch (ClassNotFoundException ex) {
            kotlinBaseTableType = null;
        }
        K_BASE_TABLE_TYPE = kotlinBaseTableType;
        try {
            kotlinBaseTableSymbolType = Class.forName("org.babyfish.jimmer.sql.kt.ast.table.KBaseTableSymbol");
        }
        catch (ClassNotFoundException ex) {
            kotlinBaseTableSymbolType = null;
        }
        K_BASE_TABLE_TYPE_SYMBOL = kotlinBaseTableSymbolType;
    }

    public static class BaseTableHandleImpl
    extends WeakJoinHandleImpl
    implements WeakJoinHandle.BaseTableHandle {
        private final WeakJoinLambda weakJoinLambda;

        BaseTableHandleImpl(WeakJoinLambda weakJoinLambda, WeakJoin<TableLike<?>, TableLike<?>> weakJoin) {
            super(weakJoin);
            this.weakJoinLambda = weakJoinLambda;
        }

        @Override
        public Predicate createPredicate(TableLike<?> source, TableLike<?> target, AbstractMutableStatementImpl statement) {
            if (this.weakJoin instanceof KWeakJoinImplementor) {
                KWeakJoinImplementor implementor = (KWeakJoinImplementor)((Object)this.weakJoin);
                return implementor.on(source, target, statement);
            }
            return this.weakJoin.on(source, target);
        }

        public int hashCode() {
            return this.weakJoinLambda != null ? this.weakJoinLambda.hashCode() : this.getWeakJoinType().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BaseTableHandleImpl)) {
                return false;
            }
            BaseTableHandleImpl that = (BaseTableHandleImpl)obj;
            if (this.weakJoinLambda != null) {
                return this.weakJoinLambda.equals(that.weakJoinLambda);
            }
            return this.getWeakJoinType() == that.getWeakJoinType();
        }

        public String toString() {
            return "WeakBaseTableJoinHandle{weakJoin=" + this.weakJoin + '}';
        }
    }

    static final class EntityTableHandleImpl
    extends WeakJoinHandleImpl
    implements WeakJoinHandle.EntityTableHandle {
        private static final String JOIN_ERROR_REASON = "it is forbidden in the implementation of \"" + WeakJoin.class.getName() + "\"";
        private static final ClassCache<WeakJoinHandle> CACHE = new ClassCache(EntityTableHandleImpl::create, false);
        private final WeakJoinLambda weakJoinLambda;
        private final ImmutableType sourceType;
        private final ImmutableType targetType;
        private final boolean hasSourceWrapper;
        private final boolean hasTargetWrapper;

        private EntityTableHandleImpl(ImmutableType sourceType, ImmutableType targetType, boolean hasSourceWrapper, boolean hasTargetWrapper, WeakJoin<TableLike<?>, TableLike<?>> weakJoin) {
            super(weakJoin);
            this.weakJoinLambda = null;
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.hasSourceWrapper = hasSourceWrapper;
            this.hasTargetWrapper = hasTargetWrapper;
        }

        public EntityTableHandleImpl(WeakJoinLambda weakJoinLambda, boolean hasSourceWrapper, boolean hasTargetWrapper, WeakJoin<TableLike<?>, TableLike<?>> weakJoin) {
            super(weakJoin);
            this.weakJoinLambda = weakJoinLambda;
            this.sourceType = ImmutableType.get(weakJoinLambda.getSourceType());
            this.targetType = ImmutableType.get(weakJoinLambda.getTargetType());
            this.hasSourceWrapper = hasSourceWrapper;
            this.hasTargetWrapper = hasTargetWrapper;
        }

        @Override
        public ImmutableType getSourceType() {
            return this.sourceType;
        }

        @Override
        public ImmutableType getTargetType() {
            return this.targetType;
        }

        public int hashCode() {
            return this.weakJoinLambda != null ? this.weakJoinLambda.hashCode() : this.getWeakJoinType().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EntityTableHandleImpl)) {
                return false;
            }
            EntityTableHandleImpl that = (EntityTableHandleImpl)obj;
            if (this.weakJoinLambda != null) {
                return this.weakJoinLambda.equals(that.weakJoinLambda);
            }
            return this.getWeakJoinType() == that.getWeakJoinType();
        }

        public String toString() {
            return "WeakJoinHandle.EntityTable{weakJoin=" + this.weakJoin + '}';
        }

        @Override
        public Predicate createPredicate(TableLike<?> source, TableLike<?> target, AbstractMutableStatementImpl statement) {
            if (this.weakJoin instanceof KWeakJoinImplementor) {
                KWeakJoinImplementor implementor = (KWeakJoinImplementor)((Object)this.weakJoin);
                return implementor.on(source instanceof TableProxy ? ((TableProxy)source).__unwrap() : (TableImplementor)source, target instanceof TableProxy ? ((TableProxy)target).__unwrap() : (TableImplementor)target, statement);
            }
            return this.weakJoin.on(this.hasSourceWrapper ? ((TableProxy)TableProxies.wrap((Table)source)).__disableJoin(JOIN_ERROR_REASON) : new UntypedJoinDisabledTableProxy((TableImplementor)source, JOIN_ERROR_REASON), this.hasTargetWrapper ? ((TableProxy)TableProxies.wrap((Table)target)).__disableJoin(JOIN_ERROR_REASON) : new UntypedJoinDisabledTableProxy((TableImplementor)target, JOIN_ERROR_REASON));
        }

        private static WeakJoinHandle create(Class<?> weakJoinType) {
            WeakJoin weakJoin;
            Constructor<?> constructor;
            Map typeArguments = TypeUtils.getTypeArguments(weakJoinType, WeakJoin.class);
            if (typeArguments == null || typeArguments.isEmpty()) {
                throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", generic arguments are missing");
            }
            Type sourceTableType = (Type)typeArguments.get(WeakJoin.class.getTypeParameters()[0]);
            Type targetTableType = (Type)typeArguments.get(WeakJoin.class.getTypeParameters()[1]);
            Type sourceType = (Type)TypeUtils.getTypeArguments((Type)sourceTableType, Table.class).values().iterator().next();
            Type targetType = (Type)TypeUtils.getTypeArguments((Type)targetTableType, Table.class).values().iterator().next();
            if (sourceType instanceof TypeVariable) {
                sourceType = (Type)typeArguments.get((TypeVariable)sourceType);
            }
            if (targetType instanceof TypeVariable) {
                targetType = (Type)typeArguments.get((TypeVariable)targetType);
            }
            if (!(sourceType instanceof Class) || !((Class)sourceType).isAnnotationPresent(Entity.class)) {
                throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", the source type is not entity");
            }
            if (!(targetType instanceof Class) || !((Class)targetType).isAnnotationPresent(Entity.class)) {
                throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", the target type is not entity");
            }
            boolean hasSourceWrapper = TableProxies.tableWrapperClass((Class)sourceType) != null;
            boolean hasTargetWrapper = TableProxies.tableWrapperClass((Class)targetType) != null;
            try {
                constructor = weakJoinType.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("No default constructor can be found in \"" + weakJoinType.getName() + "\"");
            }
            constructor.setAccessible(true);
            try {
                weakJoin = (WeakJoin)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IllegalArgumentException("Cannot create instance of \"" + weakJoinType.getName() + "\"", ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException("Cannot create instance of \"" + weakJoinType.getName() + "\"", ex.getTargetException());
            }
            return new EntityTableHandleImpl(ImmutableType.get((Class)((Class)sourceType)), ImmutableType.get((Class)((Class)targetType)), hasSourceWrapper, hasTargetWrapper, weakJoin);
        }
    }
}

