/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.time.temporal.Temporal;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.DateExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.TemporalExpression;
import org.babyfish.jimmer.sql.ast.embedded.AbstractTypedEmbeddedPropExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableDeleteImpl;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.query.ConfigurableBaseQuery;
import org.babyfish.jimmer.sql.ast.query.MutableBaseQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class MutableBaseQueryImpl
extends AbstractMutableQueryImpl
implements MutableBaseQuery {
    private AbstractMutableStatementImpl parent;
    private StatementContext ctx;

    public MutableBaseQueryImpl(JSqlClientImplementor sqlClient, TableProxy<?> table) {
        super(sqlClient, table);
    }

    public MutableBaseQueryImpl(JSqlClientImplementor sqlClient, ImmutableType immutableType) {
        super(sqlClient, immutableType);
    }

    @Override
    public AbstractMutableStatementImpl getParent() {
        return this.parent;
    }

    @Override
    public StatementContext getContext() {
        return this.ctx;
    }

    @Override
    public MutableBaseQueryImpl where(Predicate ... predicates) {
        return (MutableBaseQueryImpl)super.where(predicates);
    }

    @Override
    @Deprecated
    public MutableBaseQueryImpl whereIf(boolean condition, Predicate predicate) {
        if (condition) {
            this.where(predicate);
        }
        return this;
    }

    @Override
    public MutableBaseQueryImpl whereIf(boolean condition, Supplier<Predicate> block) {
        if (condition) {
            this.where(block.get());
        }
        return this;
    }

    @Override
    public MutableBaseQueryImpl groupBy(Expression<?> ... expressions) {
        return (MutableBaseQueryImpl)super.groupBy((Expression[])expressions);
    }

    @Override
    public MutableBaseQueryImpl having(Predicate ... predicates) {
        return (MutableBaseQueryImpl)super.having(predicates);
    }

    @Override
    public MutableBaseQueryImpl orderBy(Expression<?> ... expressions) {
        return (MutableBaseQueryImpl)super.orderBy((Expression[])expressions);
    }

    @Override
    public MutableBaseQueryImpl orderByIf(boolean condition, Expression<?> ... expressions) {
        return (MutableBaseQueryImpl)super.orderByIf(condition, (Expression[])expressions);
    }

    @Override
    public MutableBaseQueryImpl orderBy(Order ... orders) {
        return (MutableBaseQueryImpl)super.orderBy(orders);
    }

    @Override
    public MutableBaseQueryImpl orderByIf(boolean condition, Order ... orders) {
        return (MutableBaseQueryImpl)super.orderByIf(condition, orders);
    }

    @Override
    public MutableBaseQueryImpl orderBy(List<Order> orders) {
        return (MutableBaseQueryImpl)super.orderBy((List)orders);
    }

    @Override
    public MutableBaseQueryImpl orderByIf(boolean condition, List<Order> orders) {
        return (MutableBaseQueryImpl)super.orderByIf(condition, (List)orders);
    }

    public void setParent(AbstractMutableStatementImpl parent) {
        if (this.parent == null) {
            this.parent = parent;
            this.ctx = parent.getContext();
        } else if (parent instanceof MutableBaseQueryImpl) {
            if (this.ctx != parent.getContext()) {
                throw new IllegalStateException("The recursive base query cannot be added to statement context");
            }
        } else if (!MutableDeleteImpl.isCompatible(this.parent, parent)) {
            throw new IllegalStateException("The base query cannot be added to parent query because it is belong to another parent query");
        }
    }

    @Override
    public void resolveVirtualPredicate(AstContext ctx) {
        this.setParent(ctx.getStatement());
        super.resolveVirtualPredicate(ctx);
    }

    @Override
    public <T extends Table<?>> ConfigurableBaseQuery.Query1<T> addSelect(T table) {
        return new ConfigurableBaseQueryImpl.Query1Impl(table, this);
    }

    @Override
    public <T extends AbstractTypedEmbeddedPropExpression<?>> ConfigurableBaseQuery.Query1<T> addSelect(T expr) {
        return new ConfigurableBaseQueryImpl.Query1Impl(expr, this);
    }

    @Override
    public <V> ConfigurableBaseQuery.Query1<Expression<V>> addSelect(Expression<V> expr) {
        return new ConfigurableBaseQueryImpl.Query1Impl<Expression<V>>(expr, this);
    }

    @Override
    public ConfigurableBaseQuery.Query1<StringExpression> addSelect(StringExpression expr) {
        return new ConfigurableBaseQueryImpl.Query1Impl<StringExpression>(expr, this);
    }

    @Override
    public <V extends Number> ConfigurableBaseQuery.Query1<NumericExpression<V>> addSelect(NumericExpression<V> expr) {
        return new ConfigurableBaseQueryImpl.Query1Impl<NumericExpression<V>>(expr, this);
    }

    @Override
    public <V extends Comparable<?>> ConfigurableBaseQuery.Query1<ComparableExpression<V>> addSelect(ComparableExpression<V> expr) {
        return new ConfigurableBaseQueryImpl.Query1Impl<ComparableExpression<V>>(expr, this);
    }

    @Override
    public <V extends Date> ConfigurableBaseQuery.Query1<DateExpression<V>> addSelect(DateExpression<V> expr) {
        return new ConfigurableBaseQueryImpl.Query1Impl<DateExpression<V>>(expr, this);
    }

    @Override
    public <V extends Temporal & Comparable<?>> ConfigurableBaseQuery.Query1<TemporalExpression<V>> addSelect(TemporalExpression<V> expr) {
        return new ConfigurableBaseQueryImpl.Query1Impl<TemporalExpression<V>>(expr, this);
    }

    public String toString() {
        return "MutableBaseQueryImpl{queryType = " + this.getTable() + "}";
    }
}

