/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.Slice;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractConfigurableTypedQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.ForUpdate;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.PageSource;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.query.TypedRootQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.LockMode;
import org.babyfish.jimmer.sql.ast.query.LockWait;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.PageFactory;
import org.babyfish.jimmer.sql.ast.query.TypedRootQuery;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableRootQueryImpl<T extends TableLike<?>, R>
extends AbstractConfigurableTypedQueryImpl
implements ConfigurableRootQuery<T, R>,
TypedRootQueryImplementor<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableRootQueryImpl.class);

    ConfigurableRootQueryImpl(TypedQueryData data, MutableRootQueryImpl<T> baseQuery) {
        super(data, baseQuery);
    }

    @Override
    public MutableRootQueryImpl<T> getMutableQuery() {
        return (MutableRootQueryImpl)super.getMutableQuery();
    }

    @Override
    @NotNull
    public <P> P fetchPage(int pageIndex, int pageSize, Connection con, PageFactory<R, P> pageFactory) {
        List rows;
        if (pageSize == 0 || pageSize == -1 || pageSize == Integer.MAX_VALUE) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("For meaningless pageSize {}, avoid pagination and fetch all rows directly", (Object)pageSize);
            }
            Object rows2 = this.execute(con);
            return pageFactory.create((List<R>)rows2, rows2.size(), PageSource.of(0, Integer.MAX_VALUE, this.getMutableQuery()));
        }
        if (pageIndex < 0) {
            LOGGER.info("pageIndex is negative, returns empty list directly");
            return pageFactory.create(Collections.emptyList(), 0L, PageSource.of(0, pageSize, this.getMutableQuery()));
        }
        long offset = (long)pageIndex * (long)pageSize;
        if (offset > Long.MAX_VALUE - (long)pageSize) {
            throw new IllegalArgumentException("offset is too big");
        }
        long total = this.fetchUnlimitedCount(con);
        if (offset >= total) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("pageIndex(starts from 0) is {} but the total page count is {}, returns empty list directly", (Object)pageIndex, (Object)((total + (long)pageSize - 1L) / (long)pageSize));
            }
            return pageFactory.create(Collections.emptyList(), total, PageSource.of(pageIndex, pageSize, this.getMutableQuery()));
        }
        ConfigurableRootQuery<T, R> reversedQuery = null;
        boolean reverseSortOptimization = this.getData().reverseSortOptimizationEnabled != null ? this.getData().reverseSortOptimizationEnabled.booleanValue() : this.getSqlClient().isReverseSortOptimizationEnabled();
        if (reverseSortOptimization && offset + (long)(pageSize / 2) > total / 2L) {
            LOGGER.info("Enable reverse sorting optimization, all sorting behaviors will be reversed");
            reversedQuery = this.reverseSorting();
        }
        if (reversedQuery != null) {
            int limit;
            long reversedOffset = (int)(total - offset - (long)pageSize);
            if (reversedOffset < 0L) {
                limit = pageSize + (int)reversedOffset;
                reversedOffset = 0L;
            } else {
                limit = pageSize;
            }
            rows = (List)reversedQuery.limit(limit, reversedOffset).execute(con);
            Collections.reverse(rows);
        } else {
            rows = (List)this.limit(pageSize, offset).execute(con);
        }
        return pageFactory.create(rows, total, PageSource.of(pageIndex, pageSize, this.getMutableQuery()));
    }

    @Override
    public Slice<R> fetchSlice(int limit, int offset, @Nullable Connection con) {
        if (limit < 1) {
            throw new IllegalArgumentException("limit cannot be less than 1");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be less than 0");
        }
        List rows = (List)this.limit(limit + 1).offset(offset).execute(con);
        if (rows.size() <= limit) {
            return new Slice(rows, offset == 0, true);
        }
        return new Slice(rows.subList(0, rows.size() - 1), offset == 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X> ConfigurableRootQuery<T, X> reselect(BiFunction<MutableRootQuery<T>, T, ConfigurableRootQuery<T, X>> block) {
        if (this.getData().oldSelections != null) {
            throw new IllegalStateException("The current query has been reselected, it cannot be reselect again");
        }
        AbstractMutableQueryImpl baseQuery = this.getMutableQuery();
        if (baseQuery.isGroupByClauseUsed()) {
            throw new IllegalStateException("The current query uses group by clause, it cannot be reselected");
        }
        AstContext astContext = new AstContext(baseQuery.getSqlClient());
        ReselectValidator visitor = new ReselectValidator(astContext);
        astContext.pushStatement(baseQuery);
        try {
            for (Selection<?> selection : this.getData().selections) {
                Ast.from(selection, visitor.getAstContext()).accept(visitor);
            }
        }
        finally {
            astContext.popStatement();
        }
        ConfigurableRootQuery<T, X> reselected = block.apply((MutableRootQuery<AbstractMutableQueryImpl>)((Object)baseQuery), (AbstractMutableQueryImpl)baseQuery.getTable());
        List<Selection<?>> selections = ((ConfigurableRootQueryImpl)reselected).getData().selections;
        return new ConfigurableRootQueryImpl<T, R>(this.getData().reselect(selections, null), baseQuery);
    }

    @Override
    public ConfigurableRootQuery<T, R> distinct() {
        TypedQueryData data = this.getData();
        if (data.distinct) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.distinct(), this.getMutableQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> limit(int limit) {
        return this.limitImpl(limit, null);
    }

    @Override
    public ConfigurableRootQuery<T, R> offset(long offset) {
        return this.limitImpl(null, offset);
    }

    @Override
    public ConfigurableRootQuery<T, R> limit(int limit, long offset) {
        return this.limitImpl(limit, offset);
    }

    private ConfigurableRootQuery<T, R> limitImpl(@Nullable Integer limit, @Nullable Long offset) {
        TypedQueryData data = this.getData();
        if (limit == null) {
            limit = data.limit;
        }
        if (offset == null) {
            offset = data.offset;
        }
        if (data.limit == limit && data.offset == offset) {
            return this;
        }
        if (limit < 0) {
            throw new IllegalArgumentException("'limit' can not be less than 0");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("'offsetValue' can not be less than 0");
        }
        return new ConfigurableRootQueryImpl<T, R>(data.limit(limit, offset), this.getMutableQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> withoutSortingAndPaging() {
        TypedQueryData data = this.getData();
        if (data.withoutSortingAndPaging) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.withoutSortingAndPaging(), this.getMutableQuery());
    }

    @Override
    @Nullable
    public ConfigurableRootQuery<T, R> reverseSorting() {
        TypedQueryData data = this.getData();
        if (data.reverseSorting) {
            return this;
        }
        if (this.getMutableQuery().getOrders().isEmpty()) {
            return null;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.reverseSorting(), this.getMutableQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> setReverseSortOptimizationEnabled(boolean enabled) {
        TypedQueryData data = this.getData();
        if (Objects.equals(data.reverseSortOptimizationEnabled, enabled)) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.reverseSortOptimizationEnabled(enabled), this.getMutableQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> forUpdate(boolean forUpdate) {
        if (forUpdate) {
            return this.forUpdate(LockMode.UPDATE, LockWait.DEFAULT);
        }
        TypedQueryData data = this.getData();
        if (data.forUpdate == null) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.forUpdate(null), this.getMutableQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> forUpdate(LockMode lockMode, LockWait lockWait) {
        TypedQueryData data = this.getData();
        ForUpdate forUpdate = new ForUpdate(lockMode, lockWait);
        if (Objects.equals(data.forUpdate, forUpdate)) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.forUpdate(forUpdate), this.getMutableQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> hint(String hint) {
        TypedQueryData data = this.getData();
        return new ConfigurableRootQueryImpl<T, R>(data.hint(hint), this.getMutableQuery());
    }

    @Override
    public List<R> execute(Connection con) {
        return this.getMutableQuery().getSqlClient().getSlaveConnectionManager(this.getData().forUpdate != null).execute(con, this::executeImpl);
    }

    private List<R> executeImpl(Connection con) {
        TypedQueryData data = this.getData();
        if (data.limit == 0) {
            return Collections.emptyList();
        }
        JSqlClientImplementor sqlClient = this.getMutableQuery().getSqlClient();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(sqlClient)));
        return Selectors.select(sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), data.selections, data.tupleCreator, this.getMutableQuery().getPurpose());
    }

    @Override
    public <X> List<X> map(Connection con, Function<R, X> mapper) {
        Object rows = this.execute(con);
        ArrayList<X> mapped = new ArrayList<X>(rows.size());
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            Object row = iterator.next();
            mapped.add(mapper.apply(row));
        }
        return mapped;
    }

    @Override
    public void forEach(Connection con, int batchSize, Consumer<R> consumer) {
        TypedQueryData data = this.getData();
        if (data.limit == 0) {
            return;
        }
        JSqlClientImplementor sqlClient = this.getMutableQuery().getSqlClient();
        int finalBatchSize = batchSize > 0 ? batchSize : sqlClient.getDefaultBatchSize();
        sqlClient.getSlaveConnectionManager(this.getData().forUpdate != null).execute(con, newConn -> {
            this.forEachImpl((Connection)newConn, finalBatchSize, consumer);
            return null;
        });
    }

    private void forEachImpl(Connection con, int batchSize, Consumer<R> consumer) {
        JSqlClientImplementor sqlClient = this.getMutableQuery().getSqlClient();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(sqlClient)));
        Selectors.forEach(sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.getData().selections, this.getData().tupleCreator, this.getMutableQuery().getPurpose(), batchSize, consumer);
    }

    private Tuple3<String, List<Object>, List<Integer>> preExecute(SqlBuilder builder) {
        if (!this.getMutableQuery().isFrozen()) {
            this.getMutableQuery().applyVirtualPredicates(builder.getAstContext());
            this.getMutableQuery().applyGlobalFilters(builder.getAstContext(), ((MutableRootQueryImpl)this.getMutableQuery()).getContext().getFilterLevel(), this.getData().selections);
        }
        UseTableVisitor visitor = new UseTableVisitor(builder.getAstContext());
        this.accept(visitor);
        visitor.allocateAliases();
        this.renderTo((AbstractSqlBuilder)builder);
        return builder.build();
    }

    @Override
    public ForUpdate getForUpdate() {
        return this.getData().forUpdate;
    }

    @Override
    public TypedRootQuery<R> withLimit(int limit) {
        if (this.getData().limit == Integer.MAX_VALUE) {
            return this.limit(limit);
        }
        return this;
    }

    private static class ReselectValidator
    extends AstVisitor {
        ReselectValidator(AstContext astContext) {
            super(astContext);
        }

        @Override
        public boolean visitSubQuery(TypedSubQuery<?> subQuery) {
            return false;
        }

        @Override
        public void visitAggregation(String functionName, Expression<?> expression, String prefix) {
            throw new IllegalStateException("The current query uses aggregation function in select clause, it cannot be reselected");
        }
    }
}

