/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractPreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.ShapedEntityMap;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;

class UpsertPreHandler
extends AbstractPreHandler {
    private final boolean ignoreUpdate;
    private ShapedEntityMap<DraftSpi> insertedMap;
    private ShapedEntityMap<DraftSpi> updatedMap;
    private ShapedEntityMap<DraftSpi> mergedMap;

    UpsertPreHandler(SaveContext ctx, boolean ignoreUpdate) {
        super(ctx);
        this.ignoreUpdate = ignoreUpdate;
    }

    @Override
    public ShapedEntityMap<DraftSpi> insertedMap() {
        this.resolve();
        return this.insertedMap;
    }

    @Override
    public ShapedEntityMap<DraftSpi> updatedMap() {
        this.resolve();
        return this.updatedMap;
    }

    @Override
    public ShapedEntityMap<DraftSpi> mergedMap() {
        this.resolve();
        return this.mergedMap;
    }

    @Override
    void onResolve() {
        DraftSpi draft;
        Iterator itr;
        QueryReason queryReason;
        PropId idPropId = this.ctx.path.getType().getIdProp().getId();
        ArrayList<Object> insertedList = null;
        ArrayList<DraftSpi> updatedList = null;
        ArrayList<DraftSpi> updatedWithoutKeyList = null;
        ArrayList<DraftInterceptor.Item<Object, DraftSpi>> items = new ArrayList<DraftInterceptor.Item<Object, DraftSpi>>((this.draftsWithNothing != null ? this.draftsWithNothing.size() : 0) + this.draftsWithId.size() + this.draftsWithKey.size());
        if (this.draftsWithNothing != null && !this.draftsWithNothing.isEmpty()) {
            for (DraftSpi draft2 : this.draftsWithNothing) {
                items.add(this.newItem(draft2, null));
            }
        }
        if (!this.draftsWithId.isEmpty()) {
            queryReason = this.queryReason(true, this.draftsWithId);
            if (queryReason != QueryReason.NONE) {
                insertedList = new ArrayList<DraftSpi>();
                updatedList = new ArrayList();
                Map<Object, ImmutableSpi> idMap = this.findOldMapByIds(queryReason);
                itr = this.draftsWithId.iterator();
                while (itr.hasNext()) {
                    draft = (DraftSpi)itr.next();
                    ImmutableSpi original = idMap.get(draft.__get(idPropId));
                    if (original == null) {
                        insertedList.add(draft);
                        itr.remove();
                        items.add(this.newItem(draft, null));
                        continue;
                    }
                    if (this.ignoreUpdate) continue;
                    updatedList.add(draft);
                    items.add(this.newItem(draft, original));
                }
            } else {
                updatedList = new ArrayList<DraftSpi>(this.draftsWithId);
            }
        }
        if (!this.draftsWithKey.isEmpty() && (queryReason = this.queryReason(false, this.draftsWithKey)) != QueryReason.NONE) {
            if (insertedList == null) {
                insertedList = new ArrayList();
            }
            updatedWithoutKeyList = new ArrayList<DraftSpi>();
            Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> keyMap = this.findOldMapByKeys(queryReason);
            itr = this.draftsWithKey.iterator();
            while (itr.hasNext()) {
                draft = (DraftSpi)itr.next();
                KeyMatcher.Group group = this.ctx.options.getKeyMatcher(this.ctx.path.getType()).match((Object)draft);
                assert (group != null);
                Object key = Keys.keyOf((ImmutableSpi)draft, group.getProps());
                Map subMap = keyMap.getOrDefault(group, Collections.emptyMap());
                ImmutableSpi original = (ImmutableSpi)subMap.get(key);
                if (original == null) {
                    insertedList.add(draft);
                    itr.remove();
                    items.add(this.newItem(draft, null));
                    continue;
                }
                if (!this.ignoreUpdate) {
                    updatedWithoutKeyList.add(draft);
                    items.add(this.newItem(draft, original));
                }
                if (this.ignoreUpdate && !this.ctx.isIdRetrievingRequired()) continue;
                draft.__set(idPropId, original.__get(idPropId));
            }
        }
        this.callInterceptor(items);
        this.insertedMap = this.createEntityMap(null, insertedList, this.draftsWithNothing, SaveMode.INSERT_ONLY, SaveMode.UPSERT);
        if (insertedList == null) {
            this.updatedMap = ShapedEntityMap.empty();
            this.mergedMap = this.createEntityMap(null, this.draftsWithId, this.draftsWithKey, this.ignoreUpdate ? SaveMode.INSERT_IF_ABSENT : SaveMode.UPSERT, SaveMode.UPSERT);
        } else if (this.ignoreUpdate) {
            this.updatedMap = ShapedEntityMap.empty();
            this.mergedMap = ShapedEntityMap.empty();
        } else {
            this.updatedMap = this.createEntityMap(null, updatedList, null, SaveMode.UPDATE_ONLY, SaveMode.UPSERT);
            if (updatedWithoutKeyList != null && !updatedWithoutKeyList.isEmpty()) {
                ShapedEntityMap<DraftSpi> updatedMap = this.updatedMap;
                for (DraftSpi draft3 : updatedWithoutKeyList) {
                    updatedMap.add(draft3, true);
                }
            }
            this.mergedMap = this.updatedMap != null ? ShapedEntityMap.empty() : this.createEntityMap(null, this.draftsWithId, this.draftsWithKey, SaveMode.UPSERT, SaveMode.UPSERT);
        }
    }
}

