/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.impl.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdPairs;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.NoTargetEntityIdPairsImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Operator;
import org.babyfish.jimmer.sql.ast.impl.mutation.PreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.Rows;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.UpsertMask;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImplementor;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.jetbrains.annotations.Nullable;

public class Saver {
    private final SaveContext ctx;

    public Saver(SaveOptions options, Connection con, ImmutableType type, Fetcher<?> fetcher) {
        this(new SaveContext(options, con, type, fetcher));
    }

    private Saver(SaveContext ctx) {
        this.ctx = ctx;
    }

    public <E> SimpleSaveResult<E> save(E entity) {
        ImmutableType immutableType = ImmutableType.get(entity.getClass());
        MutationTrigger trigger = this.ctx.trigger;
        Object newEntity = Internal.produceList((ImmutableType)immutableType, Collections.singleton(entity), drafts -> this.saveAllImpl((List<DraftSpi>)drafts), trigger == null ? null : trigger::prepareSubmit).get(0);
        if (trigger != null) {
            trigger.submit(this.ctx.options.getSqlClient(), this.ctx.con);
        }
        return new SimpleSaveResult<E>(this.ctx.affectedRowCountMap, entity, newEntity);
    }

    public <E> BatchSaveResult<E> saveAll(Collection<E> entities) {
        if (entities.isEmpty()) {
            return new BatchSaveResult(Collections.emptyMap(), Collections.emptyList());
        }
        ImmutableType immutableType = ImmutableType.get(entities.iterator().next().getClass());
        MutationTrigger trigger = this.ctx.trigger;
        List newEntities = Internal.produceList((ImmutableType)immutableType, entities, drafts -> this.saveAllImpl((List<DraftSpi>)drafts), trigger == null ? null : trigger::prepareSubmit);
        if (trigger != null) {
            trigger.submit(this.ctx.options.getSqlClient(), this.ctx.con);
        }
        Iterator<E> oldItr = entities.iterator();
        Iterator newItr = newEntities.iterator();
        ArrayList<BatchSaveResult.Item<BatchSaveResult.Item<E>>> items = new ArrayList<BatchSaveResult.Item<BatchSaveResult.Item<E>>>(entities.size());
        while (oldItr.hasNext() && newItr.hasNext()) {
            items.add(new BatchSaveResult.Item<E>(oldItr.next(), newItr.next()));
        }
        return new BatchSaveResult(this.ctx.affectedRowCountMap, items);
    }

    private void saveAllImpl(List<DraftSpi> drafts) {
        for (Object prop : this.ctx.path.getType().getProps().values()) {
            if (!this.isVisitable((ImmutableProp)prop) || !prop.isReference(TargetLevel.ENTITY) || !prop.isColumnDefinition()) continue;
            this.savePreAssociation((ImmutableProp)prop, drafts);
        }
        PreHandler preHandler = PreHandler.of(this.ctx);
        for (DraftSpi draft : drafts) {
            preHandler.add(draft);
        }
        boolean detach = this.saveSelf(preHandler);
        for (Batch<DraftSpi> batch : preHandler.associationBatches()) {
            for (ImmutableProp prop : batch.shape().getGetterMap().keySet()) {
                if (!this.isVisitable(prop) || !prop.isAssociation(TargetLevel.ENTITY)) continue;
                if (this.ctx.options.getAssociatedMode(prop) == AssociatedSaveMode.VIOLENTLY_REPLACE) {
                    this.clearAssociations(batch.entities(), prop);
                }
                this.setBackReference(prop, batch);
                this.savePostAssociation(prop, batch, detach);
            }
        }
        this.fetch(drafts, preHandler.batches());
    }

    private void setBackReference(ImmutableProp prop, Batch<DraftSpi> batch) {
        ImmutableProp backProp = prop.getMappedBy();
        if (backProp != null && backProp.isColumnDefinition()) {
            ImmutableType parentType = prop.getDeclaringType();
            PropId idPropId = batch.shape().getType().getIdProp().getId();
            PropId propId = prop.getId();
            PropId backPropId = backProp.getId();
            for (DraftSpi draft : batch.entities()) {
                if (!draft.__isLoaded(idPropId)) continue;
                Object idOnlyParent = ImmutableObjects.makeIdOnly((ImmutableType)parentType, (Object)draft.__get(idPropId));
                Object associated = draft.__get(propId);
                if (associated instanceof Collection) {
                    for (DraftSpi child : (List)associated) {
                        child.__set(backPropId, idOnlyParent);
                    }
                    continue;
                }
                if (!(associated instanceof DraftSpi)) continue;
                ((DraftSpi)associated).__set(backPropId, idOnlyParent);
            }
        }
    }

    private void savePreAssociation(ImmutableProp prop, List<DraftSpi> drafts) {
        Saver targetSaver = new Saver(this.ctx.prop(prop));
        ArrayList<DraftSpi> targets = new ArrayList<DraftSpi>(drafts.size());
        PropId targetPropId = prop.getId();
        for (DraftSpi draft : drafts) {
            if (!draft.__isLoaded(targetPropId)) continue;
            DraftSpi target = (DraftSpi)draft.__get(targetPropId);
            if (target != null) {
                targets.add(target);
                continue;
            }
            if (prop.isNullable() && !prop.isInputNotNull()) continue;
            targetSaver.ctx.throwNullTarget();
        }
        if (!targets.isEmpty()) {
            targetSaver.saveAllImpl(targets);
        }
    }

    private void savePostAssociation(ImmutableProp prop, Batch<DraftSpi> batch, boolean detachOtherSiblings) {
        Saver targetSaver = new Saver(this.ctx.prop(prop));
        if (this.isReadOnlyMiddleTable(prop)) {
            targetSaver.ctx.throwReadonlyMiddleTable();
        }
        if (prop.isRemote() && prop.getMappedBy() != null) {
            targetSaver.ctx.throwReversedRemoteAssociation();
        }
        if (prop.getSqlTemplate() instanceof JoinTemplate) {
            targetSaver.ctx.throwUnstructuredAssociation();
        }
        ArrayList<DraftSpi> targets = new ArrayList<DraftSpi>(batch.entities().size());
        PropId targetPropId = prop.getId();
        for (DraftSpi draft : batch.entities()) {
            Object value = draft.__get(targetPropId);
            if (value instanceof List) {
                targets.addAll((List)value);
                continue;
            }
            if (value != null) {
                targets.add((DraftSpi)value);
                continue;
            }
            if (prop.isNullable() && !prop.isInputNotNull()) continue;
            targetSaver.ctx.throwNullTarget();
        }
        if (!targets.isEmpty()) {
            targetSaver.saveAllImpl(targets);
        }
        this.updateAssociations(batch, prop, detachOtherSiblings);
    }

    private void fetch(List<DraftSpi> drafts, Iterable<Batch<DraftSpi>> batches) {
        if (this.ctx.path.getParent() != null) {
            this.fetchIdIfNecessary(drafts, batches);
            return;
        }
        Fetcher<?> fetcher = this.ctx.fetcher;
        if (fetcher == null) {
            this.fetchIdIfNecessary(drafts, batches);
            return;
        }
        this.fetchImpl(drafts, batches, false);
    }

    private void fetchIdIfNecessary(List<DraftSpi> drafts, Iterable<Batch<DraftSpi>> batches) {
        if (this.ctx.options.getMode() != SaveMode.INSERT_IF_ABSENT) {
            return;
        }
        if (!this.ctx.isIdRetrievingRequired()) {
            return;
        }
        this.fetchImpl(drafts, batches, true);
    }

    private void fetchImpl(List<DraftSpi> drafts, Iterable<Batch<DraftSpi>> batches, boolean fillIdIfNecessary) {
        block19: {
            Fetcher<Object> fetcher;
            PropId idPropId;
            ArrayList<DraftSpi> nonIdObjects;
            block20: {
                ImmutableSpi row;
                DraftSpi draft;
                ListIterator<DraftSpi> itr;
                block21: {
                    DraftSpi[] arr = new DraftSpi[drafts.size()];
                    int index = 0;
                    ArrayList<Object> unmatchedIds = new ArrayList<Object>();
                    nonIdObjects = new ArrayList<DraftSpi>();
                    idPropId = this.ctx.path.getType().getIdProp().getId();
                    ShapeMatchContext shapeMatchContext = new ShapeMatchContext();
                    fetcher = this.ctx.fetcher;
                    for (DraftSpi draft2 : drafts) {
                        if (!draft2.__isLoaded(idPropId)) {
                            nonIdObjects.add(draft2);
                        } else if (fetcher != null && !Saver.isShapeMatched(draft2, fetcher, shapeMatchContext)) {
                            arr[index] = draft2;
                            unmatchedIds.add(draft2.__get(idPropId));
                        }
                        ++index;
                    }
                    if (!unmatchedIds.isEmpty()) {
                        JSqlClient sqlClient = this.ctx.options.getSqlClient().caches(CacheDisableConfig::disableAll);
                        Map map = ((EntitiesImpl)sqlClient.getEntities()).forSaveCommandFetch(fillIdIfNecessary ? QueryReason.GET_ID_FOR_PRE_SAVED_ENTITIES : QueryReason.FETCHER).forConnection(this.ctx.con).findMapByIds(fillIdIfNecessary ? new FetcherImpl(this.ctx.path.getType().getJavaClass()) : fetcher, unmatchedIds);
                        index = 0;
                        itr = drafts.listIterator();
                        while (itr.hasNext()) {
                            Object fetched;
                            DraftSpi replacedDraft;
                            draft = itr.next();
                            if (arr[index] != null && (replacedDraft = Saver.replaceDraft(draft, fetched = map.get(draft.__get(idPropId)))) != null) {
                                itr.set(replacedDraft);
                            }
                            ++index;
                        }
                    }
                    if (nonIdObjects.isEmpty()) break block19;
                    if (drafts.size() != 1) break block20;
                    Map<KeyMatcher.Group, List<ImmutableSpi>> rowMap = Rows.findByKeys(this.ctx, fillIdIfNecessary ? QueryReason.GET_ID_FOR_PRE_SAVED_ENTITIES : QueryReason.FETCHER, (Fetcher<ImmutableSpi>)(fillIdIfNecessary ? new FetcherImpl<ImmutableSpi>(this.ctx.path.getType().getJavaClass()) : fetcher), nonIdObjects, null);
                    if (rowMap.isEmpty()) break block19;
                    row = rowMap.values().iterator().next().iterator().next();
                    if (!fillIdIfNecessary) break block21;
                    drafts.get(0).__set(idPropId, row.__get(idPropId));
                    break block19;
                }
                itr = drafts.listIterator();
                draft = itr.next();
                DraftSpi replaceDraft = Saver.replaceDraft(draft, row);
                if (replaceDraft == null) break block19;
                itr.set(replaceDraft);
                break block19;
            }
            KeyMatcher keyMatcher = this.ctx.options.getKeyMatcher(this.ctx.path.getType());
            for (Batch<DraftSpi> batch : batches) {
                Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> map;
                Fetcher<Object> actualFetcher;
                Set<ImmutableProp> keyProps = batch.shape().keyProps(keyMatcher);
                ArrayList<PropId> unloadPropIds = null;
                if (!fillIdIfNecessary) {
                    assert (fetcher != null);
                    unloadPropIds = new ArrayList<PropId>();
                    for (ImmutableProp keyProp : keyProps) {
                        if (((FetcherImplementor)fetcher).__contains(keyProp.getName())) continue;
                        fetcher = fetcher.add(keyProp.getName());
                        unloadPropIds.add(keyProp.getId());
                    }
                }
                if (fillIdIfNecessary) {
                    ImmutableProp keyProp;
                    actualFetcher = new FetcherImpl(this.ctx.path.getType().getJavaClass());
                    keyProp = keyProps.iterator();
                    while (keyProp.hasNext()) {
                        ImmutableProp keyProp2 = (ImmutableProp)keyProp.next();
                        actualFetcher = actualFetcher.add(keyProp2.getName());
                    }
                } else {
                    actualFetcher = fetcher;
                }
                if ((map = Rows.findMapByKeys(this.ctx, fillIdIfNecessary ? QueryReason.GET_ID_FOR_PRE_SAVED_ENTITIES : QueryReason.FETCHER, actualFetcher, nonIdObjects)).isEmpty()) continue;
                ListIterator<DraftSpi> itr = drafts.listIterator();
                while (itr.hasNext()) {
                    DraftSpi draft = itr.next();
                    if (draft.__isLoaded(idPropId)) continue;
                    Map<Object, ImmutableSpi> subMap = map.values().iterator().next();
                    Object key = Keys.keyOf((ImmutableSpi)draft, keyProps);
                    ImmutableSpi fetched = subMap.get(key);
                    if (unloadPropIds == null) {
                        draft.__set(idPropId, fetched.__get(idPropId));
                        continue;
                    }
                    DraftSpi newDraft = Saver.replaceDraft(draft, fetched);
                    if (newDraft != null) {
                        itr.set(newDraft);
                    } else {
                        newDraft = draft;
                    }
                    for (PropId unloadedPropId : unloadPropIds) {
                        newDraft.__unload(unloadedPropId);
                    }
                }
            }
        }
    }

    private static DraftSpi replaceDraft(DraftSpi draft, Object fetched) {
        if (fetched instanceof DraftSpi) {
            return (DraftSpi)fetched;
        }
        if (fetched instanceof ImmutableSpi) {
            ImmutableSpi spi = (ImmutableSpi)fetched;
            for (ImmutableProp prop : draft.__type().getProps().values()) {
                PropId propId = prop.getId();
                if (spi.__isLoaded(propId)) {
                    if (!prop.isView()) {
                        draft.__set(propId, spi.__get(propId));
                    }
                    draft.__show(propId, spi.__isVisible(propId));
                    continue;
                }
                draft.__unload(propId);
            }
        }
        return null;
    }

    private boolean isVisitable(ImmutableProp prop) {
        ImmutableProp backRef = this.ctx.backReferenceProp;
        return backRef == null || backRef != prop;
    }

    private boolean saveSelf(PreHandler preHandler) {
        Operator operator = new Operator(this.ctx);
        boolean detach = false;
        block5: for (Batch<DraftSpi> batch : preHandler.batches()) {
            switch (batch.mode()) {
                case INSERT_ONLY: {
                    operator.insert(batch);
                    continue block5;
                }
                case INSERT_IF_ABSENT: {
                    operator.upsert(batch, true);
                    continue block5;
                }
                case UPDATE_ONLY: {
                    detach = true;
                    operator.update(preHandler.originalIdObjMap(), preHandler.originalkeyObjMap(), batch);
                    continue block5;
                }
            }
            detach = true;
            operator.upsert(batch, false);
        }
        return detach;
    }

    private void clearAssociations(Collection<? extends ImmutableSpi> rows, ImmutableProp prop) {
        ChildTableOperator subOperator = null;
        MiddleTableOperator middleTableOperator = null;
        if (prop.isMiddleTableDefinition()) {
            middleTableOperator = new MiddleTableOperator(this.ctx.prop(prop), this.ctx.options.getDeleteMode() == DeleteMode.LOGICAL);
        } else {
            ImmutableProp mappedBy = prop.getMappedBy();
            if (mappedBy != null) {
                if (mappedBy.isColumnDefinition()) {
                    subOperator = new ChildTableOperator(new DeleteContext(DeleteOptions.detach(this.ctx.options), this.ctx.con, this.ctx.trigger, this.ctx.affectedRowCountMap, this.ctx.path.to(prop)));
                } else if (mappedBy.isMiddleTableDefinition()) {
                    middleTableOperator = new MiddleTableOperator(this.ctx.prop(prop), this.ctx.options.getDeleteMode() == DeleteMode.LOGICAL);
                }
            }
        }
        if (subOperator == null && middleTableOperator == null) {
            return;
        }
        NoTargetEntityIdPairsImpl noTargetIdPairs = new NoTargetEntityIdPairsImpl(rows);
        if (subOperator != null) {
            subOperator.disconnectExcept(noTargetIdPairs, true);
        }
        if (middleTableOperator != null) {
            middleTableOperator.disconnectExcept(noTargetIdPairs);
        }
    }

    private void updateAssociations(Batch<DraftSpi> batch, ImmutableProp prop, boolean detach) {
        ChildTableOperator subOperator = null;
        MiddleTableOperator middleTableOperator = null;
        if (prop.isMiddleTableDefinition()) {
            middleTableOperator = new MiddleTableOperator(this.ctx.prop(prop), this.ctx.options.getDeleteMode() == DeleteMode.LOGICAL);
        } else {
            ImmutableProp mappedBy = prop.getMappedBy();
            if (mappedBy != null) {
                if (mappedBy.isColumnDefinition()) {
                    subOperator = new ChildTableOperator(new DeleteContext(DeleteOptions.detach(this.ctx.options), this.ctx.con, this.ctx.trigger, this.ctx.affectedRowCountMap, this.ctx.path.to(prop)));
                } else if (mappedBy.isMiddleTableDefinition()) {
                    middleTableOperator = new MiddleTableOperator(this.ctx.prop(prop), this.ctx.options.getDeleteMode() == DeleteMode.LOGICAL);
                }
            }
        }
        if (subOperator == null && middleTableOperator == null) {
            return;
        }
        IdPairs.Retain retainedIdPairs = IdPairs.retain(batch.entities(), prop);
        if (subOperator != null && detach && this.ctx.options.getAssociatedMode(prop) == AssociatedSaveMode.REPLACE) {
            subOperator.disconnectExcept(retainedIdPairs, true);
        }
        if (middleTableOperator != null) {
            if (detach) {
                switch (this.ctx.options.getAssociatedMode(prop)) {
                    case APPEND: 
                    case VIOLENTLY_REPLACE: {
                        middleTableOperator.append(retainedIdPairs);
                        break;
                    }
                    case UPDATE: 
                    case MERGE: {
                        middleTableOperator.merge(retainedIdPairs);
                        break;
                    }
                    default: {
                        middleTableOperator.replace(retainedIdPairs);
                        break;
                    }
                }
            } else {
                middleTableOperator.append(retainedIdPairs);
            }
        }
    }

    private boolean isReadOnlyMiddleTable(ImmutableProp prop) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            prop = mappedBy;
        }
        if (prop.isMiddleTableDefinition()) {
            MiddleTable middleTable = (MiddleTable)prop.getStorage(this.ctx.options.getSqlClient().getMetadataStrategy());
            return middleTable.isReadonly();
        }
        return false;
    }

    private static boolean isShapeMatched(DraftSpi draft, @Nullable Fetcher<?> fetcher, ShapeMatchContext ctx) {
        if (draft == null) {
            return true;
        }
        if (!ctx.isOptimizable(draft.__type(), fetcher)) {
            return false;
        }
        if (fetcher != null) {
            for (Field field : fetcher.getFieldMap().values()) {
                ImmutableProp prop = field.getProp();
                PropId propId = prop.getId();
                if (!draft.__isLoaded(propId)) {
                    return false;
                }
                if (!prop.isAssociation(TargetLevel.ENTITY) && !prop.isEmbedded(EmbeddedLevel.SCALAR)) continue;
                Fetcher<?> childFetcher = field.getChildFetcher();
                Object associatedValue = draft.__get(propId);
                if (prop.isReferenceList(TargetLevel.ENTITY)) {
                    List list = (List)associatedValue;
                    for (DraftSpi e : list) {
                        if (Saver.isShapeMatched(e, childFetcher, ctx)) continue;
                        return false;
                    }
                    continue;
                }
                if (Saver.isShapeMatched((DraftSpi)associatedValue, childFetcher, ctx)) continue;
                return false;
            }
            for (ImmutableProp prop : draft.__type().getProps().values()) {
                PropId propId = prop.getId();
                if (!draft.__isLoaded(propId)) continue;
                Field field = fetcher.getFieldMap().get(prop.getName());
                if (field == null) {
                    draft.__unload(propId);
                    continue;
                }
                if (!field.isImplicit()) continue;
                draft.__show(propId, false);
            }
        } else {
            for (ImmutableProp prop : draft.__type().getProps().values()) {
                PropId propId = prop.getId();
                if (!draft.__isLoaded(propId)) {
                    return false;
                }
                if (!prop.isAssociation(TargetLevel.ENTITY) && !prop.isEmbedded(EmbeddedLevel.SCALAR)) continue;
                Object associatedValue = draft.__get(propId);
                if (prop.isReferenceList(TargetLevel.ENTITY)) {
                    List list = (List)associatedValue;
                    for (DraftSpi e : list) {
                        if (Saver.isShapeMatched(e, null, ctx)) continue;
                        return false;
                    }
                    continue;
                }
                if (Saver.isShapeMatched((DraftSpi)associatedValue, null, ctx)) continue;
                return false;
            }
        }
        return true;
    }

    private class ShapeMatchContext {
        private final Map<Fetcher<?>, Boolean> optimizableMap = new HashMap();

        private ShapeMatchContext() {
        }

        public boolean isOptimizable(ImmutableType type, @Nullable Fetcher<?> fetcher) {
            if (fetcher != null) {
                return this.optimizableMap.computeIfAbsent(fetcher, this::isOptimizableImpl);
            }
            return ((Saver)Saver.this).ctx.options.getUpsertMask(type) != null;
        }

        private boolean isOptimizableImpl(Fetcher<?> fetcher) {
            boolean matched;
            ImmutableProp prop;
            if (fetcher.getFieldMap().size() == 1 && fetcher.getFieldMap().values().iterator().next().getProp().isId()) {
                return true;
            }
            UpsertMask<?> mask = ((Saver)Saver.this).ctx.options.getUpsertMask(fetcher.getImmutableType());
            if (mask == null) {
                return true;
            }
            if (mask.getInsertablePaths() != null) {
                for (Field field : fetcher.getFieldMap().values()) {
                    prop = field.getProp();
                    matched = false;
                    for (List<ImmutableProp> path : mask.getInsertablePaths()) {
                        if (path.get(0) != prop) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    return false;
                }
            }
            if (mask.getUpdatablePaths() != null) {
                for (Field field : fetcher.getFieldMap().values()) {
                    prop = field.getProp();
                    matched = false;
                    for (List<ImmutableProp> path : mask.getUpdatablePaths()) {
                        if (path.get(0) != prop) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

