/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.ast.impl.mutation.Investigators;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.exception.SaveException;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.SequenceIdGenerator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MutationPath;

class SaveContext
extends MutationContext {
    final SaveOptions options;
    final Connection con;
    final Fetcher<?> fetcher;
    final MutationTrigger trigger;
    final Map<AffectedTable, Integer> affectedRowCountMap;
    final ImmutableProp backReferenceProp;
    final boolean backReferenceFrozen;

    SaveContext(SaveOptions options, Connection con, ImmutableType type, Fetcher<?> fetcher) {
        this(options, con, type, fetcher, options.getTriggers() != null ? new MutationTrigger() : null, new LinkedHashMap<AffectedTable, Integer>());
    }

    SaveContext(SaveOptions options, Connection con, ImmutableType type, Fetcher<?> fetcher, MutationTrigger trigger, Map<AffectedTable, Integer> affectedRowCountMap) {
        super(MutationPath.root(type));
        this.options = options;
        this.con = con;
        this.fetcher = fetcher;
        this.trigger = trigger;
        this.backReferenceProp = null;
        this.backReferenceFrozen = false;
        this.affectedRowCountMap = affectedRowCountMap;
    }

    private SaveContext(SaveContext parent, ImmutableProp prop, ImmutableProp backProp) {
        super(prop != null ? parent.path.to(prop) : parent.path.backFrom(backProp));
        if (prop == null) {
            prop = backProp.getOpposite();
        } else {
            backProp = prop.getOpposite();
        }
        SaveMode saveMode = SaveMode.UPSERT;
        if (prop != null) {
            switch (parent.options.getAssociatedMode(prop)) {
                case APPEND: {
                    saveMode = SaveMode.INSERT_ONLY;
                    break;
                }
                case APPEND_IF_ABSENT: {
                    saveMode = SaveMode.INSERT_IF_ABSENT;
                    break;
                }
                case UPDATE: {
                    saveMode = SaveMode.UPDATE_ONLY;
                    break;
                }
                case VIOLENTLY_REPLACE: {
                    saveMode = prop.isColumnDefinition() ? SaveMode.NON_IDEMPOTENT_UPSERT : SaveMode.INSERT_ONLY;
                }
            }
        }
        this.options = parent.options.withMode(saveMode);
        this.con = parent.con;
        this.fetcher = null;
        this.trigger = parent.trigger;
        if (prop != null) {
            ImmutableProp mappedBy = prop.getMappedBy();
            if (mappedBy != null && mappedBy.isReference(TargetLevel.ENTITY)) {
                this.backReferenceProp = mappedBy;
                this.backReferenceFrozen = prop.getAssociationAnnotation().annotationType() == OneToMany.class && !parent.options.isTargetTransferable(prop);
            } else {
                this.backReferenceProp = null;
                this.backReferenceFrozen = false;
            }
        } else {
            this.backReferenceProp = backProp;
            this.backReferenceFrozen = false;
        }
        this.affectedRowCountMap = parent.affectedRowCountMap;
    }

    private SaveContext(SaveContext base, JSqlClientImplementor sqlClient) {
        super(base.path);
        this.options = base.options.withSqlClient(sqlClient);
        this.con = base.con;
        this.fetcher = base.fetcher;
        this.trigger = base.trigger;
        this.affectedRowCountMap = base.affectedRowCountMap;
        this.backReferenceProp = base.backReferenceProp;
        this.backReferenceFrozen = base.backReferenceFrozen;
    }

    public Object allocateId() {
        IdGenerator idGenerator = this.options.getSqlClient().getIdGenerator(this.path.getType().getJavaClass());
        if (idGenerator == null) {
            throw new SaveException.NoIdGenerator(this.path, "Cannot save \"" + this.path.getType() + "\" without id because id generator is not specified");
        }
        JSqlClientImplementor sqlClient = this.options.getSqlClient();
        if (idGenerator instanceof SequenceIdGenerator) {
            String sql = sqlClient.getDialect().getSelectIdFromSequenceSql(((SequenceIdGenerator)idGenerator).getSequenceName());
            return sqlClient.getExecutor().execute(new Executor.Args<Object>(sqlClient, this.con, sql, Collections.emptyList(), sqlClient.getSqlFormatter().isPretty() ? Collections.emptyList() : null, ExecutionPurpose.MUTATE, this.options.getExceptionTranslator(), null, (stmt, args) -> {
                try (ResultSet rs = stmt.executeQuery();){
                    rs.next();
                    Object object = rs.getObject(1);
                    return object;
                }
            }));
        }
        if (idGenerator instanceof UserIdGenerator) {
            return ((UserIdGenerator)idGenerator).generate(this.path.getType().getJavaClass());
        }
        if (idGenerator instanceof IdentityIdGenerator) {
            return null;
        }
        throw new SaveException.IllegalIdGenerator(this.path, "Illegal id generator type: \"" + idGenerator.getClass().getName() + "\", id generator must be sub type of \"" + SequenceIdGenerator.class.getName() + "\", \"" + IdentityIdGenerator.class.getName() + "\" or \"" + UserIdGenerator.class.getName() + "\"");
    }

    public SaveContext prop(ImmutableProp prop) {
        return new SaveContext(this, prop, null);
    }

    public SaveContext backProp(ImmutableProp backProp) {
        return new SaveContext(this, null, backProp);
    }

    public SaveContext investigator(JSqlClientImplementor sqlClient) {
        return new SaveContext(this, Investigators.toInvestigatorSqlClient(sqlClient, null));
    }

    public SaveContext investigator(Executor.BatchContext ctx) {
        return new SaveContext(this, Investigators.toInvestigatorSqlClient(ctx.sqlClient(), ctx));
    }

    public boolean isIdRetrievingRequired() {
        MutationPath path = this.path;
        if (path.getParent() == null) {
            return false;
        }
        ImmutableProp backProp = path.getBackProp();
        return backProp == null || !backProp.isColumnDefinition();
    }
}

