/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableUpdateImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.meta.LogicalDeletedValueGenerator;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.impl.LogicalDeletedValueGenerators;
import org.babyfish.jimmer.sql.runtime.DissociationInfo;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;

public class MutableDeleteImpl
extends AbstractMutableStatementImpl
implements MutableDelete {
    private final MutableRootQueryImpl<TableEx<?>> deleteQuery;
    private boolean isDissociationDisabled;
    private DeleteMode mode;

    public MutableDeleteImpl(JSqlClientImplementor sqlClient, ImmutableType immutableType) {
        super(sqlClient, immutableType);
        this.deleteQuery = new MutableRootQueryImpl(new StatementContext(ExecutionPurpose.delete(QueryReason.CANNOT_DELETE_DIRECTLY)), sqlClient, immutableType);
        this.mode = DeleteMode.AUTO;
    }

    public MutableDeleteImpl(JSqlClientImplementor sqlClient, TableProxy<?> table) {
        super(sqlClient, table);
        this.deleteQuery = new MutableRootQueryImpl(new StatementContext(ExecutionPurpose.delete(QueryReason.CANNOT_DELETE_DIRECTLY)), sqlClient, table);
        this.mode = DeleteMode.AUTO;
    }

    @Override
    public <T extends TableLike<?>> T getTable() {
        return this.deleteQuery.getTable();
    }

    public TableImplementor<?> getTableLikeImplementor() {
        return (TableImplementor)this.deleteQuery.getTableLikeImplementor();
    }

    @Override
    public AbstractMutableStatementImpl getParent() {
        return null;
    }

    @Override
    public StatementContext getContext() {
        return this.deleteQuery.getContext();
    }

    @Override
    public MutableDelete where(Predicate ... predicates) {
        this.deleteQuery.where(predicates);
        return this;
    }

    @Override
    public void whereByFilter(TableImplementor<?> tableImplementor, List<Predicate> predicates) {
        this.deleteQuery.whereByFilter(tableImplementor, predicates);
    }

    @Override
    public MutableDelete disableDissociation() {
        this.isDissociationDisabled = true;
        return this;
    }

    @Override
    public MutableDelete setMode(DeleteMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public Integer execute(Connection con) {
        return this.getSqlClient().getConnectionManager().execute(con, this::executeImpl);
    }

    @Override
    protected void onFrozen(AstContext astContext) {
        this.deleteQuery.freeze(astContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer executeImpl(Connection con) {
        boolean directly;
        boolean logicalDeleted;
        JSqlClientImplementor sqlClient = this.getSqlClient();
        if (this.getSqlClient().isTargetTransferable()) {
            Executor.validateMutationConnection(con);
        }
        TableLikeImplementor table = this.getTableLikeImplementor();
        AstContext astContext = new AstContext(sqlClient);
        this.deleteQuery.applyVirtualPredicates(astContext);
        this.deleteQuery.applyGlobalFilters(astContext, this.getContext().getFilterLevel(), null);
        this.deleteQuery.freeze(astContext);
        astContext.pushStatement(this.deleteQuery);
        try {
            UseTableVisitor visitor = new UseTableVisitor(astContext);
            visitor.visitStatement(this);
            for (Predicate predicate : this.deleteQuery.unfrozenPredicates()) {
                ((Ast)((Object)predicate)).accept(visitor);
            }
            visitor.allocateAliases();
        }
        finally {
            astContext.popStatement();
        }
        switch (this.mode) {
            case PHYSICAL: {
                logicalDeleted = false;
                break;
            }
            case LOGICAL: {
                if (table.getImmutableType().getLogicalDeletedInfo() == null) {
                    throw new ExecutionException("The mode of the delete statement cannot be \"" + DeleteMode.LOGICAL.name() + "\" because the deleted entity type \"" + table.getImmutableType() + "\" does not support logical deleted");
                }
                logicalDeleted = true;
                break;
            }
            default: {
                logicalDeleted = table.getImmutableType().getLogicalDeletedInfo() != null;
            }
        }
        boolean binLogOnly = sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY;
        DissociationInfo info = sqlClient.getEntityManager().getDissociationInfo(table.getImmutableType());
        boolean bl = directly = table.isEmpty(it -> astContext.getTableUsedState(it.realTable(astContext)) == TableUsedState.USED) && binLogOnly && (this.isDissociationDisabled || info == null || info.isDirectlyDeletable(sqlClient.getMetadataStrategy()));
        if (directly) {
            SqlBuilder builder = new SqlBuilder(astContext);
            astContext.pushStatement(this);
            try {
                this.renderDirectly(builder, logicalDeleted);
                Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
                Integer n = sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.getSqlClient(), con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), (ExecutionPurpose)ExecutionPurpose.delete(QueryReason.NONE), null, null, (stmt, args) -> stmt.executeUpdate()));
                return n;
            }
            finally {
                astContext.popStatement();
            }
        }
        List ids = null;
        List rows = null;
        if (binLogOnly ? (ids = (List)this.deleteQuery.select(table.get(table.getImmutableType().getIdProp())).distinct().execute(con)).isEmpty() : (rows = (List)this.deleteQuery.select(table).execute(con)).isEmpty()) {
            return 0;
        }
        Deleter deleter = new Deleter(table.getImmutableType(), new DeleteCommandImpl.OptionsImpl(sqlClient, con, this.mode), con, binLogOnly ? null : new MutationTrigger(), new HashMap<AffectedTable, Integer>());
        if (ids != null) {
            deleter.addIds(ids);
        } else {
            deleter.addRows(rows);
        }
        return deleter.execute().getTotalAffectedRowCount();
    }

    private void renderDirectly(SqlBuilder builder, boolean logicalDeleted) {
        Predicate predicate = this.deleteQuery.getPredicate(builder.getAstContext());
        TableLikeImplementor table = this.getTableLikeImplementor();
        if (logicalDeleted) {
            LogicalDeletedInfo logicalDeletedInfo = table.getImmutableType().getLogicalDeletedInfo();
            LogicalDeletedValueGenerator generator = LogicalDeletedValueGenerators.of((LogicalDeletedInfo)logicalDeletedInfo, (SqlContext)this.getSqlClient());
            assert (generator != null);
            MutableUpdateImpl update = new MutableUpdateImpl(this.getSqlClient(), this.deleteQuery.getType());
            update.set(PropExpressionImpl.of((Table)update.getTable(), this.deleteQuery.getType().getLogicalDeletedInfo().getProp(), false), generator.generate());
            update.where(this.deleteQuery.getPredicate(builder.getAstContext()));
            update.renderTo(builder);
        } else {
            builder.sql("delete");
            if (this.getSqlClient().getDialect().isDeletedAliasRequired()) {
                ((SqlBuilder)builder.sql(" ")).sql(table.realTable(builder.getAstContext()).getAlias());
            }
            builder.from().sql(table.getImmutableType().getTableName(this.getSqlClient().getMetadataStrategy()));
            if (this.getSqlClient().getDialect().isDeleteAliasSupported()) {
                ((SqlBuilder)builder.sql(" ")).sql(table.realTable(builder.getAstContext()).getAlias());
            }
            if (predicate != null) {
                builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
                ((Ast)((Object)predicate)).renderTo(builder);
                builder.leave();
            }
        }
    }

    public static boolean isCompatible(AbstractMutableStatementImpl a, AbstractMutableStatementImpl b) {
        if (a == b) {
            return true;
        }
        if (a instanceof MutableDeleteImpl) {
            return ((MutableDeleteImpl)a).deleteQuery == b;
        }
        if (b instanceof MutableDeleteImpl) {
            return ((MutableDeleteImpl)b).deleteQuery == a;
        }
        return false;
    }
}

