/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.babyfish.jimmer.sql.ast.impl.mutation.EntityCollection;
import org.jetbrains.annotations.NotNull;

class EsNode<E>
implements EntityCollection.Item<E> {
    final int hash;
    E data;
    E[] originalArr;
    int originalCount;
    EsNode<E> next;
    EsNode<E> before;
    EsNode<E> after;

    EsNode(int hash, E data, EsNode<E> next, EsNode<E> before, EsNode<E> after) {
        this.hash = hash;
        this.data = data;
        this.originalArr = null;
        this.originalCount = 1;
        this.next = next;
        this.before = before;
        this.after = after;
    }

    void merge(E data) {
        int arrLen;
        if (this.data == data) {
            return;
        }
        int n = arrLen = this.originalArr == null ? 1 : this.originalArr.length;
        if (this.originalCount >= arrLen) {
            Object[] arr = new Object[arrLen * 2];
            if (arrLen == 1) {
                arr[0] = this.data;
            } else {
                System.arraycopy(this.originalArr, 0, arr, 0, arrLen);
            }
            this.originalArr = arr;
        }
        assert (this.originalArr != null);
        this.originalArr[this.originalCount++] = data;
        this.data = data;
    }

    @Override
    public E getEntity() {
        return this.data;
    }

    @Override
    public Iterable<E> getOriginalEntities() {
        return new Original();
    }

    public String toString() {
        if (this.originalArr == null) {
            return "{\"entity\":" + this.data + "}";
        }
        return "{entity:" + this.data + ",originalEntities:" + this.getOriginalEntities() + "}";
    }

    private class Original
    implements Iterable<E> {
        private Original() {
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            if (EsNode.this.originalArr == null) {
                return new SingleItr(EsNode.this.data);
            }
            return new MultipleItr(EsNode.this.originalArr, EsNode.this.originalCount);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            boolean addComma = false;
            for (Object e : this) {
                if (addComma) {
                    builder.append(", ");
                } else {
                    addComma = true;
                }
                builder.append(e);
            }
            builder.append(']');
            return builder.toString();
        }
    }

    private static class MultipleItr<E>
    implements Iterator<E> {
        private final E[] arr;
        private final int len;
        private int index;

        MultipleItr(E[] arr, int len) {
            this.arr = arr;
            this.len = len;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.len;
        }

        @Override
        public E next() {
            if (this.index >= this.len) {
                throw new NoSuchElementException();
            }
            return this.arr[this.index++];
        }
    }

    private static class SingleItr<E>
    implements Iterator<E> {
        private E data;

        SingleItr(E data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.data != null;
        }

        @Override
        public E next() {
            E data = this.data;
            if (data == null) {
                throw new NoSuchElementException();
            }
            this.data = null;
            return data;
        }
    }
}

