/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.lang.Lazy;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftPreProcessor;
import org.babyfish.jimmer.sql.KeyUniqueConstraint;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.PreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.Rows;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.Shape;
import org.babyfish.jimmer.sql.ast.impl.mutation.ShapedEntityMap;
import org.babyfish.jimmer.sql.ast.impl.mutation.UpdatePreHandler;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.UnloadedVersionBehavior;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPreHandler
implements PreHandler {
    private static final Object UNLOADED_COLUMN_VALUE = new Object();
    final SaveContext ctx;
    private final DraftPreProcessor<DraftSpi> processor;
    private final DraftInterceptor<Object, DraftSpi> interceptor;
    private final ImmutableProp idProp;
    final KeyMatcher keyMatcher;
    private final ImmutableProp versionProp;
    final Set<Object> validatedIds;
    final List<DraftSpi> draftsWithNothing;
    final List<DraftSpi> draftsWithId = new ArrayList<DraftSpi>();
    final List<DraftSpi> draftsWithKey = new ArrayList<DraftSpi>();
    private Map<Object, ImmutableSpi> idObjMap;
    private Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> keyObjMap;
    private Fetcher<ImmutableSpi> originalFetcher;
    private ShapedEntityMap<DraftSpi> associationMap;
    private boolean resolved;

    AbstractPreHandler(SaveContext ctx) {
        this.ctx = ctx;
        this.processor = ctx.options.getSqlClient().getDraftPreProcessor(ctx.path.getType());
        this.interceptor = ctx.options.getSqlClient().getDraftInterceptor(ctx.path.getType());
        this.idProp = ctx.path.getType().getIdProp();
        this.keyMatcher = ctx.options.getKeyMatcher(ctx.path.getType());
        this.versionProp = ctx.path.getType().getVersionProp();
        this.validatedIds = ctx.path.getProp() != null && ctx.options.isAutoCheckingProp(ctx.path.getProp()) ? new HashSet<Object>() : null;
        this.draftsWithNothing = this.isWildObjectAcceptable() ? new ArrayList<DraftSpi>() : null;
    }

    @Override
    public Iterable<Batch<DraftSpi>> associationBatches() {
        ShapedEntityMap<DraftSpi> am = this.associationMap;
        if (am == null) {
            ArrayList<DraftSpi> drafts = new ArrayList<DraftSpi>();
            for (Batch<DraftSpi> batch : this.batches()) {
                drafts.addAll(batch.entities());
            }
            this.associationMap = am = this.createEntityMap(drafts, null, null, prop -> prop.isId() || prop.isAssociation(TargetLevel.ENTITY) && !prop.isColumnDefinition(), SaveMode.UPSERT, null);
        }
        return am;
    }

    @Override
    public void add(DraftSpi draft) {
        Lazy hasNonIdValues = new Lazy(() -> {
            for (ImmutableProp prop : draft.__type().getProps().values()) {
                if (prop.isId() || !draft.__isLoaded(prop.getId())) continue;
                return true;
            }
            return false;
        });
        ImmutableProp prop = this.ctx.path.getProp();
        if (prop != null && prop.isRemote() && ((Boolean)hasNonIdValues.get()).booleanValue()) {
            this.ctx.throwLongRemoteAssociation();
        }
        if (draft.__isLoaded(draft.__type().getIdProp().getId()) && this.ctx.options.isIdOnlyAsReference(prop) && this.ctx.options.getUnloadedVersionBehavior(draft.__type()) == UnloadedVersionBehavior.IGNORE && !((Boolean)hasNonIdValues.get()).booleanValue()) {
            if (this.validatedIds != null) {
                this.validatedIds.add(draft.__get(draft.__type().getIdProp().getId()));
            }
            return;
        }
        KeyMatcher.Group group = this.keyMatcher.match((Object)draft);
        this.callPreProcessor(draft, group);
        if (draft.__isLoaded(this.idProp.getId())) {
            this.draftsWithId.add(draft);
        } else if (group == null) {
            if (this.draftsWithNothing == null) {
                this.ctx.throwNeitherIdNorKey(draft.__type(), Collections.emptySet());
                return;
            }
            this.draftsWithNothing.add(draft);
        } else {
            this.draftsWithKey.add(draft);
        }
    }

    @Override
    @Nullable
    public Map<Object, ImmutableSpi> originalIdObjMap() {
        return this.idObjMap;
    }

    @Override
    @Nullable
    public Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> originalkeyObjMap() {
        return this.keyObjMap;
    }

    final Map<Object, ImmutableSpi> findOldMapByIds(QueryReason queryReason) {
        Map<Object, ImmutableSpi> idObjMap = this.idObjMap;
        if (idObjMap == null) {
            this.idObjMap = idObjMap = Rows.findMapByIds(this.ctx, queryReason, this.originalFetcher(), this.draftsWithId);
        }
        return idObjMap;
    }

    final Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> findOldMapByKeys(QueryReason queryReason) {
        Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> keyObjMap = this.keyObjMap;
        if (keyObjMap == null) {
            this.keyObjMap = keyObjMap = Rows.findMapByKeys(this.ctx, queryReason, this.originalFetcher(), this.draftsWithKey);
            if (!keyObjMap.isEmpty()) {
                Map<Object, ImmutableSpi> idObjMap = this.idObjMap;
                if (idObjMap == null) {
                    this.idObjMap = idObjMap = new HashMap<Object, ImmutableSpi>();
                }
                PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                for (Map<Object, ImmutableSpi> subMap : keyObjMap.values()) {
                    for (ImmutableSpi row : subMap.values()) {
                        if (!row.__isLoaded(idPropId)) continue;
                        idObjMap.put(row.__get(idPropId), row);
                    }
                }
            }
        }
        return keyObjMap;
    }

    boolean isWildObjectAcceptable() {
        return false;
    }

    private Fetcher<ImmutableSpi> originalFetcher() {
        Fetcher<ImmutableSpi> oldFetcher = this.originalFetcher;
        if (oldFetcher == null) {
            Collection<TypedProp<?, ?>> typedProps;
            ImmutableType type = this.ctx.path.getType();
            Fetcher fetcherImplementor = new FetcherImpl(this.ctx.path.getType().getJavaClass());
            for (ImmutableProp keyProp : this.keyMatcher.getAllProps()) {
                fetcherImplementor = fetcherImplementor.add(keyProp.getName(), IdOnlyFetchType.RAW);
            }
            DraftInterceptor<?, ?> interceptor = this.ctx.options.getSqlClient().getDraftInterceptor(type);
            if (interceptor != null && (typedProps = interceptor.dependencies()) != null) {
                for (TypedProp<?, ?> typedProp : typedProps) {
                    fetcherImplementor = fetcherImplementor.add(typedProp.unwrap().getName(), IdOnlyFetchType.RAW);
                }
            }
            if (this.ctx.backReferenceFrozen) {
                fetcherImplementor = fetcherImplementor.add(this.ctx.backReferenceProp.getName(), IdOnlyFetchType.RAW);
            }
            this.originalFetcher = oldFetcher = fetcherImplementor;
        }
        return oldFetcher;
    }

    final QueryReason queryReason(boolean hasId, Collection<DraftSpi> drafts) {
        boolean clearMode;
        if (this.ctx.trigger != null) {
            return QueryReason.TRIGGER;
        }
        if (this.ctx.backReferenceFrozen) {
            return QueryReason.TARGET_NOT_TRANSFERABLE;
        }
        if (this.interceptor != null) {
            return QueryReason.INTERCEPTOR;
        }
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        SaveMode saveMode = this.ctx.options.getMode();
        boolean bl = clearMode = saveMode == SaveMode.INSERT_ONLY || saveMode == SaveMode.UPDATE_ONLY;
        if (!clearMode && !sqlClient.getDialect().isUpsertSupported()) {
            return QueryReason.UPSERT_NOT_SUPPORTED;
        }
        if (!hasId) {
            if (!clearMode && !this.ctx.options.getSqlClient().getDialect().isNoIdUpsertSupported()) {
                return QueryReason.NO_ID_UPSERT_NOT_SUPPORTED;
            }
            if (saveMode != SaveMode.UPDATE_ONLY) {
                ImmutableProp prop;
                IdGenerator idGenerator = this.ctx.options.getSqlClient().getIdGenerator(this.ctx.path.getType().getJavaClass());
                if (idGenerator == null) {
                    this.ctx.throwNoIdGenerator();
                }
                if ((prop = this.ctx.path.getProp()) != null && this.ctx.options.isKeyOnlyAsReference(prop) && this.isKeyOnly(drafts)) {
                    return QueryReason.KEY_ONLY_AS_REFERENCE;
                }
                if (!(idGenerator instanceof IdentityIdGenerator)) {
                    return QueryReason.IDENTITY_GENERATOR_REQUIRED;
                }
            }
        }
        if (!clearMode) {
            if (saveMode != SaveMode.INSERT_IF_ABSENT && !sqlClient.getDialect().isUpsertWithOptimisticLockSupported()) {
                Object versionProp;
                boolean useOptimisticLock;
                UserOptimisticLock<?, ?> userLock = this.ctx.options.getUserOptimisticLock(this.ctx.path.getType());
                boolean bl2 = useOptimisticLock = userLock != null;
                if (!useOptimisticLock && (versionProp = this.ctx.path.getType().getVersionProp()) != null) {
                    PropId versionPropId = versionProp.getId();
                    for (DraftSpi draftSpi : this.draftsWithId) {
                        if (!draftSpi.__isLoaded(versionPropId)) continue;
                        useOptimisticLock = true;
                        break;
                    }
                }
                if (useOptimisticLock) {
                    if (userLock != null) {
                        return QueryReason.OPTIMISTIC_LOCK;
                    }
                    if (!(this instanceof UpdatePreHandler)) {
                        for (ImmutableProp prop : this.ctx.path.getType().getProps().values()) {
                            if (prop.isId() || !prop.isColumnDefinition()) continue;
                            PropId propId = prop.getId();
                            for (DraftSpi draft : drafts) {
                                if (!draft.__isLoaded(propId)) continue;
                                return QueryReason.OPTIMISTIC_LOCK;
                            }
                        }
                    }
                    PropId versionPropId = this.ctx.path.getType().getVersionProp().getId();
                    for (DraftSpi draft : drafts) {
                        if (!draft.__isLoaded(versionPropId)) continue;
                        return QueryReason.OPTIMISTIC_LOCK;
                    }
                }
            }
            if (!hasId) {
                KeyUniqueConstraint constraint = this.ctx.path.getType().getJavaClass().getAnnotation(KeyUniqueConstraint.class);
                if (constraint == null) {
                    return QueryReason.KEY_UNIQUE_CONSTRAINT_REQUIRED;
                }
                if (!sqlClient.isUpsertWithUniqueConstraintSupported(this.ctx.path.getType())) {
                    return QueryReason.NO_MORE_UNIQUE_CONSTRAINTS_REQUIRED;
                }
                if (!constraint.isNullNotDistinct() || !sqlClient.getDialect().isUpsertWithNullableKeySupported()) {
                    for (Set keyProps : this.keyMatcher.toMap().values()) {
                        ArrayList<PropertyGetter> nullableGetters = new ArrayList<PropertyGetter>();
                        for (PropertyGetter propertyGetter : Shape.fullOf(sqlClient, this.ctx.path.getType().getJavaClass()).getGetters()) {
                            if (!propertyGetter.prop().isNullable() || !keyProps.contains(propertyGetter.prop())) continue;
                            nullableGetters.add(propertyGetter);
                        }
                        if (nullableGetters.isEmpty()) continue;
                        for (DraftSpi draftSpi : drafts) {
                            for (PropertyGetter nullableGetter : nullableGetters) {
                                if (nullableGetter.get(draftSpi) != null) continue;
                                return QueryReason.NULL_NOT_DISTINCT_REQUIRED;
                            }
                        }
                    }
                }
            }
        }
        return QueryReason.NONE;
    }

    private void callPreProcessor(DraftSpi draft, KeyMatcher.Group group) {
        DraftPreProcessor<DraftSpi> processor = this.processor;
        if (processor == null) {
            return;
        }
        if (processor.ignoreIdOnly() && this.ctx.options.isIdOnlyAsReference(this.ctx.path.getProp()) && ImmutableObjects.isIdOnly((Object)draft)) {
            return;
        }
        if (group != null && this.ctx.options.isKeyOnlyAsReference(this.ctx.path.getProp()) && processor.ignoreKeyOnly(group) && this.isKeyOnly(draft, group.getProps())) {
            return;
        }
        processor.beforeSave(draft);
    }

    final void callInterceptor(List<DraftInterceptor.Item<Object, DraftSpi>> items) {
        if (items.isEmpty()) {
            return;
        }
        for (DraftInterceptor.Item item : items) {
            if (item.getState().isIdOnly() && this.ctx.options.isIdOnlyAsReference(this.ctx.path.getProp()) || item.getState().isKeyOnly() && this.ctx.options.isKeyOnlyAsReference(this.ctx.path.getProp()) || item.getOriginal() != null || this.ctx.options.getMode() == SaveMode.UPDATE_ONLY) continue;
            DraftSpi draft = (DraftSpi)item.getDraft();
            this.assignId(draft);
            this.assignVersion(draft);
            this.assignLocalDeletedInfo(draft);
            this.assignDefaultValues(draft);
        }
        DraftInterceptor<Object, DraftSpi> interceptor = this.interceptor;
        if (interceptor == null) {
            return;
        }
        LinkedHashMap<DraftPropKey, Object> linkedHashMap = new LinkedHashMap<DraftPropKey, Object>();
        Iterator itr = items.iterator();
        while (itr.hasNext()) {
            DraftInterceptor.Item item = itr.next();
            DraftSpi draft = (DraftSpi)item.getDraft();
            DraftInterceptor.Item.State state = item.getState();
            if (state.isIdOnly() && interceptor.ignoreIdOnly() && this.ctx.options.isIdOnlyAsReference(this.ctx.path.getProp())) {
                itr.remove();
                continue;
            }
            boolean hasId = AbstractPreHandler.collectColumnValue(draft, this.idProp, linkedHashMap);
            KeyMatcher.Group group = state.getKeyGroup();
            if (state.isKeyOnly()) {
                assert (group != null);
                if (interceptor.ignoreKeyOnly(group) && this.ctx.options.isKeyOnlyAsReference(this.ctx.path.getProp())) {
                    itr.remove();
                    continue;
                }
            }
            if (hasId || group == null) continue;
            for (ImmutableProp keyProp : group.getProps()) {
                AbstractPreHandler.collectColumnValue(draft, keyProp, linkedHashMap);
            }
        }
        if (items.isEmpty()) {
            return;
        }
        interceptor.beforeSaveAll(items);
        for (Map.Entry e : linkedHashMap.entrySet()) {
            DraftPropKey key = (DraftPropKey)e.getKey();
            ImmutableProp prop = key.prop;
            Object value = AbstractPreHandler.columnValue(key.draft, prop);
            if (Objects.equals(e.getValue(), value)) continue;
            this.ctx.throwIllegalInterceptorBehavior(prop);
        }
    }

    private void assignId(DraftSpi draft) {
        PropId idPropId = this.idProp.getId();
        if (draft.__isLoaded(idPropId)) {
            return;
        }
        Object id = this.ctx.allocateId();
        if (id != null) {
            draft.__set(idPropId, id);
        }
    }

    private void assignVersion(DraftSpi draft) {
        ImmutableProp versionProp = this.versionProp;
        if (versionProp == null) {
            return;
        }
        PropId versionPropId = versionProp.getId();
        if (!draft.__isLoaded(versionPropId)) {
            draft.__set(versionPropId, (Object)0);
        }
    }

    private void assignLocalDeletedInfo(DraftSpi draft) {
        LogicalDeletedInfo logicalDeletedInfo = this.ctx.path.getType().getLogicalDeletedInfo();
        if (logicalDeletedInfo == null) {
            return;
        }
        Object value = logicalDeletedInfo.allocateInitializedValue();
        draft.__set(logicalDeletedInfo.getProp().getId(), value);
    }

    void assignDefaultValues(DraftSpi draft) {
    }

    final void resolve() {
        if (!this.resolved) {
            this.validateAloneIds();
            this.onResolve();
            this.resolved = true;
        }
    }

    abstract void onResolve();

    final ShapedEntityMap<DraftSpi> createEntityMap(Iterable<DraftSpi> i1, Iterable<DraftSpi> i2, Iterable<DraftSpi> i3, SaveMode mode, @Nullable SaveMode originalMode) {
        return this.createEntityMap(i1, i2, i3, ImmutableProp::isColumnDefinition, mode, originalMode);
    }

    final ShapedEntityMap<DraftSpi> createEntityMap(Iterable<DraftSpi> i1, Iterable<DraftSpi> i2, Iterable<DraftSpi> i3, java.util.function.Predicate<ImmutableProp> propFilter, SaveMode mode, @Nullable SaveMode originalMode) {
        ShapedEntityMap<DraftSpi> entityMap = new ShapedEntityMap<DraftSpi>(this.ctx.options.getSqlClient(), this.keyMatcher, propFilter, mode, originalMode);
        if (i1 != null) {
            for (DraftSpi draft : i1) {
                entityMap.add(draft);
            }
        }
        if (i2 != null) {
            for (DraftSpi draft : i2) {
                entityMap.add(draft);
            }
        }
        if (i3 != null) {
            for (DraftSpi draft : i3) {
                entityMap.add(draft);
            }
        }
        return entityMap;
    }

    private void validateAloneIds() {
        Set<Object> ids = this.validatedIds;
        if (ids == null || ids.isEmpty()) {
            return;
        }
        ImmutableProp prop = this.ctx.path.getProp();
        if (prop.isRemote()) {
            List<ImmutableSpi> targets;
            PropId targetIdPropId = prop.getTargetType().getIdProp().getId();
            try {
                targets = this.ctx.options.getSqlClient().getMicroServiceExchange().findByIds(prop.getTargetType().getMicroServiceName(), ids, new FetcherImpl(prop.getTargetType().getJavaClass()));
            }
            catch (Exception ex) {
                this.ctx.throwFailedRemoteValidation();
                return;
            }
            if (targets.size() < ids.size()) {
                for (ImmutableSpi target : targets) {
                    ids.remove(target.__get(targetIdPropId));
                }
                throw this.ctx.createIllegalTargetId(ids);
            }
        } else {
            MutableRootQueryImpl q = new MutableRootQueryImpl(this.ctx.options.getSqlClient(), this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.IGNORE_ALL);
            Table table = (Table)((Object)q.getTableLikeImplementor());
            q.where(new Predicate[]{table.getId().in(ids)});
            List actualTargetIds = (List)q.select(table.getId()).execute(this.ctx.con);
            if (actualTargetIds.size() < ids.size()) {
                actualTargetIds.forEach(ids::remove);
                throw this.ctx.createIllegalTargetId(ids);
            }
        }
    }

    private boolean isKeyOnly(Collection<DraftSpi> drafts) {
        for (DraftSpi draft : drafts) {
            if (this.isKeyOnly(draft, this.keyMatcher.matchedKeyProps((Object)draft))) continue;
            return false;
        }
        return true;
    }

    private boolean isKeyOnly(DraftSpi draft, Set<ImmutableProp> keyProps) {
        boolean hasKey = false;
        for (ImmutableProp prop : this.ctx.path.getType().getProps().values()) {
            ImmutableSpi target;
            Object value;
            if (!prop.isColumnDefinition()) continue;
            boolean isLoaded = draft.__isLoaded(prop.getId());
            if (isLoaded && prop.isReference(TargetLevel.PERSISTENT) && (value = draft.__get(prop.getId())) != null && !(target = (ImmutableSpi)value).__isLoaded(target.__type().getIdProp().getId())) {
                isLoaded = false;
            }
            if (keyProps.contains(prop)) {
                if (isLoaded) {
                    hasKey = true;
                    continue;
                }
                return false;
            }
            if (!isLoaded) continue;
            return false;
        }
        return hasKey;
    }

    private static Object columnValue(DraftSpi draft, ImmutableProp prop) {
        PropId propId = prop.getId();
        if (!draft.__isLoaded(propId)) {
            return UNLOADED_COLUMN_VALUE;
        }
        Object value = draft.__get(propId);
        if (value == null || !prop.isReference(TargetLevel.ENTITY)) {
            return value;
        }
        PropId targetIdPropId = prop.getTargetType().getIdProp().getId();
        return ((ImmutableSpi)value).__get(targetIdPropId);
    }

    private static boolean collectColumnValue(DraftSpi draft, ImmutableProp prop, Map<DraftPropKey, Object> valueMap) {
        PropId propId = prop.getId();
        if (!draft.__isLoaded(propId)) {
            return false;
        }
        Object value = draft.__get(propId);
        if (value != null && prop.isReference(TargetLevel.ENTITY)) {
            PropId targetIdPropId = prop.getTargetType().getIdProp().getId();
            value = ((ImmutableSpi)value).__get(targetIdPropId);
        }
        valueMap.put(new DraftPropKey(draft, prop), value);
        return true;
    }

    protected DraftInterceptor.Item<Object, DraftSpi> newItem(DraftSpi draft, @Nullable ImmutableSpi original) {
        boolean idOnly = ImmutableObjects.isIdOnly((Object)draft);
        KeyMatcher.Group group = this.keyMatcher.match((Object)draft);
        boolean keyOnly = group != null && this.isKeyOnly(draft, group.getProps());
        return new DraftInterceptor.Item<ImmutableSpi, DraftSpi>(draft, original, new DraftInterceptor.Item.State(group, idOnly, keyOnly));
    }

    private static class DraftPropKey {
        final DraftSpi draft;
        final ImmutableProp prop;

        private DraftPropKey(DraftSpi draft, ImmutableProp prop) {
            this.draft = draft;
            this.prop = prop;
        }

        public int hashCode() {
            int result = System.identityHashCode(this.draft);
            result = 31 * result + this.prop.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DraftPropKey that = (DraftPropKey)o;
            if (this.draft != that.draft) {
                return false;
            }
            return this.prop.equals((Object)that.prop);
        }
    }
}

