/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.base;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.embedded.AbstractTypedEmbeddedPropExpression;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableExpression;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbol;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.table.BaseTable;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;

public final class BaseTableOwner {
    final BaseTableSymbol baseTable;
    final int index;

    public BaseTableOwner(BaseTable baseTable, int index) {
        Objects.requireNonNull(baseTable, "baseTable cannot be null");
        this.baseTable = baseTable instanceof BaseTableSymbol ? (BaseTableSymbol)baseTable : ((BaseTableImplementor)baseTable).toSymbol();
        this.index = index;
    }

    public BaseTableSymbol getBaseTable() {
        return this.baseTable;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseTableOwner that = (BaseTableOwner)o;
        return this.index == that.index && this.baseTable == that.baseTable;
    }

    public int hashCode() {
        int result = System.identityHashCode(this.baseTable);
        result = 31 * result + Integer.hashCode(this.index);
        return result;
    }

    public String toString() {
        return "BaseTableOwner{index=" + this.index + '}';
    }

    public static BaseTableOwner of(TableLike<?> table) {
        if (table instanceof TableProxy) {
            TableProxy proxy = (TableProxy)table;
            return proxy.__baseTableOwner();
        }
        if (table instanceof TableImplementor) {
            TableImplementor tableImplementor = (TableImplementor)table;
            return tableImplementor.getBaseTableOwner();
        }
        return null;
    }

    public static BaseTableOwner of(Expression<?> expression) {
        if (expression instanceof AbstractTypedEmbeddedPropExpression) {
            AbstractTypedEmbeddedPropExpression embeddedPropExpression = (AbstractTypedEmbeddedPropExpression)expression;
            return embeddedPropExpression.__baseTableOwner();
        }
        if (expression instanceof BaseTableExpression) {
            BaseTableExpression baseTableExpression = (BaseTableExpression)expression;
            return baseTableExpression.getBaseTableOwner();
        }
        return null;
    }
}

