/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

class ReplaceExpression
extends AbstractExpression<String>
implements StringExpressionImplementor {
    private Expression<String> raw;
    private final String target;
    private final String replacement;

    ReplaceExpression(Expression<String> raw, String target, String replacement) {
        this.raw = raw;
        this.target = target;
        this.replacement = replacement;
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.raw)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.sql("replace(");
        ((Ast)((Object)this.raw)).renderTo(builder);
        builder.sql(", ");
        builder.rawVariable(this.target);
        builder.sql(", ");
        builder.rawVariable(this.replacement);
        builder.sql(")");
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return ReplaceExpression.hasVirtualPredicate(this.raw);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.raw = ctx.resolveVirtualPredicate(this.raw);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceExpression that = (ReplaceExpression)o;
        return this.raw.equals(that.raw) && this.target.equals(that.target) && this.replacement.equals(that.replacement);
    }

    public int hashCode() {
        return Objects.hash(this.raw, this.target, this.replacement);
    }
}

