/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.LiteralExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PositionExpression
extends AbstractExpression<Integer>
implements NumericExpressionImplementor<Integer> {
    private Expression<String> subStr;
    private Expression<String> raw;
    @Nullable
    private Expression<Integer> start;

    PositionExpression(Expression<String> subStr, Expression<String> raw, @Nullable Expression<Integer> start) {
        if (start instanceof LiteralExpressionImplementor && ((Integer)((LiteralExpressionImplementor)((Object)start)).getValue()).equals(1)) {
            start = null;
        }
        this.subStr = subStr;
        this.raw = raw;
        this.start = start;
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.raw)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.sqlClient().getDialect().renderPosition(builder, this.precedence(), (Ast)((Object)this.subStr), (Ast)((Object)this.raw), (Ast)((Object)this.start));
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return PositionExpression.hasVirtualPredicate(this.raw);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.subStr = ctx.resolveVirtualPredicate(this.subStr);
        this.raw = ctx.resolveVirtualPredicate(this.raw);
        this.start = ctx.resolveVirtualPredicate(this.start);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionExpression that = (PositionExpression)o;
        return this.subStr.equals(that.subStr) && this.raw.equals(that.raw);
    }

    public int hashCode() {
        return Objects.hash(this.subStr, this.raw);
    }
}

