/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.Constants;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.query.ConfigurableSubQuery;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.jetbrains.annotations.NotNull;

public class ExistsPredicate
extends AbstractPredicate {
    private TypedSubQuery<?> subQuery;
    private final boolean negative;

    public static ExistsPredicate of(MutableSubQuery subQuery, boolean negative) {
        return new ExistsPredicate(subQuery.select(Constants.number(1)), negative);
    }

    public static ExistsPredicate of(TypedSubQuery<?> subQuery, boolean negative) {
        if (subQuery instanceof ConfigurableSubQuery) {
            return new ExistsPredicate(((ConfigurableSubQueryImpl)subQuery).getMutableQuery().select(Constants.number(1)), negative);
        }
        return new ExistsPredicate(subQuery, negative);
    }

    ExistsPredicate(TypedSubQuery<?> subQuery, boolean negative) {
        this.subQuery = subQuery;
        this.negative = negative;
    }

    @Override
    public Predicate not() {
        return new ExistsPredicate(this.subQuery, !this.negative);
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.subQuery)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.sql(this.negative ? "not exists" : "exists");
        this.renderChild((Ast)((Object)this.subQuery), builder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExistsPredicate)) {
            return false;
        }
        ExistsPredicate that = (ExistsPredicate)o;
        return this.negative == that.negative && this.subQuery.equals(that.subQuery);
    }

    public int hashCode() {
        return Objects.hash(this.subQuery, this.negative);
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return ExistsPredicate.hasVirtualPredicate(this.subQuery);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.subQuery = ctx.resolveVirtualPredicate(this.subQuery);
        return this;
    }
}

