/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.ExampleImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.BatchEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SimpleEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.exception.EmptyResultException;
import org.babyfish.jimmer.sql.fetcher.DtoMetadata;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.FetchPath;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherUtil;
import org.babyfish.jimmer.sql.runtime.Converters;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitiesImpl
implements Entities {
    private final JSqlClientImplementor sqlClient;
    private final boolean forUpdate;
    private final Connection con;
    private final ExecutionPurpose purpose;

    public EntitiesImpl(JSqlClientImplementor sqlClient) {
        this(sqlClient, false, null, ExecutionPurpose.QUERY);
    }

    public EntitiesImpl(JSqlClientImplementor sqlClient, boolean forUpdate, Connection con, ExecutionPurpose purpose) {
        this.sqlClient = sqlClient;
        this.forUpdate = forUpdate;
        this.con = con;
        this.purpose = purpose;
    }

    private static ImmutableType immutableTypeOf(Class<?> type) {
        if (View.class.isAssignableFrom(type)) {
            return DtoMetadata.of(type).getFetcher().getImmutableType();
        }
        return ImmutableType.get(type);
    }

    public JSqlClientImplementor getSqlClient() {
        return this.sqlClient;
    }

    public Connection getCon() {
        return this.con;
    }

    public EntitiesImpl forSqlClient(JSqlClientImplementor sqlClient) {
        if (this.sqlClient == sqlClient) {
            return this;
        }
        return new EntitiesImpl(sqlClient, this.forUpdate, this.con, this.purpose);
    }

    @Override
    public Entities forUpdate() {
        if (this.forUpdate) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, true, this.con, this.purpose);
    }

    @Override
    public Entities forConnection(Connection con) {
        if (this.con == con) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, this.forUpdate, con, this.purpose);
    }

    public Entities forLoader() {
        if (this.purpose == ExecutionPurpose.LOAD) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, this.forUpdate, this.con, ExecutionPurpose.LOAD);
    }

    public Entities forExporter() {
        if (this.purpose == ExecutionPurpose.EXPORT) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, this.forUpdate, this.con, ExecutionPurpose.EXPORT);
    }

    public Entities forSaveCommandFetch(QueryReason reason) {
        if (this.purpose instanceof ExecutionPurpose.Command && ((ExecutionPurpose.Command)this.purpose).getQueryReason() == reason) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, this.forUpdate, this.con, ExecutionPurpose.command(reason));
    }

    public <E> E findById(Class<E> type, Object id) {
        return (E)this.sqlClient.getConnectionManager().execute(this.con, con -> this.findById(type, id, (Connection)con));
    }

    @Override
    @NotNull
    public <T> T findOneById(Class<T> type, Object id) {
        T result = this.findById((Class)type, id);
        if (result == null) {
            throw new EmptyResultException();
        }
        return result;
    }

    @Override
    public <T> List<T> findByIds(Class<T> type, Iterable<?> ids) {
        return this.sqlClient.getConnectionManager().execute(this.con, con -> this.findByIds(type, ids, (Connection)con));
    }

    @Override
    public <ID, T> Map<ID, T> findMapByIds(Class<T> type, Iterable<ID> ids) {
        return this.sqlClient.getConnectionManager().execute(this.con, con -> this.findMapByIds(type, ids, (Connection)con));
    }

    @Override
    public <E> E findById(Fetcher<E> fetcher, Object id) {
        return (E)this.sqlClient.getConnectionManager().execute(this.con, con -> this.findById(fetcher, id, (Connection)con));
    }

    @Override
    @NotNull
    public <E> E findOneById(Fetcher<E> fetcher, Object id) {
        E result = this.findById(fetcher, id);
        if (result == null) {
            throw new EmptyResultException();
        }
        return result;
    }

    @Override
    @NotNull
    public <E> List<E> findByIds(Fetcher<E> fetcher, Iterable<?> ids) {
        return this.sqlClient.getConnectionManager().execute(this.con, con -> this.findByIds(fetcher, ids, (Connection)con));
    }

    @NotNull
    public <ID, T> Map<ID, T> findMapByIds(Fetcher<T> fetcher, Iterable<ID> ids) {
        return this.sqlClient.getConnectionManager().execute(this.con, con -> this.findMapByIds(fetcher, ids, (Connection)con));
    }

    private <T> T findById(Class<T> type, Object id, Connection con) {
        if (id instanceof Iterable) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'findByIds'?");
        }
        List<T> rows = this.findByIds(type, null, Collections.singleton(id), con);
        return rows.isEmpty() ? null : (T)rows.get(0);
    }

    private <T> List<T> findByIds(Class<T> type, Iterable<?> ids, Connection con) {
        return this.findByIds(type, null, ids, con);
    }

    private <ID, T> Map<ID, T> findMapByIds(Class<T> type, Iterable<ID> ids, Connection con) {
        PropId idPropId = EntitiesImpl.immutableTypeOf(type).getIdProp().getId();
        List<T> entities = this.findByIds(type, null, ids, con);
        LinkedHashMap<Object, T> map = new LinkedHashMap<Object, T>((entities.size() * 4 + 2) / 3);
        for (T entity : entities) {
            if (View.class.isAssignableFrom(type)) {
                map.put(((ImmutableSpi)((View)entity).toEntity()).__get(idPropId), entity);
                continue;
            }
            map.put(((ImmutableSpi)entity).__get(idPropId), entity);
        }
        return map;
    }

    private <E> E findById(Fetcher<E> fetcher, Object id, Connection con) {
        if (id instanceof Iterable) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'findByIds'?");
        }
        List<E> rows = this.findByIds(fetcher.getJavaClass(), fetcher, Collections.singleton(id), con);
        return rows.isEmpty() ? null : (E)rows.get(0);
    }

    private <E> List<E> findByIds(Fetcher<E> fetcher, Iterable<?> ids, Connection con) {
        return this.findByIds(fetcher.getJavaClass(), fetcher, ids, con);
    }

    private <ID, E> Map<ID, E> findMapByIds(Fetcher<E> fetcher, Iterable<ID> ids, Connection con) {
        ImmutableType type = fetcher.getImmutableType();
        PropId idPropId = type.getIdProp().getId();
        List<E> entities = this.findByIds(type.getJavaClass(), fetcher, ids, con);
        LinkedHashMap<Object, E> map = new LinkedHashMap<Object, E>((entities.size() * 4 + 2) / 3);
        for (E entity : entities) {
            map.put(((ImmutableSpi)entity).__get(idPropId), entity);
        }
        return map;
    }

    private <E> List<E> findByIds(Class<E> type, final Fetcher<E> fetcher, Iterable<?> ids, Connection con) {
        Set<Object> distinctIds = EntitiesImpl.distinctIds(ids);
        if (distinctIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (View.class.isAssignableFrom(type)) {
            return this.findByIds(DtoMetadata.of(type), ids, con);
        }
        ImmutableType immutableType = ImmutableType.get(type);
        Class idClass = immutableType.getIdProp().getElementClass();
        for (Object id : distinctIds) {
            if (Converters.tryConvert(id, idClass) != null) continue;
            throw new IllegalArgumentException("The type of \"" + immutableType.getIdProp() + "\" must be \"" + idClass.getName() + "\", but the actual type is \"" + id.getClass().getName() + "\"");
        }
        Cache cache = this.sqlClient.getCaches().getObjectCache(immutableType);
        if (cache != null) {
            Collection cachedEntities = cache.getAll(distinctIds, new CacheEnvironment(this.sqlClient, con, CacheLoader.objectLoader(this.sqlClient, con, immutableType.getJavaClass()), true)).values();
            ArrayList entities = new ArrayList(cachedEntities.size());
            for (Object entity : cachedEntities) {
                if (entity == null) continue;
                entities.add(entity);
            }
            if (fetcher != null && !entities.isEmpty()) {
                boolean needUnload = false;
                block2: for (ImmutableSpi spi : entities) {
                    for (ImmutableProp prop : immutableType.getProps().values()) {
                        if (!spi.__isLoaded(prop.getId()) || fetcher.getFieldMap().containsKey(prop.getName())) continue;
                        needUnload = true;
                        continue block2;
                    }
                }
                if (needUnload) {
                    ListIterator<ImmutableSpi> itr = entities.listIterator();
                    while (itr.hasNext()) {
                        ImmutableSpi spi;
                        spi = (ImmutableSpi)itr.next();
                        itr.set((ImmutableSpi)Internal.produce((ImmutableType)immutableType, (Object)spi, draft -> {
                            for (ImmutableProp prop : immutableType.getProps().values()) {
                                if (prop.isView() || !spi.__isLoaded(prop.getId()) || fetcher.getFieldMap().containsKey(prop.getName())) continue;
                                ((DraftSpi)draft).__unload(prop.getId());
                            }
                        }));
                    }
                }
                FetcherUtil.fetch(this.sqlClient, con, Collections.singletonList(new FetcherSelection<E>(){

                    @Override
                    public FetchPath getPath() {
                        return null;
                    }

                    @Override
                    public Fetcher<?> getFetcher() {
                        return fetcher;
                    }

                    @Override
                    public PropExpression.Embedded<?> getEmbeddedPropExpression() {
                        return null;
                    }

                    @Override
                    @Nullable
                    public Function<?, E> getConverter() {
                        return null;
                    }
                }), null, entities);
            }
            return entities;
        }
        ConfigurableRootQuery query = Queries.createQuery(this.sqlClient, immutableType, this.purpose, FilterLevel.DEFAULT, (q, table) -> {
            PropExpression idProp = table.get(immutableType.getIdProp().getName());
            if (distinctIds.size() == 1) {
                q.where(new Predicate[]{idProp.eq(distinctIds.iterator().next())});
            } else {
                q.where(new Predicate[]{idProp.in(distinctIds)});
            }
            return q.select(table.fetch(fetcher));
        });
        if (this.forUpdate) {
            query = query.forUpdate(true);
        }
        return (List)query.execute(con);
    }

    private <E> List<E> findByIds(DtoMetadata<?, ?> metadata, Iterable<?> ids, Connection con) {
        Set<Object> distinctIds = EntitiesImpl.distinctIds(ids);
        if (distinctIds.isEmpty()) {
            return Collections.emptyList();
        }
        final Fetcher<?> fetcher = metadata.getFetcher();
        final Function<?, ?> converter = metadata.getConverter();
        ImmutableType immutableType = metadata.getFetcher().getImmutableType();
        Class idClass = immutableType.getIdProp().getElementClass();
        for (Object id : distinctIds) {
            if (Converters.tryConvert(id, idClass) != null) continue;
            throw new IllegalArgumentException("The type of \"" + immutableType.getIdProp() + "\" must be \"" + idClass.getName() + "\"");
        }
        Cache cache = this.sqlClient.getCaches().getObjectCache(immutableType);
        if (cache != null) {
            Collection cachedEntities = cache.getAll(distinctIds, new CacheEnvironment(this.sqlClient, con, CacheLoader.objectLoader(this.sqlClient, con, immutableType.getJavaClass()), true)).values();
            ArrayList entities = new ArrayList(cachedEntities.size());
            for (Object entity : cachedEntities) {
                if (entity == null) continue;
                entities.add(entity);
            }
            if (!entities.isEmpty()) {
                boolean needUnload = false;
                block2: for (ImmutableSpi spi : entities) {
                    for (ImmutableProp prop : immutableType.getProps().values()) {
                        if (!spi.__isLoaded(prop.getId()) || fetcher.getFieldMap().containsKey(prop.getName())) continue;
                        needUnload = true;
                        continue block2;
                    }
                }
                if (needUnload) {
                    ListIterator<ImmutableSpi> itr = entities.listIterator();
                    while (itr.hasNext()) {
                        ImmutableSpi spi;
                        spi = (ImmutableSpi)itr.next();
                        itr.set((ImmutableSpi)Internal.produce((ImmutableType)immutableType, (Object)spi, draft -> {
                            for (ImmutableProp prop : immutableType.getProps().values()) {
                                if (prop.isView() || !spi.__isLoaded(prop.getId()) || fetcher.getFieldMap().containsKey(prop.getName())) continue;
                                ((DraftSpi)draft).__unload(prop.getId());
                            }
                        }));
                    }
                }
                FetcherUtil.fetch(this.sqlClient, con, Collections.singletonList(new FetcherSelection<E>(){

                    @Override
                    public FetchPath getPath() {
                        return null;
                    }

                    @Override
                    public Fetcher<?> getFetcher() {
                        return fetcher;
                    }

                    @Override
                    public PropExpression.Embedded<?> getEmbeddedPropExpression() {
                        return null;
                    }

                    @Override
                    @Nullable
                    public Function<?, E> getConverter() {
                        return converter;
                    }
                }), null, entities);
            }
            return entities;
        }
        ConfigurableRootQuery query = Queries.createQuery(this.sqlClient, immutableType, this.purpose, FilterLevel.DEFAULT, (q, table) -> {
            PropExpression idProp = table.get(immutableType.getIdProp().getName());
            if (distinctIds.size() == 1) {
                q.where(new Predicate[]{idProp.eq(distinctIds.iterator().next())});
            } else {
                q.where(new Predicate[]{idProp.in(distinctIds)});
            }
            return q.select(new FetcherSelectionImpl((Table<?>)table, fetcher, converter));
        });
        if (this.forUpdate) {
            query = query.forUpdate(true);
        }
        return (List)query.execute(con);
    }

    @Override
    public <T> List<T> findAll(Class<T> type) {
        if (View.class.isAssignableFrom(type)) {
            return this.find(DtoMetadata.of(type), null, new TypedProp.Scalar[0]);
        }
        return this.find(ImmutableType.get(type), null, null, new TypedProp.Scalar[0]);
    }

    @Override
    public <T> List<T> findAll(Class<T> type, TypedProp.Scalar<?, ?> ... sortedProps) {
        if (View.class.isAssignableFrom(type)) {
            DtoMetadata metadata = DtoMetadata.of(type);
            return this.find(metadata, null, sortedProps);
        }
        return this.find(ImmutableType.get(type), null, null, sortedProps);
    }

    @Override
    public <E> List<E> findAll(Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.find(fetcher.getImmutableType(), fetcher, null, sortedProps);
    }

    @Override
    public <E> List<E> findByExample(Example<E> example, TypedProp.Scalar<?, ?> ... sortedProps) {
        ExampleImpl exampleImpl = (ExampleImpl)example;
        return this.find(exampleImpl.type(), null, exampleImpl, sortedProps);
    }

    @Override
    public <E> List<E> findByExample(Example<E> example, Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        ExampleImpl exampleImpl = (ExampleImpl)example;
        return this.find(exampleImpl.type(), fetcher, exampleImpl, sortedProps);
    }

    @Override
    public <E, V extends View<E>> List<V> findExample(Class<V> viewType, Example<E> example, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.find(DtoMetadata.of(viewType), (ExampleImpl)example, sortedProps);
    }

    private <E> List<E> find(ImmutableType type, Fetcher<E> fetcher, ExampleImpl<E> example, TypedProp.Scalar<?, ?> ... sortedProps) {
        if (fetcher != null && fetcher.getImmutableType() != type) {
            throw new IllegalArgumentException("The type of fetcher is \"" + fetcher.getImmutableType() + "\", it does not match the query root type \"" + type + "\"");
        }
        if (example != null && example.type() != type) {
            throw new IllegalArgumentException("The type of example is \"" + example.type() + "\", it does not match the query root type \"" + type + "\"");
        }
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, type, ExecutionPurpose.QUERY, FilterLevel.DEFAULT);
        Table table = (Table)query.getTable();
        if (example != null) {
            example.applyTo(query);
        }
        for (TypedProp.Scalar<?, ?> sortedProp : sortedProps) {
            if (!sortedProp.unwrap().getDeclaringType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The sorted field \"" + sortedProp + "\" does not belong to the type \"" + type + "\" or its super types");
            }
            PropExpression expr = table.get(sortedProp.unwrap().getName());
            Order astOrder = sortedProp.isDesc() ? expr.desc() : expr.asc();
            if (sortedProp.isNullsFirst()) {
                astOrder = astOrder.nullsFirst();
            }
            if (sortedProp.isNullsLast()) {
                astOrder = astOrder.nullsLast();
            }
            query.orderBy(new Order[]{astOrder});
        }
        return (List)query.select(fetcher != null ? table.fetch(fetcher) : table).execute(this.con);
    }

    private <V> List<V> find(DtoMetadata<?, ?> metadata, ExampleImpl<?> example, TypedProp.Scalar<?, ?> ... sortedProps) {
        Fetcher<?> fetcher = metadata.getFetcher();
        Function<?, ?> converter = metadata.getConverter();
        ImmutableType type = fetcher.getImmutableType();
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, type, ExecutionPurpose.QUERY, FilterLevel.DEFAULT);
        if (example != null) {
            example.applyTo(query);
        }
        Table table = (Table)query.getTable();
        for (TypedProp.Scalar<?, ?> sortedProp : sortedProps) {
            if (!sortedProp.unwrap().getDeclaringType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The sorted field \"" + sortedProp + "\" does not belong to the type \"" + type + "\" or its super types");
            }
            PropExpression expr = table.get(sortedProp.unwrap().getName());
            Order astOrder = sortedProp.isDesc() ? expr.desc() : expr.asc();
            if (sortedProp.isNullsFirst()) {
                astOrder = astOrder.nullsFirst();
            }
            if (sortedProp.isNullsLast()) {
                astOrder = astOrder.nullsLast();
            }
            query.orderBy(new Order[]{astOrder});
        }
        return (List)query.select(new FetcherSelectionImpl(table, fetcher, converter)).execute(this.con);
    }

    @Override
    public <E> SimpleEntitySaveCommand<E> saveCommand(E entity) {
        if (entity instanceof Iterable) {
            throw new IllegalArgumentException("entity cannot be collection, do you want to call `saveAll/saveAllCommand`?");
        }
        if (entity instanceof Input) {
            throw new IllegalArgumentException("entity cannot be input, please call another overloaded function whose parameter is input");
        }
        return new SimpleEntitySaveCommandImpl<E>(this.sqlClient, this.con, entity);
    }

    @Override
    public <E> BatchEntitySaveCommand<E> saveEntitiesCommand(Iterable<E> entities) {
        for (E e : entities) {
            if (!(e instanceof Input)) continue;
            throw new IllegalArgumentException("the collection cannot contains input, please call another overloaded function `saveInputsCommand`");
        }
        return new BatchEntitySaveCommandImpl<E>(this.sqlClient, this.con, entities);
    }

    @Override
    public DeleteCommand deleteCommand(Class<?> type, Object id) {
        if (id instanceof Iterable) {
            throw new IllegalArgumentException("`id` cannot be iterable, do you want to call `deleteAll/deleteAllCommand`?");
        }
        if (id instanceof ImmutableSpi && ((ImmutableSpi)id).__type().isEntity() || id instanceof Input) {
            throw new IllegalArgumentException("`id` must be simple type");
        }
        return this.deleteAllCommand(type, Collections.singleton(id));
    }

    @Override
    public DeleteCommand deleteAllCommand(Class<?> type, Iterable<?> ids) {
        for (Object id : ids) {
            if ((!(id instanceof ImmutableSpi) || !((ImmutableSpi)id).__type().isEntity()) && !(id instanceof Input)) continue;
            throw new IllegalArgumentException("All the elements of `ids` must be simple type");
        }
        ImmutableType immutableType = EntitiesImpl.immutableTypeOf(type);
        return new DeleteCommandImpl(this.sqlClient, this.con, immutableType, ids);
    }

    private static Set<Object> distinctIds(Iterable<?> values) {
        LinkedHashSet<Object> set;
        if (values == null) {
            return Collections.emptySet();
        }
        if (values instanceof Set && !((Set)values).contains(null)) {
            return (Set)values;
        }
        if (values instanceof Collection) {
            Collection c = (Collection)values;
            if (c.isEmpty()) {
                return Collections.emptySet();
            }
            if (c instanceof Set && !c.contains(null)) {
                return (Set)c;
            }
            set = new LinkedHashSet((c.size() * 4 + 2) / 3);
        } else {
            set = new LinkedHashSet<Object>();
        }
        for (Object value : values) {
            if (value == null) continue;
            set.add(value);
        }
        return set;
    }
}

