/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.associated.VirtualPredicate;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.jetbrains.annotations.NotNull;

public class AssociatedPredicate
extends AbstractPredicate
implements VirtualPredicate {
    private static final Predicate[] EMPTY_PREDICATES = new Predicate[0];
    private final Table<?> parenTable;
    private final ImmutableProp prop;
    private final Function<Table<?>, Predicate> block;

    public AssociatedPredicate(Table<?> parentTable, ImmutableProp prop, Function<Table<?>, Predicate> block) {
        if (prop.getDeclaringType() != parentTable.getImmutableType()) {
            if (!prop.getDeclaringType().isAssignableFrom(parentTable.getImmutableType())) {
                throw new IllegalArgumentException("The property \"" + prop + "\" does not belong to the current type \"" + parentTable.getImmutableType() + "\"");
            }
            prop = parentTable.getImmutableType().getProp(prop.getName());
        }
        if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
            if (prop.isTransient()) {
                throw new IllegalArgumentException("\"" + prop + "\" cannot be transient");
            }
            if (prop.isRemote() && prop.getMappedBy() != null) {
                throw new IllegalArgumentException("\"" + prop + "\" cannot be remote and reversed(with `mappedBy`)");
            }
            throw new IllegalArgumentException("\"" + prop + "\" is not association property of \"" + parentTable.getImmutableType() + "\"");
        }
        this.parenTable = parentTable;
        this.prop = prop;
        this.block = block;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        throw new UnsupportedOperationException("`" + this.getClass().getName() + "` does not support `accept`");
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        throw new UnsupportedOperationException("`" + this.getClass().getName() + "` does not support `renderTo`");
    }

    @Override
    public int precedence() {
        throw new UnsupportedOperationException("`" + this.getClass().getName() + "` does not support `precedence`");
    }

    @Override
    public TableImplementor<?> getTableImplementor(RootTableResolver resolver) {
        if (this.parenTable instanceof TableImplementor) {
            return (TableImplementor)this.parenTable;
        }
        return ((TableProxy)this.parenTable).__resolve(resolver);
    }

    @Override
    public Object getSubKey() {
        return this.prop.getName();
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return true;
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        return ctx.resolveVirtualPredicate(this);
    }

    @Override
    public Predicate toFinalPredicate(AbstractMutableStatementImpl parent, List<VirtualPredicate> virtualPredicates, VirtualPredicate.Op op) {
        ArrayList<Predicate> predicates;
        Table table;
        MutableSubQueryImpl query;
        if (this.parenTable instanceof TableImplementor) {
            query = new MutableSubQueryImpl(parent, this.prop.getTargetType());
            table = (Table)query.getTable();
        } else {
            TableProxy proxy = (TableProxy)TableProxies.fluent(this.prop.getTargetType().getJavaClass());
            query = new MutableSubQueryImpl(parent, proxy);
            table = proxy;
        }
        boolean hasUserPredicates = false;
        if (op == VirtualPredicate.Op.AND) {
            predicates = new ArrayList<Predicate>(virtualPredicates.size());
            predicates.add(null);
            for (VirtualPredicate virtualPredicate : virtualPredicates) {
                Predicate predicate = ((AssociatedPredicate)virtualPredicate).block.apply(table);
                if (predicate == null) continue;
                predicates.add(predicate);
                hasUserPredicates = true;
            }
            if (hasUserPredicates) {
                predicates.set(0, table.inverseGetAssociatedId(this.prop).eq(this.parenTable.getId()));
            }
        } else {
            ArrayList<Predicate> orPredicates = new ArrayList<Predicate>(virtualPredicates.size());
            for (VirtualPredicate virtualPredicate : virtualPredicates) {
                Predicate predicate = ((AssociatedPredicate)virtualPredicate).block.apply(table);
                if (predicate == null) continue;
                orPredicates.add(predicate);
                hasUserPredicates = true;
            }
            if (hasUserPredicates) {
                predicates = new ArrayList();
                predicates.add(table.inverseGetAssociatedId(this.prop).eq(this.parenTable.getId()));
                predicates.add(Predicate.or(orPredicates.toArray(EMPTY_PREDICATES)));
            } else {
                predicates = new ArrayList();
                predicates.add(table.inverseGetAssociatedId(this.prop).eq(this.parenTable.getId()));
            }
        }
        if (!hasUserPredicates) {
            return null;
        }
        query.where(predicates.toArray(EMPTY_PREDICATES));
        return query.exists();
    }
}

