/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.LikeMode;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StringExpression
extends ComparableExpression<String> {
    @NotNull
    default public Predicate like(String pattern) {
        return this.like(pattern, LikeMode.ANYWHERE);
    }

    @Nullable
    default public Predicate likeIf(boolean condition, @Nullable String pattern) {
        return condition && pattern != null && !pattern.isEmpty() ? this.like(pattern, LikeMode.ANYWHERE) : null;
    }

    @Nullable
    default public Predicate likeIf(@Nullable String pattern) {
        return this.likeIf(true, pattern);
    }

    @NotNull
    public Predicate like(String var1, LikeMode var2);

    @Nullable
    default public Predicate likeIf(boolean condition, @Nullable String pattern, LikeMode likeMode) {
        return condition && pattern != null && !pattern.isEmpty() ? this.like(pattern, likeMode) : null;
    }

    @Nullable
    default public Predicate likeIf(@Nullable String pattern, LikeMode likeMode) {
        return this.likeIf(true, pattern, likeMode);
    }

    @NotNull
    default public Predicate ilike(String pattern) {
        return this.ilike(pattern, LikeMode.ANYWHERE);
    }

    @Nullable
    default public Predicate ilikeIf(boolean condition, @Nullable String pattern) {
        return condition && pattern != null && !pattern.isEmpty() ? this.ilike(pattern, LikeMode.ANYWHERE) : null;
    }

    @Nullable
    default public Predicate ilikeIf(@Nullable String pattern) {
        return this.ilikeIf(true, pattern);
    }

    @NotNull
    public Predicate ilike(String var1, LikeMode var2);

    @Nullable
    default public Predicate ilikeIf(boolean condition, @Nullable String pattern, LikeMode likeMode) {
        return condition && pattern != null && !pattern.isEmpty() ? this.ilike(pattern, likeMode) : null;
    }

    @Nullable
    default public Predicate ilikeIf(@Nullable String pattern, LikeMode likeMode) {
        return this.ilikeIf(true, pattern, likeMode);
    }

    public StringExpression upper();

    public StringExpression lower();

    public StringExpression trim();

    public StringExpression ltrim();

    public StringExpression rtrim();

    public NumericExpression<Integer> length();

    public StringExpression replace(String var1, String var2);

    public StringExpression reverse();

    public StringExpression lpad(int var1, String var2);

    public StringExpression lpad(Expression<Integer> var1, String var2);

    public StringExpression rpad(int var1, String var2);

    public StringExpression rpad(Expression<Integer> var1, String var2);

    default public NumericExpression<Integer> position(String substring) {
        return this.position(substring, null);
    }

    default public NumericExpression<Integer> position(String substring, int start) {
        if (start == 1) {
            return this.position(substring);
        }
        return this.position(substring, Literals.number(start));
    }

    public NumericExpression<Integer> position(String var1, Expression<Integer> var2);

    default public StringExpression left(int length) {
        return this.left(Literals.number(length));
    }

    public StringExpression left(Expression<Integer> var1);

    default public StringExpression right(int length) {
        return this.right(Literals.number(length));
    }

    public StringExpression right(Expression<Integer> var1);

    public StringExpression concat(String ... var1);

    @NotNull
    public StringExpression concat(Expression<String> ... var1);

    default public StringExpression substring(int start) {
        return this.substring(Literals.number(start), null);
    }

    default public StringExpression substring(int start, int length) {
        return this.substring(Literals.number(start), Literals.number(length));
    }

    default public StringExpression substring(Expression<Integer> start) {
        return this.substring(start, null);
    }

    public StringExpression substring(Expression<Integer> var1, Expression<Integer> var2);

    @NotNull
    public StringExpression coalesce(String var1);

    @NotNull
    public StringExpression coalesce(Expression<String> var1);

    @Override
    @NotNull
    public CoalesceBuilder.Str coalesceBuilder();
}

